/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.tileentity;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import pl.pabilo8.immersiveintelligence.api.PackerHandler;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeItemStack;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IUpgradableMachine;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.multiblock.MultiblockPacker;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.TileEntityMultiblockIIGeneric;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.util.MultiblockPOI;

public class TileEntityPacker
extends TileEntityMultiblockIIGeneric<TileEntityPacker>
implements ConveyorHandler.IConveyorAttachable,
IEBlockInterfaces.IGuiTile,
IUpgradableMachine,
IEBlockInterfaces.IPlayerInteraction {
    public boolean repeatActions = false;
    protected ArrayList<MachineUpgrade> upgrades = new ArrayList();
    MachineUpgrade currentlyInstalled = null;
    int upgradeProgress = 0;
    public int clientUpgradeProgress = 0;
    public int processTime = 0;
    public ArrayList<PackerHandler.PackerTask> tasks = new ArrayList();
    public IItemHandler containerHandler = new IEInventoryHandler(1, (IIEInventory)this, 0, true, true);
    IItemHandler inventoryInHandler = new IEInventoryHandler(54, (IIEInventory)this, 1, true, true);
    IItemHandler inventoryOutHandler = new IEInventoryHandler(54, (IIEInventory)this, 55, true, true);
    public FluxStorageAdvanced energyStorageUpgrade;
    public MultiFluidTank fluidTank;

    public TileEntityPacker() {
        super(MultiblockPacker.INSTANCE);
        this.energyStorage = new FluxStorageAdvanced(IIConfigHandler.IIConfig.Machines.Packer.energyCapacity);
        this.inventory = NonNullList.func_191197_a((int)109, (Object)ItemStack.field_190927_a);
        this.energyStorageUpgrade = new FluxStorageAdvanced(IIConfigHandler.IIConfig.Machines.Packer.energyCapacityUpgrade);
        this.fluidTank = new MultiFluidTank(IIConfigHandler.IIConfig.Machines.Packer.fluidCapacityUpgrade);
    }

    @Override
    protected void onUpdate() {
        boolean update = false;
        if (!this.getRedstoneAtPos(0) && !this.containerHandler.getStackInSlot(0).func_190926_b()) {
            if (this.processTime < IIConfigHandler.IIConfig.Machines.Packer.actionTime) {
                ItemStack packedItem;
                if (this.processTime == 0) {
                    update = true;
                }
                ++this.processTime;
                if ((double)this.processTime == (double)IIConfigHandler.IIConfig.Machines.Packer.actionTime * 0.5 && !(packedItem = this.containerHandler.getStackInSlot(0)).func_190926_b() && this.energyStorage.getEnergyStored() >= IIConfigHandler.IIConfig.Machines.Packer.energyUsage) {
                    this.energyStorage.extractEnergy(IIConfigHandler.IIConfig.Machines.Packer.energyUsage, false);
                    boolean repeat = true;
                    int repeats = 0;
                    while (repeat) {
                        repeat = false;
                        if (++repeats <= 100) {
                            block6: for (PackerHandler.PackerTask packerTask2 : this.tasks) {
                                boolean isLimited;
                                boolean bl = isLimited = packerTask2.expirationAmount != -1;
                                if (this.field_145850_b.field_72995_K && packerTask2.unpack) break;
                                block0 : switch (packerTask2.actionType) {
                                    case ITEM: {
                                        Optional<Function> handlerFunction = PackerHandler.streamItems().filter(p -> ((Predicate)p.getKey()).test(packedItem)).map(Map.Entry::getValue).findFirst();
                                        if (!handlerFunction.isPresent()) break;
                                        IItemHandler handler = (IItemHandler)handlerFunction.get().apply(packedItem);
                                        IItemHandler handlerIn = packerTask2.unpack ? handler : this.inventoryInHandler;
                                        IItemHandler handlerOut = packerTask2.unpack ? this.inventoryOutHandler : handler;
                                        int slots = Math.min(packerTask2.mode == PackerHandler.PackerPutMode.SLOT ? packerTask2.stack.inputSize : Integer.MAX_VALUE, isLimited ? packerTask2.expirationAmount : Integer.MAX_VALUE);
                                        int amount = Math.min(packerTask2.mode == PackerHandler.PackerPutMode.AMOUNT ? packerTask2.stack.inputSize : Integer.MAX_VALUE, isLimited ? packerTask2.expirationAmount : Integer.MAX_VALUE);
                                        for (int i = 0; i < handlerIn.getSlots(); ++i) {
                                            if ("*".equals(packerTask2.stack.oreName) || packerTask2.stack.matchesItemStackIgnoringSize(handlerIn.extractItem(i, amount, true))) {
                                                ItemStack extracted = handlerIn.extractItem(i, amount, false);
                                                amount -= extracted.func_190916_E();
                                                if (isLimited) {
                                                    packerTask2.expirationAmount = Math.max(0, packerTask2.expirationAmount - extracted.func_190916_E());
                                                }
                                                if ((extracted = ItemHandlerHelper.insertItem((IItemHandler)handlerOut, (ItemStack)extracted, (boolean)false)).func_190916_E() == 0) {
                                                    repeat = this.repeatActions;
                                                }
                                                amount += extracted.func_190916_E();
                                                handlerIn.insertItem(i, extracted, false);
                                                --slots;
                                            }
                                            if (isLimited && packerTask2.expirationAmount <= 0 || slots <= 0) continue block6;
                                            if (amount <= 0) break block0;
                                        }
                                        continue block6;
                                    }
                                    case FLUID: {
                                        Optional<Function> handlerFunction = PackerHandler.streamFluids().filter(p -> ((Predicate)p.getKey()).test(packedItem)).map(Map.Entry::getValue).findFirst();
                                        if (!handlerFunction.isPresent()) break;
                                        IFluidHandlerItem handler = (IFluidHandlerItem)handlerFunction.get().apply(packedItem);
                                        int amount = Math.min(packerTask2.mode == PackerHandler.PackerPutMode.AMOUNT ? packerTask2.stack.inputSize : Integer.MAX_VALUE, isLimited ? packerTask2.expirationAmount : Integer.MAX_VALUE);
                                        if (packerTask2.unpack) {
                                            FluidStack fs = handler.drain(amount, true);
                                            if (fs == null || !"*".equals(packerTask2.stack.oreName) && !fs.isFluidEqual(packerTask2.stack.fluid)) continue block6;
                                            int accepted = this.fluidTank.fill(fs.copy(), true);
                                            fs.amount -= accepted;
                                            handler.fill(fs, true);
                                            break;
                                        }
                                        for (FluidStack fluid : this.fluidTank.fluids) {
                                            if (!"*".equals(packerTask2.stack.oreName) && !fluid.isFluidEqual(packerTask2.stack.fluid)) continue;
                                            FluidStack fs = this.fluidTank.drain(amount, true);
                                            assert (fs != null);
                                            int accepted = handler.fill(fs.copy(), true);
                                            fs.amount -= accepted;
                                            this.fluidTank.fill(fs, true);
                                        }
                                        continue block6;
                                    }
                                    case ENERGY: {
                                        if (packerTask2.unpack) {
                                            int extracted = EnergyHelper.extractFlux((ItemStack)packedItem, (int)10000000, (boolean)false);
                                            int accepted = this.energyStorageUpgrade.receiveEnergy(extracted, false);
                                            EnergyHelper.insertFlux((ItemStack)packedItem, (int)(accepted - extracted), (boolean)false);
                                            break;
                                        }
                                        int extracted = this.energyStorageUpgrade.extractEnergy(10000000, false);
                                        int accepted = EnergyHelper.insertFlux((ItemStack)packedItem, (int)extracted, (boolean)false);
                                        this.energyStorageUpgrade.receiveEnergy(accepted - extracted, false);
                                    }
                                }
                            }
                            this.tasks.removeIf(packerTask -> packerTask.expirationAmount == 0);
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.processTime = 0;
                if (!this.field_145850_b.field_72995_K) {
                    EnumFacing ff = this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e();
                    BlockPos pos = this.getBlockPosForPos(2).func_177967_a(ff, 1);
                    ItemStack output = this.containerHandler.extractItem(0, 64, false);
                    TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
                    if (inventoryTile != null) {
                        output = Utils.insertStackIntoInventory((TileEntity)inventoryTile, (ItemStack)output, (EnumFacing)ff.func_176734_d());
                    }
                    if (!output.func_190926_b()) {
                        Utils.dropStackAtPos((World)this.field_145850_b, (BlockPos)pos, (ItemStack)output);
                    }
                }
                update = true;
            }
        }
        if (this.field_145850_b.field_72995_K) {
            if ((float)this.clientUpgradeProgress < this.getMaxClientProgress()) {
                this.clientUpgradeProgress = (int)Math.min((float)this.clientUpgradeProgress + (float)IIConfigHandler.IIConfig.Tools.wrenchUpgradeProgress / 2.0f, this.getMaxClientProgress());
            }
        } else {
            EnumFacing outputFacing;
            BlockPos pos = this.getBlockPosForPos(15).func_177972_a(this.mirrored ? this.facing.func_176746_e() : this.facing.func_176735_f());
            TileEntity te = this.field_145850_b.func_175625_s(pos);
            EnumFacing enumFacing = outputFacing = this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e();
            if (te != null) {
                IFluidHandler cap;
                if (this.hasUpgrade(IIContent.UPGRADE_PACKER_FLUID)) {
                    if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, outputFacing)) {
                        cap = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, outputFacing);
                        assert (cap != null);
                        for (FluidStack fluid : this.fluidTank.fluids) {
                            FluidStack fs = this.fluidTank.drain(fluid.copy(), false);
                            assert (fs != null);
                            fs.amount -= cap.fill(fs, false);
                            this.fluidTank.fill(fs, false);
                        }
                    }
                } else if (this.hasUpgrade(IIContent.UPGRADE_PACKER_ENERGY)) {
                    if (te.hasCapability(CapabilityEnergy.ENERGY, outputFacing)) {
                        cap = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, outputFacing);
                        assert (cap != null);
                        int n = this.energyStorageUpgrade.extractEnergy(Config.IEConfig.Machines.capacitorHV_output, false);
                        int accepted = cap.receiveEnergy(n, false);
                        this.energyStorageUpgrade.receiveEnergy(accepted - n, false);
                    }
                } else {
                    for (int i = 55; i < this.inventory.size(); ++i) {
                        ItemStack itemStack = (ItemStack)this.inventory.get(i);
                        if (itemStack.func_190926_b()) continue;
                        ItemStack itemStack2 = Utils.insertStackIntoInventory((TileEntity)te, (ItemStack)itemStack, (EnumFacing)this.facing.func_176734_d());
                        this.inventory.set(i, (Object)itemStack2);
                    }
                }
            }
        }
        if (update) {
            this.forceTileUpdate();
        }
    }

    @Override
    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        this.getUpgradesFromNBT(nbt);
        this.repeatActions = nbt.func_74767_n("repeatActions");
        this.processTime = nbt.func_74762_e("process_time");
        if (this.hasUpgrade(IIContent.UPGRADE_PACKER_ENERGY)) {
            this.energyStorage.readFromNBT(nbt.func_74775_l("energy_upgrade"));
        } else if (this.hasUpgrade(IIContent.UPGRADE_PACKER_FLUID)) {
            this.fluidTank.readFromNBT(nbt.func_74775_l("fluid_tank"));
        }
        this.readTasks(nbt.func_150295_c("tasks", 10));
    }

    @Override
    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        this.saveUpgradesToNBT(nbt);
        nbt.func_74757_a("repeatActions", this.repeatActions);
        nbt.func_74768_a("process_time", this.processTime);
        if (this.hasUpgrade(IIContent.UPGRADE_PACKER_ENERGY)) {
            nbt.func_74782_a("energy_upgrade", (NBTBase)this.energyStorage.writeToNBT(new NBTTagCompound()));
        } else if (this.hasUpgrade(IIContent.UPGRADE_PACKER_FLUID)) {
            nbt.func_74782_a("fluid_tank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("tasks", (NBTBase)this.writeTasks());
    }

    @Override
    public void receiveMessageFromServer(@Nonnull NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (message.func_74764_b("inventory")) {
            this.inventory = Utils.readInventory((NBTTagList)message.func_150295_c("inventory", 10), (int)this.inventory.size());
        }
        if (message.func_74764_b("repeatActions")) {
            this.repeatActions = message.func_74767_n("repeatActions");
        }
        if (message.func_74764_b("tasks")) {
            this.readTasks(message.func_150295_c("tasks", 10));
        }
        if (message.func_74764_b("energy_upgrade")) {
            this.processTime = message.func_74762_e("process_time");
        }
        if (message.func_74764_b("energy_upgrade")) {
            this.energyStorage.readFromNBT(message.func_74775_l("energy_upgrade"));
        } else if (message.func_74764_b("fluid_tank")) {
            this.fluidTank.readFromNBT(message.func_74775_l("fluid_tank"));
        }
    }

    public void receiveMessageFromClient(@Nonnull NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (message.func_74764_b("repeatActions")) {
            this.repeatActions = message.func_74767_n("repeatActions");
        }
        if (message.func_74764_b("tasks")) {
            this.readTasks(message.func_150295_c("tasks", 10));
        }
    }

    public NBTTagList writeTasks() {
        NBTTagList tagTasks = new NBTTagList();
        for (PackerHandler.PackerTask task : this.tasks) {
            tagTasks.func_74742_a((NBTBase)task.toNBT());
        }
        return tagTasks;
    }

    private void readTasks(NBTTagList tagTasks) {
        this.tasks.clear();
        for (NBTBase task : tagTasks) {
            if (!(task instanceof NBTTagCompound)) continue;
            this.tasks.add(new PackerHandler.PackerTask((NBTTagCompound)task));
        }
    }

    @Override
    protected int[] listAllPOI(MultiblockPOI poi) {
        switch (poi) {
            case ENERGY_INPUT: {
                return this.getPOI("energy");
            }
            case ITEM_INPUT: 
            case FLUID_INPUT: {
                return this.getPOI("input");
            }
            case ITEM_OUTPUT: 
            case FLUID_OUTPUT: 
            case ENERGY_OUTPUT: {
                return this.getPOI("output");
            }
            case REDSTONE_INPUT: {
                return this.getPOI("redstone");
            }
            case DATA_INPUT: {
                return this.getPOI("data");
            }
        }
        return new int[0];
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return slot == 0 ? 1 : 64;
    }

    @Override
    @Nonnull
    protected IFluidTank[] getAccessibleFluidTanks(@Nonnull EnumFacing side) {
        TileEntityPacker master;
        if ((this.field_174879_c == 23 || this.field_174879_c == 15) && (master = (TileEntityPacker)this.master()) != null && master.hasUpgrade(IIContent.UPGRADE_PACKER_FLUID)) {
            return new IFluidTank[]{master.fluidTank};
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, @Nonnull EnumFacing side, @Nonnull FluidStack resource) {
        if (this.field_174879_c == 23) {
            TileEntityPacker master = (TileEntityPacker)this.master();
            return master != null && master.hasUpgrade(IIContent.UPGRADE_PACKER_FLUID);
        }
        return super.canFillTankFrom(iTank, side, resource);
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, @Nonnull EnumFacing side) {
        if (this.field_174879_c == 15) {
            TileEntityPacker master = (TileEntityPacker)this.master();
            return master != null && master.hasUpgrade(IIContent.UPGRADE_PACKER_FLUID);
        }
        return super.canDrainTankFrom(iTank, side);
    }

    @Override
    public void receiveData(DataPacket packet, int pos) {
        IDataType a = packet.getPacketVariable(Character.valueOf('a'));
        IDataType m = packet.getPacketVariable(Character.valueOf('m'));
        IDataType e = packet.getPacketVariable(Character.valueOf('e'));
        IDataType s = packet.getPacketVariable(Character.valueOf('s'));
        IDataType c = packet.getPacketVariable(Character.valueOf('c'));
        switch (c.valueToString()) {
            case "add": {
                PackerHandler.PackerPutMode mode = PackerHandler.PackerPutMode.fromName(m.valueToString());
                PackerHandler.PackerActionType action = PackerHandler.PackerActionType.fromName(a.valueToString());
                IngredientStack stack = IIUtils.ingredientFromData(s);
                PackerHandler.PackerTask packerTask2 = new PackerHandler.PackerTask(mode, action, stack);
                if (packet.hasVariable(Character.valueOf('e'))) {
                    packerTask2.expirationAmount = packet.getVarInType(DataTypeInteger.class, (IDataType)e).value;
                }
                this.tasks.add(packerTask2);
                break;
            }
            case "remove": {
                if (a instanceof DataTypeInteger) {
                    this.tasks.remove(((DataTypeInteger)a).value);
                    break;
                }
                Predicate<PackerHandler.PackerTask> p = s instanceof DataTypeString ? packerTask -> packerTask.stack.oreName.equals(s.valueToString()) : (s instanceof DataTypeItemStack ? packerTask -> packerTask.stack.equals((Object)IIUtils.ingredientFromData(s)) : packerTask -> true);
                if (packet.hasVariable(Character.valueOf('m'))) {
                    p = p.and(packerTask -> packerTask.mode == PackerHandler.PackerPutMode.fromName(m.valueToString()));
                }
                if (packet.hasVariable(Character.valueOf('a'))) {
                    p = p.and(packerTask -> packerTask.actionType == PackerHandler.PackerActionType.fromName(a.valueToString()));
                }
                this.tasks.removeIf(p);
                break;
            }
            case "clear": {
                this.tasks.clear();
            }
        }
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.master() != null && (this.field_174879_c == 23 || this.field_174879_c == 0);
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        TileEntityPacker master = (TileEntityPacker)this.master();
        if (master != null) {
            if (this.field_174879_c == 0 && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)master.containerHandler;
            }
            if (!(this.hasUpgrade(IIContent.UPGRADE_PACKER_ENERGY) || capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || this.hasUpgrade(IIContent.UPGRADE_PACKER_ENERGY) || this.hasUpgrade(IIContent.UPGRADE_PACKER_FLUID))) {
                if (this.field_174879_c == 23) {
                    return (T)master.inventoryInHandler;
                }
                if (this.field_174879_c == 15) {
                    return (T)master.inventoryOutHandler;
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        TileEntityPacker master = (TileEntityPacker)this.master();
        if (master != null && (this.field_174879_c == 18 || this.field_174879_c == 21 || this.field_174879_c == 22 || this.field_174879_c > 29 && this.field_174879_c < 35 || this.field_174879_c > 41 && this.field_174879_c < 47) && master.hasUpgrade(IIContent.UPGRADE_PACKER_FLUID) && heldItem.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)master.fluidTank)) {
            this.forceTileUpdate();
            return true;
        }
        return false;
    }

    public EnumFacing[] sigOutputDirections() {
        if (this.field_174879_c == 23) {
            return new EnumFacing[]{this.facing};
        }
        if (this.field_174879_c == 15) {
            return new EnumFacing[]{this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e()};
        }
        if (this.field_174879_c == 0) {
            return new EnumFacing[]{this.facing.func_176746_e()};
        }
        return new EnumFacing[0];
    }

    public void onEntityCollision(@Nonnull World world, @Nonnull Entity entity) {
    }

    public void onGuiOpened(EntityPlayer player, boolean clientside) {
        if (!clientside) {
            this.forceTileUpdate();
        }
    }

    public boolean canOpenGui() {
        return true;
    }

    public int getGuiID() {
        return IIGuiList.GUI_PACKER.ordinal();
    }

    @Nullable
    public TileEntity getGuiMaster() {
        return this.master();
    }

    @Override
    public boolean addUpgrade(MachineUpgrade upgrade, boolean test) {
        boolean b;
        boolean bl = b = !this.hasUpgrade(upgrade);
        if (!test && b) {
            this.upgrades.add(upgrade);
        }
        return b;
    }

    @Override
    public boolean hasUpgrade(MachineUpgrade upgrade) {
        return this.upgrades.stream().anyMatch(machineUpgrade -> machineUpgrade.getName().equals(upgrade.getName()));
    }

    @Override
    public boolean upgradeMatches(MachineUpgrade upgrade) {
        return upgrade == IIContent.UPGRADE_PACKER_RAILWAY || upgrade == IIContent.UPGRADE_PACKER_NAMING || upgrade == IIContent.UPGRADE_PACKER_FLUID && !this.hasUpgrade(IIContent.UPGRADE_PACKER_ENERGY) || upgrade == IIContent.UPGRADE_PACKER_ENERGY && !this.hasUpgrade(IIContent.UPGRADE_PACKER_FLUID);
    }

    public TileEntityPacker getUpgradeMaster() {
        return (TileEntityPacker)this.master();
    }

    @Override
    public void saveUpgradesToNBT(NBTTagCompound tag) {
        for (MachineUpgrade upgrade : this.upgrades) {
            tag.func_74757_a(upgrade.getName(), true);
        }
    }

    @Override
    public void getUpgradesFromNBT(NBTTagCompound tag) {
        this.upgrades.clear();
        this.upgrades.addAll(MachineUpgrade.getUpgradesFromNBT(tag));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderWithUpgrades(MachineUpgrade ... upgrades) {
    }

    public ArrayList<MachineUpgrade> getUpgrades() {
        return this.upgrades;
    }

    @Override
    @Nullable
    public MachineUpgrade getCurrentlyInstalled() {
        return this.currentlyInstalled;
    }

    @Override
    public int getInstallProgress() {
        return this.upgradeProgress;
    }

    @Override
    public int getClientInstallProgress() {
        return this.clientUpgradeProgress;
    }

    @Override
    public boolean addUpgradeInstallProgress(int toAdd) {
        this.upgradeProgress += toAdd;
        return true;
    }

    @Override
    public boolean resetInstallProgress() {
        this.currentlyInstalled = null;
        if (this.upgradeProgress > 0) {
            this.upgradeProgress = 0;
            this.clientUpgradeProgress = 0;
            return true;
        }
        Predicate<PackerHandler.PackerTask> task = this.hasUpgrade(IIContent.UPGRADE_PACKER_FLUID) ? p -> p.actionType == PackerHandler.PackerActionType.FLUID : (this.hasUpgrade(IIContent.UPGRADE_PACKER_ENERGY) ? p -> p.actionType == PackerHandler.PackerActionType.ENERGY : p -> p.actionType == PackerHandler.PackerActionType.ITEM);
        this.tasks.removeIf(task.negate());
        return false;
    }

    @Override
    public void startUpgrade(@Nonnull MachineUpgrade upgrade) {
        this.currentlyInstalled = upgrade;
        this.upgradeProgress = 0;
        this.clientUpgradeProgress = 0;
    }

    @Override
    public void removeUpgrade(MachineUpgrade upgrade) {
        this.upgrades.remove(upgrade);
    }
}

