/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.tileentity;

import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.api.data.DataHandlingUtils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.multiblock.MultiblockPrintingPress;
import pl.pabilo8.immersiveintelligence.common.entity.tactile.EntityAMTTactile;
import pl.pabilo8.immersiveintelligence.common.entity.tactile.TactileHandler;
import pl.pabilo8.immersiveintelligence.common.item.ItemIIPrintedPage;
import pl.pabilo8.immersiveintelligence.common.util.IIDamageSources;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;
import pl.pabilo8.immersiveintelligence.common.util.lambda.NBTTagCollector;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.production.TileEntityMultiblockProductionBase;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.production.TileEntityMultiblockProductionMulti;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.util.MultiblockPOI;

public class TileEntityPrintingPress
extends TileEntityMultiblockProductionMulti<TileEntityPrintingPress, PrintOrder>
implements TactileHandler.ITactileListener {
    public static final HashMap<String, Function<DataPacket, PrintOrder>> PRINT_ORDER_PARSERS = new HashMap();
    public static final Function<DataPacket, PrintOrder> ORDER_PARSER_TEXT = packet -> {
        String text = packet.getPacketVariable(Character.valueOf('t')).valueToString();
        int c = 0;
        int m = 0;
        int y = 0;
        int k = 0;
        if (!text.isEmpty()) {
            Pattern pattern = Pattern.compile("<hexcol;([A-Fa-f0-9]{6});(.*?)>");
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                float[] cmykValues = IIUtils.rgbToCmyk(IIUtils.rgbIntToRGB(Integer.parseInt(matcher.group(1).substring(0, 6), 16)));
                c = (int)((float)c + 2.0f * cmykValues[0]);
                m = (int)((float)m + 2.0f * cmykValues[1]);
                y = (int)((float)y + 2.0f * cmykValues[2]);
                k = (int)((float)k + 2.0f * cmykValues[3]);
            }
            k += pattern.matcher(text).replaceAll("").replaceAll(" ", "").length() * 2;
        }
        ItemStack stack = IIContent.itemPrintedPage.getStack(ItemIIPrintedPage.SubItems.TEXT);
        EasyNBT.wrapNBT(stack).withString("text", text);
        return new PrintOrder(stack, k, c, m, y);
    };
    public static final int SLOT_PAPER = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int SLOT_BUCKET_IN = 2;
    public static final int SLOT_BUCKET_OUT = 3;
    public ArrayDeque<QueuedPrintOrder> printQueue = new ArrayDeque();
    public MultiFluidTank tank;
    IItemHandler inputHandler = new IEInventoryHandler(1, (IIEInventory)this, 0, true, true);
    IItemHandler outputHandler = new IEInventoryHandler(1, (IIEInventory)this, 1, true, true);
    TactileHandler tactileHandler = null;

    public TileEntityPrintingPress() {
        super(MultiblockPrintingPress.INSTANCE);
        this.energyStorage = new FluxStorageAdvanced(IIConfigHandler.IIConfig.Machines.PrintingPress.energyCapacity);
        this.tank = new MultiFluidTank(8000);
        this.inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    }

    @Override
    protected void onUpdate() {
        super.onUpdate();
        if (this.tactileHandler == null) {
            this.tactileHandler = new TactileHandler(MultiblockPrintingPress.INSTANCE, (TactileHandler.ITactileListener)this);
        }
        this.tactileHandler.defaultize();
        if (IIUtils.handleBucketTankInteraction(this.tank, (NonNullList<ItemStack>)this.inventory, 2, 3, false, fs -> IIContent.fluidInkBlack.equals(fs.getFluid()) || IIContent.fluidInkCyan.equals(fs.getFluid()) || IIContent.fluidInkMagenta.equals(fs.getFluid()) || IIContent.fluidInkYellow.equals(fs.getFluid()))) {
            this.forceTileUpdate();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        if (nbt.func_74764_b("print_queue")) {
            this.printQueue.clear();
            for (NBTBase entry : nbt.func_150295_c("print_queue", 10)) {
                NBTTagCompound tag = (NBTTagCompound)entry;
                this.printQueue.add(new QueuedPrintOrder(tag.func_74762_e("amount"), new PrintOrder(tag.func_74775_l("order"))));
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        EasyNBT.wrapNBT(nbt).withTag("print_queue", (NBTBase)this.printQueue.stream().map(tuple -> EasyNBT.newNBT().withInt("amount", tuple.amount).withTag("order", (NBTBase)tuple.order.writeToNBT(new NBTTagCompound()))).map(EasyNBT::unwrap).collect(new NBTTagCollector()));
    }

    @Override
    public void receiveMessageFromServer(NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (message.func_74764_b("tank")) {
            this.tank = this.tank.readFromNBT(message.func_74775_l("tank"));
        }
    }

    @Override
    protected int[] listAllPOI(MultiblockPOI poi) {
        switch (poi) {
            case DATA_INPUT: {
                return this.getPOI("data");
            }
            case ENERGY_INPUT: {
                return this.getPOI("energy");
            }
            case ITEM_INPUT: {
                return this.getPOI("paper_input");
            }
            case FLUID_INPUT: {
                return this.getPOI("fluid_input");
            }
            case ITEM_OUTPUT: {
                return this.getPOI("output");
            }
        }
        return new int[0];
    }

    @Override
    public void receiveData(DataPacket packet, int pos) {
        if (packet.getPacketVariable(Character.valueOf('c')).valueToString().equals("callback")) {
            DataPacket response = DataHandlingUtils.handleCallback(packet, var -> {
                switch (var) {
                    case "get_total": {
                        return new DataTypeInteger(this.processQueue.size());
                    }
                    case "get_ink": 
                    case "get_black": {
                        return new DataTypeInteger(this.getStoredFluidAmount(IIContent.fluidInkBlack));
                    }
                    case "get_cyan": {
                        return new DataTypeInteger(this.getStoredFluidAmount(IIContent.fluidInkCyan));
                    }
                    case "get_magenta": {
                        return new DataTypeInteger(this.getStoredFluidAmount(IIContent.fluidInkMagenta));
                    }
                    case "get_yellow": {
                        return new DataTypeInteger(this.getStoredFluidAmount(IIContent.fluidInkYellow));
                    }
                    case "get_energy": {
                        return new DataTypeInteger(this.energyStorage.getEnergyStored());
                    }
                }
                return null;
            });
            IDataConnector conn = IIUtils.findConnectorAround(this.getBlockPosForPos(pos), this.field_145850_b);
            if (conn != null) {
                conn.sendPacket(response);
            }
        } else {
            int amount = DataHandlingUtils.asInt('a', packet);
            if (amount <= 0) {
                return;
            }
            PrintOrder printOrder = PRINT_ORDER_PARSERS.getOrDefault(DataHandlingUtils.asString('m', packet), ORDER_PARSER_TEXT).apply(packet);
            if (printOrder != null) {
                this.printQueue.add(new QueuedPrintOrder(amount, printOrder));
            }
            this.forceTileUpdate();
        }
    }

    private int getStoredFluidAmount(Fluid fluid) {
        return this.tank.fluids.stream().filter(fluidStack -> fluidStack.getFluid() == fluid).mapToInt(fs -> fs.amount).sum();
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return Utils.compareToOreName((ItemStack)stack, (String)"pageEmpty");
            }
            case 1: {
                return Utils.compareToOreName((ItemStack)stack, (String)"pageWritten") || Utils.compareToOreName((ItemStack)stack, (String)"pageEmpty");
            }
            case 2: 
            case 3: {
                return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            }
        }
        return false;
    }

    @Override
    public float getMinProductionOffset() {
        return 0.55f;
    }

    @Override
    public int getMaxProductionQueue() {
        return 2;
    }

    @Override
    protected TileEntityMultiblockProductionBase.IIMultiblockProcess<PrintOrder> findNewProductionProcess() {
        FluidStack[] fs;
        if (this.printQueue.isEmpty()) {
            return null;
        }
        QueuedPrintOrder found = this.printQueue.getFirst();
        if (found.amount-- <= 1) {
            this.printQueue.remove();
        }
        if (!this.isStackValid(0, (ItemStack)this.inventory.get(0))) {
            return null;
        }
        for (FluidStack f : fs = new FluidStack[]{new FluidStack(IIContent.fluidInkBlack, found.order.blackCost), new FluidStack(IIContent.fluidInkCyan, found.order.cyanCost), new FluidStack(IIContent.fluidInkMagenta, found.order.magentaCost), new FluidStack(IIContent.fluidInkYellow, found.order.yellowCost)}) {
            if (f.amount == 0 || f.isFluidEqual(this.tank.drain(f, false))) continue;
            return null;
        }
        this.inputHandler.extractItem(0, 1, false);
        for (FluidStack f : fs) {
            this.tank.drain(f, true);
        }
        return new TileEntityMultiblockProductionBase.IIMultiblockProcess<PrintOrder>(found.order);
    }

    @Override
    public float getProductionStep(TileEntityMultiblockProductionBase.IIMultiblockProcess<PrintOrder> process, boolean simulate) {
        int perTick = ((PrintOrder)process.recipe).getTotalProcessEnergy() / process.maxTicks;
        if (this.energyStorage.extractEnergy(perTick, simulate) < perTick) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    protected boolean attemptProductionOutput(TileEntityMultiblockProductionBase.IIMultiblockProcess<PrintOrder> process) {
        this.outputOrDrop(((PrintOrder)process.recipe).result, this.outputHandler, this.facing, this.getPOI("output"));
        return true;
    }

    @Override
    protected void onProductionFinish(TileEntityMultiblockProductionBase.IIMultiblockProcess<PrintOrder> process) {
    }

    @Override
    public IIGuiList getGUI() {
        return IIGuiList.GUI_PRINTING_PRESS;
    }

    @Override
    protected IFluidTank[] getFluidTanks(int pos, EnumFacing side) {
        return new IFluidTank[]{this.tank};
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        if (super.canFillTankFrom(iTank, side, resource)) {
            return IIContent.fluidInkBlack.equals(resource.getFluid()) || IIContent.fluidInkCyan.equals(resource.getFluid()) || IIContent.fluidInkMagenta.equals(resource.getFluid()) || IIContent.fluidInkYellow.equals(resource.getFluid());
        }
        return false;
    }

    @Override
    protected boolean isTankAvailable(int pos, int tank) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return slot == 1 ? 12 : super.getSlotLimit(slot);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((TileEntityPrintingPress)this.master()).inputHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    @Nullable
    public TactileHandler getTactileHandler() {
        return this.tactileHandler;
    }

    @Override
    public World getTactileWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getTactilePos() {
        return this.func_174877_v();
    }

    @Override
    public EnumFacing getTactileFacing() {
        return this.facing;
    }

    @Override
    public boolean getIsTactileMirrored() {
        return this.mirrored;
    }

    @Override
    public boolean onTactileCollide(EntityAMTTactile tactile, Entity entity) {
        entity.func_70097_a(IIDamageSources.PRINTING_PRESS_DAMAGE, 1.5f);
        return false;
    }

    static {
        PRINT_ORDER_PARSERS.put("text", ORDER_PARSER_TEXT);
    }

    public static class PrintOrder
    implements TileEntityMultiblockProductionBase.IIIMultiblockRecipe {
        int blackCost;
        int cyanCost;
        int magentaCost;
        int yellowCost;
        ItemStack result;

        public PrintOrder(ItemStack result, int blackCost, int cyanCost, int magentaCost, int yellowCost) {
            this.result = result;
            this.blackCost = blackCost;
            this.cyanCost = cyanCost;
            this.magentaCost = magentaCost;
            this.yellowCost = yellowCost;
        }

        public PrintOrder(NBTTagCompound nbt) {
            this.loadFromNBT(nbt);
        }

        PrintOrder loadFromNBT(NBTTagCompound nbt) {
            this.result = new ItemStack(nbt.func_74775_l("result"));
            this.blackCost = nbt.func_74762_e("black");
            this.cyanCost = nbt.func_74762_e("cyan");
            this.magentaCost = nbt.func_74762_e("magenta");
            this.yellowCost = nbt.func_74762_e("yellow");
            return this;
        }

        @Override
        public int getTotalProcessTime() {
            return IIConfigHandler.IIConfig.Machines.PrintingPress.printTime;
        }

        @Override
        public int getTotalProcessEnergy() {
            return IIConfigHandler.IIConfig.Machines.PrintingPress.energyUsage;
        }

        @Override
        public int getMultipleProcessTicks() {
            return 0;
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.func_74782_a("result", (NBTBase)this.result.serializeNBT());
            nbt.func_74768_a("black", this.blackCost);
            nbt.func_74768_a("cyan", this.cyanCost);
            nbt.func_74768_a("magenta", this.magentaCost);
            nbt.func_74768_a("yellow", this.yellowCost);
            return nbt;
        }
    }

    public static class QueuedPrintOrder {
        int amount;
        PrintOrder order;

        public QueuedPrintOrder(int amount, PrintOrder order) {
            this.amount = amount;
            this.order = order;
        }
    }
}

