/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock1.tileentity;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import pl.pabilo8.immersiveintelligence.api.VehicleFuelHandler;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock1.multiblock.MultiblockFuelStation;
import pl.pabilo8.immersiveintelligence.common.network.IIMessage;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageIITileSync;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class TileEntityFuelStation
extends TileEntityMultiblockMetal<TileEntityFuelStation, IMultiblockRecipe>
implements IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.ISoundTile {
    public MultiFluidTank[] tanks = new MultiFluidTank[]{new MultiFluidTank(IIConfigHandler.IIConfig.Machines.FuelStation.fluidCapacity)};
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    float inserterAnimation = 0.0f;
    float inserterAngle = 0.0f;
    float inserterDistance = 0.0f;
    Entity focusedEntity = null;

    public TileEntityFuelStation() {
        super((MultiblockHandler.IMultiblock)MultiblockFuelStation.INSTANCE, new int[]{3, 3, 2}, IIConfigHandler.IIConfig.Machines.FuelStation.energyCapacity, true);
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank"));
        if (!descPacket) {
            this.inventory = Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)4);
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (message.func_74764_b("tank")) {
            this.tanks[0].readFromNBT(message.func_74775_l("tank"));
        }
        if (message.func_74764_b("inventory")) {
            this.inventory = Utils.readInventory((NBTTagList)message.func_150295_c("inventory", 10), (int)4);
        }
        this.focusedEntity = message.func_74764_b("focused") ? this.field_145850_b.func_73045_a(message.func_74762_e("focused")) : null;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.inserterAnimation = this.calculateInserterAnimation(0.0f);
            this.inserterAngle = this.calculateInserterAngle(0.0f);
            ImmersiveEngineering.proxy.handleTileSound(IISounds.fuelStationMid, (TileEntity)this, (double)this.inserterAnimation > 0.35 && this.focusedEntity != null, 0.5f, 1.0f);
        } else {
            boolean update = IIUtils.handleBucketTankInteraction((IFluidTank[])this.tanks, this.inventory, (int)0, (int)1, (int)0, (boolean)false);
            if (update) {
                IIPacketHandler.sendToClient((TileEntity)this, (IIMessage)new MessageIITileSync((TileEntityIEBase)this, EasyNBT.newNBT().withTag("inventory", (NBTBase)Utils.writeInventory(this.inventory)).withTag("tank", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()))));
            }
        }
        Vec3d vx = new Vec3d(this.facing.func_176734_d().func_176730_m()).func_186678_a(1.5).func_178787_e(new Vec3d(this.facing.func_176746_e().func_176730_m()));
        List entitiesWithinAABB = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(this.getBlockPosForPos(0)).func_72321_a(vx.field_72450_a, vx.field_72448_b, vx.field_72449_c).func_72321_a(0.0, 1.5, 0.0).func_72321_a(0.0, -1.5, 0.0));
        entitiesWithinAABB.removeIf(entity -> !VehicleFuelHandler.isValidVehicle(entity));
        if (entitiesWithinAABB.size() > 0) {
            if (entitiesWithinAABB.contains(this.focusedEntity)) {
                IFluidHandler capability = (IFluidHandler)this.focusedEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                if (capability != null) {
                    boolean canFill = false;
                    for (FluidStack fluid : this.tanks[0].fluids) {
                        if (!VehicleFuelHandler.isFuelValidForVehicle(this.focusedEntity, fluid.getFluid())) continue;
                        FluidStack fs = new FluidStack(fluid, Math.min(fluid.amount, IIConfigHandler.IIConfig.Machines.FuelStation.fluidTransfer));
                        int i = capability.fill(fs, false);
                        i = this.energyStorage.extractEnergy(i * IIConfigHandler.IIConfig.Machines.FuelStation.energyUsage, false) / IIConfigHandler.IIConfig.Machines.FuelStation.energyUsage;
                        capability.fill(new FluidStack(fs, i), true);
                        this.tanks[0].drain(new FluidStack(fs, i), true);
                        if (i <= 0) break;
                        canFill = true;
                        break;
                    }
                    if (!canFill) {
                        this.focusedEntity = null;
                        IIPacketHandler.sendToClient((TileEntity)this, (IIMessage)new MessageIITileSync((TileEntityIEBase)this, this.makeSyncEntity()));
                        this.field_145850_b.func_184133_a(null, this.func_174877_v().func_177984_a(), IISounds.fuelStationEnd, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    }
                }
            } else {
                Entity entity2;
                IFluidHandler capability;
                Iterator iterator = entitiesWithinAABB.iterator();
                while (iterator.hasNext() && (capability = (IFluidHandler)(entity2 = (Entity)iterator.next()).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) != null) {
                    boolean canFill = false;
                    for (FluidStack fluid : this.tanks[0].fluids) {
                        FluidStack fs;
                        if (!VehicleFuelHandler.isFuelValidForVehicle(entity2, fluid.getFluid()) || capability.fill(fs = new FluidStack(fluid, Math.min(fluid.amount, IIConfigHandler.IIConfig.Machines.FuelStation.fluidTransfer)), false) <= 0) continue;
                        canFill = true;
                        break;
                    }
                    if (!canFill) continue;
                    this.focusedEntity = entity2;
                    this.inserterAnimation = 0.0f;
                    IIPacketHandler.sendToClient((TileEntity)this, (IIMessage)new MessageIITileSync((TileEntityIEBase)this, this.makeSyncEntity()));
                    this.field_145850_b.func_184133_a(null, this.func_174877_v().func_177984_a(), IISounds.fuelStationStart, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    break;
                }
            }
        } else if (this.focusedEntity != null) {
            this.focusedEntity = null;
            this.inserterAnimation = 0.0f;
            IIPacketHandler.sendToClient((TileEntity)this, (IIMessage)new MessageIITileSync((TileEntityIEBase)this, this.makeSyncEntity()));
            this.field_145850_b.func_184133_a(null, this.func_174877_v().func_177984_a(), IISounds.fuelStationEnd, SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
    }

    private NBTTagCompound makeSyncEntity() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.focusedEntity != null) {
            tag.func_74768_a("focused", this.focusedEntity.func_145782_y());
        } else {
            tag.func_74757_a("hasNoFocus", true);
        }
        return tag;
    }

    public float calculateInserterAnimation(float partialTicks) {
        float anim = this.focusedEntity != null ? Math.min(this.inserterAnimation + 0.05f * (1.0f + partialTicks), 1.0f) : Math.max(this.inserterAnimation - 0.025f * (1.0f + partialTicks), 0.0f);
        return anim;
    }

    public float calculateInserterAngle(float partialTicks) {
        if (this.focusedEntity != null) {
            Vec3d vec3d = this.focusedEntity.func_174791_d().func_178788_d(new Vec3d((Vec3i)this.getBlockPosForPos(1)).func_72441_c(0.5, 0.0, 0.5));
            float yaw = vec3d.field_72450_a < 0.0 && vec3d.field_72449_c >= 0.0 ? (float)(Math.atan(Math.abs(vec3d.field_72450_a / vec3d.field_72449_c)) / Math.PI * 180.0) : (vec3d.field_72450_a <= 0.0 && vec3d.field_72449_c <= 0.0 ? (float)(Math.atan(Math.abs(vec3d.field_72449_c / vec3d.field_72450_a)) / Math.PI * 180.0) + 90.0f : (vec3d.field_72450_a >= 0.0 && vec3d.field_72449_c < 0.0 ? (float)(Math.atan(Math.abs(vec3d.field_72450_a / vec3d.field_72449_c)) / Math.PI * 180.0) + 180.0f : (float)(Math.atan(Math.abs(vec3d.field_72449_c / vec3d.field_72450_a)) / Math.PI * 180.0) + 270.0f));
            return yaw;
        }
        return this.inserterAngle;
    }

    public float calculateDistance(float partialTicks) {
        if (this.focusedEntity != null) {
            double v = this.focusedEntity.func_174791_d().func_72438_d(new Vec3d((Vec3i)this.getBlockPosForPos(1)).func_72441_c(0.5, 0.0, 0.5));
            this.inserterDistance = 0.125f + (float)(v / 2.0 * 0.75);
        }
        return this.inserterDistance;
    }

    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public int[] getEnergyPos() {
        return new int[]{6};
    }

    public int[] getRedstonePos() {
        return new int[0];
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public int[] getOutputSlots() {
        return new int[]{1};
    }

    public int[] getOutputTanks() {
        return new int[0];
    }

    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return false;
    }

    public void doProcessOutput(ItemStack output) {
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    public int getMaxProcessPerTick() {
        return 0;
    }

    public int getProcessQueueMaxLength() {
        return 0;
    }

    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.0f;
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntityFuelStation master = (TileEntityFuelStation)this.master();
        if (master != null && this.field_174879_c == 10 && (side == this.facing || side == this.facing.func_176735_f())) {
            return new MultiFluidTank[]{master.tanks[0]};
        }
        return new MultiFluidTank[0];
    }

    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        if (this.field_174879_c == 10 && (side == this.facing || side == this.facing.func_176735_f())) {
            TileEntityFuelStation master = (TileEntityFuelStation)this.master();
            return master != null && master.tanks[iTank].getFluidAmount() < master.tanks[iTank].getCapacity();
        }
        return false;
    }

    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return null;
    }

    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        if (this.field_174879_c == 0 || this.field_174879_c == 1) {
            list.add(new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 0.9375, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            switch (this.mirrored ^ this.field_174879_c == 1 ? this.facing.func_176734_d() : this.facing) {
                case NORTH: {
                    list.add(new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.25, 0.75, 0.25).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.0625, 0.0, 0.75, 0.25, 0.75, 0.9375).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    break;
                }
                case SOUTH: {
                    list.add(new AxisAlignedBB(0.75, 0.0, 0.0625, 0.9375, 0.75, 0.25).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.75, 0.0, 0.75, 0.9375, 0.75, 0.9375).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    break;
                }
                case EAST: {
                    list.add(new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.25, 0.75, 0.25).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.75, 0.0, 0.0625, 0.9375, 0.75, 0.25).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    break;
                }
                case WEST: {
                    list.add(new AxisAlignedBB(0.0625, 0.0, 0.75, 0.25, 0.75, 0.9375).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.75, 0.0, 0.75, 0.9375, 0.75, 0.9375).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                }
            }
        } else if (this.field_174879_c == 6) {
            list.add(new AxisAlignedBB(0.25, 0.375, 0.25, 0.75, 1.0, 0.75).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            list.add(new AxisAlignedBB(0.125, 0.25, 0.125, 0.875, 0.375, 0.875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            list.add(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.25, 0.75).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
        } else if (this.field_174879_c == 7) {
            list.add(new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.0625, 0.875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
        }
        return list;
    }

    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    public boolean canOpenGui() {
        return true;
    }

    public int getGuiID() {
        return IIGuiList.GUI_FUEL_STATION.ordinal();
    }

    @Nullable
    public TileEntity getGuiMaster() {
        return this.master();
    }

    public boolean shoudlPlaySound(String sound) {
        return true;
    }
}

