/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock1.tileentity;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmoComponent;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmoCore;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataDevice;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.utils.IBooleanAnimatedPartsBlock;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IUpgradableMachine;
import pl.pabilo8.immersiveintelligence.client.render.multiblock.metal.ProjectileWorkshopRenderer;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock1.multiblock.MultiblockProjectileWorkshop;
import pl.pabilo8.immersiveintelligence.common.network.IIMessage;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageBooleanAnimatedPartsSync;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageIITileSync;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class TileEntityProjectileWorkshop
extends TileEntityMultiblockMetal<TileEntityProjectileWorkshop, IMultiblockRecipe>
implements IEBlockInterfaces.ISoundTile,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds,
IUpgradableMachine,
IBooleanAnimatedPartsBlock,
ConveyorHandler.IConveyorAttachable,
IDataDevice {
    MachineUpgrade currentlyInstalled = null;
    int upgradeProgress = 0;
    @Nonnull
    public IAmmo producedBullet = IIContent.itemAmmoArtillery;
    @Nonnull
    public AmmoRegistry.EnumCoreTypes coreType = this.producedBullet.getAllowedCoreTypes()[0];
    public boolean fillerUpgrade = false;
    public int fillAmount = 1;
    public BulletComponentStack componentInside = new BulletComponentStack();
    public int productionProgress = 0;
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    public FluidTank[] tanksFactory = new FluidTank[]{new FluidTank(IIConfigHandler.IIConfig.Machines.ProjectileWorkshop.coolantTankCapacity)};
    public FluidTank[] tanksFiller = new FluidTank[]{new FluidTank(IIConfigHandler.IIConfig.Machines.ProjectileWorkshop.componentTankCapacity)};
    IItemHandler inputHandler = new IEInventoryHandler(1, (IIEInventory)this, 0, true, false);
    IItemHandler componentInputHandler = new IEInventoryHandler(1, (IIEInventory)this, 1, true, false);
    public boolean[] isDrawerOpened = new boolean[]{false, false};
    public float[] drawerAngle = new float[]{0.0f, 0.0f};
    public ItemStack effect = ItemStack.field_190927_a;

    public TileEntityProjectileWorkshop() {
        super((MultiblockHandler.IMultiblock)MultiblockProjectileWorkshop.INSTANCE, MultiblockProjectileWorkshop.INSTANCE.getSize(), IIConfigHandler.IIConfig.Machines.ProjectileWorkshop.energyCapacity, true);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.drawerAngle[i] = MathHelper.func_76131_a((float)(this.drawerAngle[i] + (float)(this.isDrawerOpened[i] ? 1 : -1)), (float)0.0f, (float)20.0f);
            }
        }
        boolean update = false;
        if (this.field_145850_b.func_175640_z(this.getBlockPosForPos(this.getRedstonePos()[0])) ^ this.redstoneControlInverted) {
            return;
        }
        if (this.fillerUpgrade) {
            if (this.tanksFiller[0].getFluidAmount() >= 1000 || !((ItemStack)this.inventory.get(1)).func_190926_b()) {
                if (this.componentInside.amount < IIConfigHandler.IIConfig.Machines.ProjectileWorkshop.componentCapacity) {
                    Object name;
                    if (this.componentInside.isEmpty()) {
                        if (this.tanksFiller[0].getFluidAmount() >= 1000) {
                            name = Objects.requireNonNull(this.tanksFiller[0].getFluid()).getUnlocalizedName();
                            AmmoRegistry.INSTANCE.registeredComponents.values().stream().filter(arg_0 -> TileEntityProjectileWorkshop.lambda$update$0((String)name, arg_0)).findFirst().ifPresent(iBulletComponent -> {
                                this.componentInside = new BulletComponentStack((IAmmoComponent)iBulletComponent, this.tanksFiller[0].getFluid().tag);
                            });
                            update = true;
                        } else {
                            AmmoRegistry.INSTANCE.registeredComponents.values().stream().filter(comp -> comp.getMaterial().matchesItemStackIgnoringSize((ItemStack)this.inventory.get(1))).findFirst().ifPresent(comp -> {
                                this.componentInside = new BulletComponentStack((IAmmoComponent)comp, ((ItemStack)this.inventory.get(1)).func_77978_p());
                            });
                            update = true;
                        }
                    } else if (this.componentInside.isFluid()) {
                        if (this.tanksFiller[0].getFluidAmount() >= 1000 && this.componentInside.matches(this.tanksFiller[0].getFluid())) {
                            name = this.componentInside;
                            ((BulletComponentStack)name).amount = ((BulletComponentStack)name).amount + 16;
                            this.tanksFiller[0].drain(1000, true);
                            update = true;
                        }
                    } else if (this.componentInside.matches((ItemStack)this.inventory.get(1))) {
                        name = this.componentInside;
                        ((BulletComponentStack)name).amount = ((BulletComponentStack)name).amount + 16;
                        ((ItemStack)this.inventory.get(1)).func_190918_g(1);
                        update = true;
                    }
                }
                if (this.productionProgress <= 0) {
                    if (!((ItemStack)this.inventory.get(0)).func_190926_b() && !this.componentInside.isEmpty()) {
                        this.effect = ((ItemStack)this.inventory.get(0)).func_77946_l();
                        this.effect.func_190920_e(1);
                        IAmmo bullet = (IAmmo)this.effect.func_77973_b();
                        if (this.componentInside.matches(bullet)) {
                            this.productionProgress = (int)((double)IIConfigHandler.IIConfig.Machines.ProjectileWorkshop.fillingTime + (double)IIConfigHandler.IIConfig.Machines.ProjectileWorkshop.fillingTime * 0.3 * (double)bullet.getCaliber());
                            for (int i = 0; i < this.fillAmount && bullet.hasFreeComponentSlots(this.effect); ++i) {
                                bullet.addComponents(this.effect, AmmoRegistry.INSTANCE.getComponent(this.componentInside.name), this.componentInside.tagCompound);
                                this.componentInside.subtract(1);
                            }
                        } else {
                            this.productionProgress = 1;
                        }
                        ((ItemStack)this.inventory.get(0)).func_190918_g(1);
                        update = true;
                    }
                } else {
                    --this.productionProgress;
                    if (this.productionProgress == 0) {
                        if (!this.field_145850_b.field_72995_K) {
                            this.outputItem(this.effect);
                            this.effect = ItemStack.field_190927_a;
                            update = true;
                        }
                        this.productionProgress = 0;
                    }
                }
            }
        } else if (this.productionProgress <= 0) {
            Optional<IAmmoCore> first;
            if (!((ItemStack)this.inventory.get(0)).func_190926_b() && (first = AmmoRegistry.INSTANCE.registeredBulletCores.values().stream().filter(core -> core.getMaterial().matchesItemStackIgnoringSize((ItemStack)this.inventory.get(0))).findFirst()).isPresent() && ((ItemStack)this.inventory.get(0)).func_190916_E() >= this.producedBullet.getCoreMaterialNeeded()) {
                IAmmo bullet = this.producedBullet;
                AmmoRegistry.EnumCoreTypes coreType = this.coreType;
                this.effect = bullet.getBulletCore(first.get(), coreType);
                this.productionProgress = (int)((double)IIConfigHandler.IIConfig.Machines.ProjectileWorkshop.productionTime + (double)IIConfigHandler.IIConfig.Machines.ProjectileWorkshop.productionTime * 0.3 * (double)bullet.getCaliber());
                ((ItemStack)this.inventory.get(0)).func_190918_g(this.producedBullet.getCoreMaterialNeeded());
                update = true;
            }
        } else {
            --this.productionProgress;
            if (this.productionProgress == 0) {
                if (!this.field_145850_b.field_72995_K) {
                    this.outputItem(this.effect);
                    this.effect = ItemStack.field_190927_a;
                    update = true;
                }
                this.productionProgress = 0;
            }
        }
        if (update) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
            IIPacketHandler.sendToClient((TileEntity)this, (IIMessage)new MessageIITileSync((TileEntityIEBase)this, EasyNBT.newNBT().withTag("component_inside", (NBTBase)this.componentInside.serializeNBT()).withString("produced_bullet", this.producedBullet.getName()).withEnum("core_type", this.coreType).withInt("production_progress", this.productionProgress).withItemStack("effect", this.effect)));
        }
    }

    private void outputItem(ItemStack stack) {
        EnumFacing ff = this.mirrored ? this.facing.func_176746_e() : this.facing.func_176735_f();
        BlockPos pp = this.getBlockPosForPos(12).func_177972_a(ff);
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(pp);
        if (inventoryTile != null) {
            stack = Utils.insertStackIntoInventory((TileEntity)inventoryTile, (ItemStack)stack, (EnumFacing)ff.func_176734_d());
        }
        if (!stack.func_190926_b()) {
            Utils.dropStackAtPos((World)this.field_145850_b, (BlockPos)pp, (ItemStack)stack);
        }
    }

    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        this.upgradeProgress = nbt.func_74762_e("upgrade_progress");
        this.inventory = Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)this.inventory.size());
        this.tanksFiller[0] = this.tanksFiller[0].readFromNBT(nbt.func_74775_l("tanks_filler"));
        this.tanksFactory[0] = this.tanksFactory[0].readFromNBT(nbt.func_74775_l("tanks_factory"));
        this.fillerUpgrade = nbt.func_74767_n("filler_upgrade");
        this.fillAmount = nbt.func_74762_e("fill_amount");
        this.componentInside = new BulletComponentStack(nbt.func_74775_l("component_inside"));
        if (nbt.func_74764_b("produced_bullet")) {
            IAmmo bb = AmmoRegistry.INSTANCE.getBulletItem(nbt.func_74779_i("produced_bullet"));
            IAmmo iAmmo = this.producedBullet = bb == null ? IIContent.itemAmmoArtillery : bb;
        }
        if (nbt.func_74764_b("core_type")) {
            this.coreType = AmmoRegistry.EnumCoreTypes.v(nbt.func_74779_i("core_type"));
        }
        this.productionProgress = nbt.func_74762_e("production_progress");
        this.effect = new ItemStack(nbt.func_74775_l("effect"));
    }

    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        nbt.func_74757_a("filler_upgrade", this.fillerUpgrade);
        nbt.func_74768_a("upgrade_progress", this.upgradeProgress);
        nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        nbt.func_74782_a("tanks_filler", (NBTBase)this.tanksFiller[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tanks_factory", (NBTBase)this.tanksFactory[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("fill_amount", this.fillAmount);
        nbt.func_74782_a("component_inside", (NBTBase)this.componentInside.serializeNBT());
        nbt.func_74778_a("produced_bullet", this.producedBullet.getName());
        nbt.func_74778_a("core_type", this.coreType.func_176610_l());
        nbt.func_74768_a("production_progress", this.productionProgress);
        nbt.func_74782_a("effect", (NBTBase)this.effect.serializeNBT());
    }

    public void receiveMessageFromServer(@Nonnull NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (this.isDummy()) {
            return;
        }
        if (message.func_74764_b("filler_upgrade")) {
            this.fillerUpgrade = message.func_74767_n("filler_upgrade");
        }
        if (message.func_74764_b("inventory")) {
            this.inventory = Utils.readInventory((NBTTagList)message.func_150295_c("inventory", 10), (int)this.inventory.size());
        }
        if (message.func_74764_b("tanks_filler")) {
            this.tanksFiller[0] = this.tanksFiller[0].readFromNBT(message.func_74775_l("tanks_filler"));
        }
        if (message.func_74764_b("tanks_factory")) {
            this.tanksFactory[0] = this.tanksFactory[0].readFromNBT(message.func_74775_l("tanks_factory"));
        }
        if (message.func_74764_b("upgrade_progress")) {
            this.upgradeProgress = message.func_74762_e("upgrade_progress");
        }
        if (message.func_74764_b("fill_amount")) {
            this.fillAmount = message.func_74762_e("fill_amount");
        }
        if (message.func_74764_b("component_inside")) {
            this.componentInside = new BulletComponentStack(message.func_74775_l("component_inside"));
        }
        if (message.func_74764_b("produced_bullet")) {
            IAmmo bb = AmmoRegistry.INSTANCE.getBulletItem(message.func_74779_i("produced_bullet"));
            IAmmo iAmmo = this.producedBullet = bb == null ? IIContent.itemAmmoArtillery : bb;
        }
        if (message.func_74764_b("core_type")) {
            this.coreType = AmmoRegistry.EnumCoreTypes.v(message.func_74779_i("core_type"));
        }
        if (message.func_74764_b("production_progress")) {
            this.productionProgress = message.func_74762_e("production_progress");
        }
        if (message.func_74764_b("effect")) {
            this.effect = new ItemStack(message.func_74775_l("effect"));
        }
    }

    public void receiveMessageFromClient(NBTTagCompound message) {
        super.receiveMessageFromClient(message);
        if (message.func_74764_b("core_type")) {
            this.coreType = AmmoRegistry.EnumCoreTypes.v(message.func_74779_i("core_type"));
        }
        if (message.func_74764_b("produced_bullet")) {
            IAmmo bb = AmmoRegistry.INSTANCE.getBulletItem(message.func_74779_i("produced_bullet"));
            IAmmo iAmmo = this.producedBullet = bb == null ? IIContent.itemAmmoArtillery : bb;
        }
        if (message.func_74764_b("fill_amount")) {
            this.fillAmount = MathHelper.func_76125_a((int)message.func_74762_e("fill_amount"), (int)0, (int)4);
        }
    }

    @Nullable
    protected IMultiblockRecipe readRecipeFromNBT(@Nonnull NBTTagCompound tag) {
        return null;
    }

    @Nonnull
    public int[] getEnergyPos() {
        return new int[]{46};
    }

    @Nonnull
    public int[] getRedstonePos() {
        return new int[]{9};
    }

    @Nonnull
    public IFluidTank[] getInternalTanks() {
        return this.fillerUpgrade ? this.tanksFiller : this.tanksFactory;
    }

    @Nonnull
    public IMultiblockRecipe findRecipeForInsertion(@Nonnull ItemStack inserting) {
        return null;
    }

    @Nonnull
    public int[] getOutputSlots() {
        return new int[]{0};
    }

    @Nonnull
    public int[] getOutputTanks() {
        return new int[0];
    }

    public boolean additionalCanProcessCheck(@Nonnull TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return true;
    }

    public void doProcessOutput(@Nonnull ItemStack output) {
    }

    public void doProcessFluidOutput(@Nonnull FluidStack output) {
    }

    public void onProcessFinish(@Nonnull TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public float getMinProcessDistance(@Nonnull TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 1.0f;
    }

    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Nonnull
    protected IFluidTank[] getAccessibleFluidTanks(@Nonnull EnumFacing side) {
        TileEntityProjectileWorkshop master = (TileEntityProjectileWorkshop)this.master();
        if (master != null && this.field_174879_c == 22 && side == this.facing) {
            return new FluidTank[]{master.fillerUpgrade ? master.tanksFiller[0] : master.tanksFactory[0]};
        }
        return new FluidTank[0];
    }

    protected boolean canFillTankFrom(int i, @Nonnull EnumFacing side, @Nonnull FluidStack fluidStack) {
        return this.field_174879_c == 22 && side == this.facing;
    }

    protected boolean canDrainTankFrom(int i, @Nonnull EnumFacing enumFacing) {
        return false;
    }

    @Nonnull
    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int i, ItemStack stack) {
        if (i == 1 && this.fillerUpgrade) {
            return AmmoRegistry.INSTANCE.registeredComponents.values().stream().anyMatch(comp -> comp.getMaterial().matchesItemStackIgnoringSize(stack));
        }
        if (i == 0) {
            if (this.fillerUpgrade) {
                return stack.func_77973_b() instanceof IAmmo && ((IAmmo)stack.func_77973_b()).isBulletCore(stack);
            }
            return AmmoRegistry.INSTANCE.registeredBulletCores.values().stream().anyMatch(core -> core.getMaterial().matchesItemStackIgnoringSize(stack));
        }
        return false;
    }

    public int getSlotLimit(int i) {
        return i == 1 ? 1 : 64;
    }

    public void doGraphicalUpdates(int i) {
    }

    public boolean shoudlPlaySound(@Nonnull String sound) {
        TileEntityProjectileWorkshop master = (TileEntityProjectileWorkshop)this.master();
        return false;
    }

    public void onGuiOpened(EntityPlayer player, boolean clientside) {
        if (!clientside) {
            IIPacketHandler.sendToClient((TileEntity)this, (IIMessage)new MessageIITileSync((TileEntityIEBase)this));
        }
    }

    public boolean canOpenGui() {
        return true;
    }

    public int getGuiID() {
        return IIGuiList.GUI_PROJECTILE_WORKSHOP.ordinal();
    }

    @Nullable
    public TileEntity getGuiMaster() {
        return this.master();
    }

    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        return list;
    }

    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public boolean addUpgrade(MachineUpgrade upgrade, boolean test) {
        if (upgrade == IIContent.UPGRADE_CORE_FILLER) {
            this.fillerUpgrade = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasUpgrade(MachineUpgrade upgrade) {
        return this.fillerUpgrade && upgrade == IIContent.UPGRADE_CORE_FILLER;
    }

    @Override
    public boolean upgradeMatches(MachineUpgrade upgrade) {
        return upgrade == IIContent.UPGRADE_CORE_FILLER;
    }

    public TileEntityProjectileWorkshop getUpgradeMaster() {
        return (TileEntityProjectileWorkshop)this.master();
    }

    @Override
    public void saveUpgradesToNBT(NBTTagCompound tag) {
    }

    @Override
    public void getUpgradesFromNBT(NBTTagCompound tag) {
    }

    @Override
    public void renderWithUpgrades(MachineUpgrade ... upgrades) {
        ProjectileWorkshopRenderer.renderWithUpgrades(upgrades);
    }

    @Override
    public List<MachineUpgrade> getUpgrades() {
        return this.fillerUpgrade ? Collections.singletonList(IIContent.UPGRADE_CORE_FILLER) : Collections.emptyList();
    }

    @Override
    @Nullable
    public MachineUpgrade getCurrentlyInstalled() {
        return this.currentlyInstalled;
    }

    @Override
    public int getInstallProgress() {
        return this.upgradeProgress;
    }

    @Override
    public int getClientInstallProgress() {
        return this.upgradeProgress;
    }

    @Override
    public boolean addUpgradeInstallProgress(int toAdd) {
        this.upgradeProgress += toAdd;
        return true;
    }

    @Override
    public boolean resetInstallProgress() {
        if (this.upgradeProgress > 0) {
            this.currentlyInstalled = null;
            this.upgradeProgress = 0;
            return true;
        }
        return false;
    }

    @Override
    public void startUpgrade(@Nonnull MachineUpgrade upgrade) {
        this.currentlyInstalled = upgrade;
        this.upgradeProgress = 0;
    }

    @Override
    public void removeUpgrade(MachineUpgrade upgrade) {
        if (upgrade == IIContent.UPGRADE_CORE_FILLER) {
            this.fillerUpgrade = false;
        }
    }

    @Override
    public void onAnimationChangeClient(boolean state, int part) {
        if (part >= 2) {
            return;
        }
        this.isDrawerOpened[part] = state;
    }

    @Override
    public void onAnimationChangeServer(boolean state, int part) {
        if (part >= 2) {
            return;
        }
        if (state != this.isDrawerOpened[part]) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), state ? IISounds.metalBreadboxOpen : IISounds.metalBreadboxClose, SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
        this.isDrawerOpened[part] = state;
        for (int i = 0; i < 2; ++i) {
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBooleanAnimatedPartsSync(this.isDrawerOpened[i], i, this.func_174877_v()), IIPacketHandler.targetPointFromPos(this.func_174877_v(), this.field_145850_b, 32));
        }
    }

    public EnumFacing[] sigOutputDirections() {
        if (this.field_174879_c == 12) {
            return new EnumFacing[]{this.mirrored ? this.facing.func_176746_e() : this.facing.func_176735_f()};
        }
        return new EnumFacing[0];
    }

    @Override
    public void onReceive(DataPacket packet, @Nullable EnumFacing side) {
        if (this.field_174879_c == 8) {
            TileEntityProjectileWorkshop master = (TileEntityProjectileWorkshop)this.master();
            if (master == null) {
                return;
            }
            if (packet.hasVariable(Character.valueOf('b'))) {
                master.producedBullet = AmmoRegistry.INSTANCE.registeredBulletItems.getOrDefault(packet.getPacketVariable(Character.valueOf('b')).valueToString(), IIContent.itemAmmoArtillery);
            }
            if (packet.hasVariable(Character.valueOf('t'))) {
                master.coreType = AmmoRegistry.EnumCoreTypes.v(packet.getPacketVariable(Character.valueOf('t')).valueToString());
            }
            if (Arrays.stream(master.producedBullet.getAllowedCoreTypes()).noneMatch(ct -> ct == master.coreType)) {
                master.coreType = master.producedBullet.getAllowedCoreTypes()[0];
            }
            if (packet.hasVariable(Character.valueOf('a'))) {
                master.fillAmount = packet.getVarInType(DataTypeInteger.class, (IDataType)packet.getPacketVariable((Character)Character.valueOf((char)'a'))).value;
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        TileEntityProjectileWorkshop master = (TileEntityProjectileWorkshop)this.master();
        if (master != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (this.field_174879_c == 22 && facing == this.facing ? master.fillerUpgrade : this.field_174879_c == 15)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        TileEntityProjectileWorkshop master = (TileEntityProjectileWorkshop)this.master();
        if (master != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.field_174879_c == 22 && facing == this.facing) {
                if (master.fillerUpgrade) {
                    return (T)master.componentInputHandler;
                }
            } else if (this.field_174879_c == 15) {
                return (T)master.inputHandler;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void onEntityCollision(World world, Entity entity) {
        if (this.field_174879_c == 15 && !world.field_72995_K && entity instanceof EntityItem && !entity.field_70128_L) {
            EntityItem ei = (EntityItem)entity;
            if (ei.func_92059_d().func_190926_b()) {
                return;
            }
            TileEntityProjectileWorkshop master = (TileEntityProjectileWorkshop)this.master();
            if (master == null) {
                return;
            }
            ItemStack stack = ei.func_92059_d();
            if (stack.func_190926_b()) {
                return;
            }
            stack = master.inputHandler.insertItem(0, stack, false);
            ei.func_92058_a(stack);
            if (stack.func_190916_E() <= 0) {
                entity.func_70106_y();
            }
        }
    }

    private static /* synthetic */ boolean lambda$update$0(String name, IAmmoComponent comp) {
        return name.equals(comp.getName());
    }

    public static class BulletComponentStack {
        @Nullable
        private IAmmoComponent component;
        private String name;
        private int amount;
        @Nonnull
        private NBTTagCompound tagCompound;

        private BulletComponentStack(String name, int amount, @Nonnull NBTTagCompound tag) {
            this.name = name;
            this.amount = amount;
            this.tagCompound = tag;
            Optional<IAmmoComponent> first = AmmoRegistry.INSTANCE.registeredComponents.values().stream().filter(comp -> this.name.equals(comp.getName())).findFirst();
            this.component = first.orElse(null);
        }

        private BulletComponentStack(IAmmoComponent component, @Nullable NBTTagCompound tag) {
            this(component.getName(), 16, tag == null ? new NBTTagCompound() : tag);
        }

        public BulletComponentStack() {
            this("", 0, new NBTTagCompound());
        }

        public BulletComponentStack(NBTTagCompound tag) {
            this(tag.func_74779_i("name"), tag.func_74762_e("amount"), tag.func_74775_l("nbt"));
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("name", this.name);
            nbt.func_74768_a("amount", this.amount);
            nbt.func_74782_a("nbt", (NBTBase)this.tagCompound);
            return nbt;
        }

        public boolean isEmpty() {
            return this.name.isEmpty() || this.amount == 0;
        }

        public boolean isFluid() {
            return this.component != null && this.component.getMaterial().fluid != null;
        }

        public boolean matches(ItemStack stack) {
            if (this.isEmpty() || this.component == null) {
                return true;
            }
            NBTTagCompound stackTag = stack.func_77978_p();
            if (stackTag == null) {
                stackTag = new NBTTagCompound();
            }
            return this.component.getName().equals(this.name) && this.tagCompound.equals((Object)stackTag);
        }

        public boolean matches(FluidStack fs) {
            if (this.isEmpty()) {
                return true;
            }
            NBTTagCompound stackTag = fs.tag == null ? new NBTTagCompound() : fs.tag;
            return fs.getFluid().getName().equals(this.name) && this.tagCompound.equals((Object)stackTag);
        }

        public void subtract(int amount) {
            this.amount = Math.max(0, this.amount - amount);
            if (amount == 0) {
                this.tagCompound = new NBTTagCompound();
                this.name = "";
                this.component = null;
            }
        }

        public boolean matches(IAmmo bullet) {
            return this.component != null && this.component.matchesBullet(bullet);
        }

        public int getColour() {
            return this.component != null ? this.component.getColour() : 0xFFFFFF;
        }

        public float getAmountPercentage() {
            return (float)this.amount / (float)IIConfigHandler.IIConfig.Machines.ProjectileWorkshop.componentCapacity;
        }

        @SideOnly(value=Side.CLIENT)
        public String getTranslatedName() {
            return I18n.func_135052_a((String)("ie.manual.entry.bullet_component." + this.name), (Object[])new Object[0]);
        }

        public IAmmoComponent getComponent() {
            return this.component;
        }
    }
}

