/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock1.tileentity;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.api.crafting.VulcanizerRecipe;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.client.fx.nuke.ParticleShockwave;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock1.multiblock.MultiblockVulcanizer;

public class TileEntityVulcanizer
extends TileEntityMultiblockMetal<TileEntityVulcanizer, VulcanizerRecipe>
implements IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.ISoundTile,
IEBlockInterfaces.IGuiTile {
    public ItemStack mold = ItemStack.field_190927_a;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public boolean recipePerformed = false;
    IItemHandler insertionHandlerRubber = new IEInventoryHandler(1, (IIEInventory)this, 0, true, false);
    IItemHandler insertionHandlerCompound = new IEInventoryHandler(1, (IIEInventory)this, 1, true, false);
    IItemHandler insertionHandlerSulfur = new IEInventoryHandler(1, (IIEInventory)this, 2, true, false);

    public TileEntityVulcanizer() {
        super((MultiblockHandler.IMultiblock)MultiblockVulcanizer.INSTANCE, MultiblockVulcanizer.INSTANCE.getSize(), IIConfigHandler.IIConfig.Machines.Vulcanizer.energyCapacity, true);
    }

    public void func_73660_a() {
        VulcanizerRecipe recipe;
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled()) {
            return;
        }
        this.processQueue.removeIf(p -> p.processTick >= p.maxTicks - 1 || p.clearProcess);
        if (this.field_145850_b.field_72995_K) {
            int max = this.getMaxProcessPerTick();
            int i = 0;
            Iterator processIterator = this.processQueue.iterator();
            this.tickedProcesses = 0;
            while (processIterator.hasNext() && i++ < max) {
                TileEntityMultiblockMetal.MultiblockProcess process = (TileEntityMultiblockMetal.MultiblockProcess)processIterator.next();
                if (!process.canProcess((TileEntityMultiblockMetal)this)) continue;
                int energyExtracted = process.energyPerTick;
                int ticksAdded = 1;
                if (((VulcanizerRecipe)process.recipe).getMultipleProcessTicks() > 1) {
                    int possibleTicks;
                    int averageInsertion = this.energyStorage.getAverageInsertion();
                    if ((averageInsertion = this.energyStorage.extractEnergy(averageInsertion, true)) > energyExtracted && (possibleTicks = Math.min(averageInsertion / process.energyPerTick, Math.min(((VulcanizerRecipe)process.recipe).getMultipleProcessTicks(), process.maxTicks - process.processTick))) > 1) {
                        ticksAdded = possibleTicks;
                        energyExtracted *= ticksAdded;
                    }
                }
                this.energyStorage.extractEnergy(energyExtracted, false);
                process.processTick += ticksAdded;
                if ((double)process.processTick > Math.ceil(0.86 * (double)process.maxTicks) && (double)process.processTick < Math.ceil(0.885 * (double)process.maxTicks) && this.field_145850_b.func_82737_E() % 4L == 0L) {
                    this.spawnParticles();
                }
                ++this.tickedProcesses;
            }
            return;
        }
        for (TileEntityMultiblockMetal.MultiblockProcess process : this.processQueue) {
            if ((double)process.processTick != Math.floor((double)process.maxTicks * 0.9) || !process.canProcess((TileEntityMultiblockMetal)this)) continue;
            ItemStack output = ((VulcanizerRecipe)process.recipe).output;
            int count = output.func_190916_E();
            for (int i = 0; i < count; ++i) {
                ItemStack stack = output.func_77946_l();
                stack.func_190920_e(1);
                BlockPos pos = this.getBlockPosForPos(i).func_177972_a(this.getOutFacing());
                TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
                if (inventoryTile != null) {
                    stack = Utils.insertStackIntoInventory((TileEntity)inventoryTile, (ItemStack)stack, (EnumFacing)this.getOutFacing().func_176734_d());
                }
                if (stack.func_190926_b()) continue;
                Utils.dropStackAtPos((World)this.field_145850_b, (BlockPos)pos, (ItemStack)stack, (EnumFacing)this.facing);
            }
        }
        if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength() && this.processQueue.stream().noneMatch(proc -> (float)proc.processTick / (float)proc.maxTicks < 0.84f) && (recipe = VulcanizerRecipe.findRecipe(this.mold, (ItemStack)this.inventory.get(0))) != null && ((ItemStack)this.inventory.get(0)).func_190916_E() >= recipe.input.inputSize && ((ItemStack)this.inventory.get(1)).func_190916_E() >= recipe.compoundInput.inputSize && ((ItemStack)this.inventory.get(2)).func_190916_E() >= recipe.sulfurInput.inputSize) {
            ItemStack rubber = ((ItemStack)this.inventory.get(0)).func_77946_l();
            rubber.func_190920_e(recipe.input.inputSize);
            ItemStack comp = ((ItemStack)this.inventory.get(1)).func_77946_l();
            rubber.func_190920_e(recipe.compoundInput.inputSize);
            ItemStack sulfur = ((ItemStack)this.inventory.get(2)).func_77946_l();
            rubber.func_190920_e(recipe.sulfurInput.inputSize);
            TileEntityMultiblockMetal.MultiblockProcessInWorld process = new TileEntityMultiblockMetal.MultiblockProcessInWorld((IMultiblockRecipe)recipe, 0.84f, NonNullList.func_193580_a((Object)rubber, (Object[])new ItemStack[]{comp, sulfur}));
            if (this.addProcessToQueue((TileEntityMultiblockMetal.MultiblockProcess)process, true, false)) {
                ((ItemStack)this.inventory.get(0)).func_190918_g(recipe.input.inputSize);
                ((ItemStack)this.inventory.get(1)).func_190918_g(recipe.compoundInput.inputSize);
                ((ItemStack)this.inventory.get(2)).func_190918_g(recipe.sulfurInput.inputSize);
                this.addProcessToQueue((TileEntityMultiblockMetal.MultiblockProcess)process, false, false);
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (nbt.func_74764_b("mold")) {
            this.mold = new ItemStack(nbt.func_74775_l("mold"));
        }
        if (!descPacket) {
            this.inventory = Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)3);
        }
        this.recipePerformed = nbt.func_74767_n("recipePerformed");
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!this.mold.func_190926_b()) {
            nbt.func_74782_a("mold", (NBTBase)this.mold.func_77955_b(new NBTTagCompound()));
        }
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
        nbt.func_74757_a("recipePerformed", this.recipePerformed);
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        TileEntityVulcanizer master = (TileEntityVulcanizer)this.master();
        if (master != null && master.processQueue.isEmpty()) {
            if (player.func_70093_af() && !master.mold.func_190926_b()) {
                if (heldItem.func_190926_b()) {
                    player.func_184611_a(hand, master.mold.func_77946_l());
                } else if (!this.field_145850_b.field_72995_K) {
                    player.func_70099_a(master.mold.func_77946_l(), 0.0f);
                }
                master.mold = ItemStack.field_190927_a;
                this.updateMasterBlock(null, true);
                return true;
            }
            if (VulcanizerRecipe.isValidMold(heldItem)) {
                ItemStack tempMold = !master.mold.func_190926_b() ? master.mold.func_77946_l() : ItemStack.field_190927_a;
                master.mold = Utils.copyStackWithAmount((ItemStack)heldItem, (int)1);
                heldItem.func_190918_g(1);
                if (heldItem.func_190916_E() <= 0) {
                    heldItem = ItemStack.field_190927_a;
                } else {
                    player.func_184611_a(hand, heldItem);
                }
                if (!tempMold.func_190926_b()) {
                    if (heldItem.func_190926_b()) {
                        player.func_184611_a(hand, tempMold);
                    } else if (!this.field_145850_b.field_72995_K) {
                        player.func_70099_a(tempMold, 0.0f);
                    }
                }
                this.updateMasterBlock(null, true);
                return true;
            }
        }
        return false;
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (message.func_74764_b("recipePerformed")) {
            this.recipePerformed = message.func_74767_n("recipePerformed");
        }
    }

    protected VulcanizerRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return VulcanizerRecipe.loadFromNBT(tag);
    }

    public int[] getEnergyPos() {
        return new int[]{22};
    }

    public int[] getRedstonePos() {
        return new int[]{4};
    }

    public IFluidTank[] getInternalTanks() {
        return null;
    }

    public VulcanizerRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    public int[] getOutputSlots() {
        return null;
    }

    public int[] getOutputTanks() {
        return null;
    }

    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<VulcanizerRecipe> process) {
        return ApiUtils.createComparableItemStack((ItemStack)this.mold, (boolean)true).equals((Object)((VulcanizerRecipe)process.recipe).mold);
    }

    public void doProcessOutput(ItemStack output) {
        this.recipePerformed = !this.recipePerformed;
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<VulcanizerRecipe> process) {
    }

    public int getMaxProcessPerTick() {
        return 2;
    }

    public int getProcessQueueMaxLength() {
        return 2;
    }

    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<VulcanizerRecipe> process) {
        return 0.84f;
    }

    public boolean isInWorldProcessingMachine() {
        return true;
    }

    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing enumFacing) {
        return new IFluidTank[0];
    }

    protected boolean canFillTankFrom(int i, EnumFacing enumFacing, FluidStack fluidStack) {
        return false;
    }

    protected boolean canDrainTankFrom(int i, EnumFacing enumFacing) {
        return false;
    }

    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int i, ItemStack itemStack) {
        switch (i) {
            case 0: {
                return VulcanizerRecipe.recipeList.values().stream().anyMatch(vulcanizerRecipe -> vulcanizerRecipe.input.matchesItemStackIgnoringSize(itemStack));
            }
            case 1: {
                return VulcanizerRecipe.recipeList.values().stream().anyMatch(vulcanizerRecipe -> vulcanizerRecipe.compoundInput.matchesItemStackIgnoringSize(itemStack));
            }
            case 2: {
                return VulcanizerRecipe.recipeList.values().stream().anyMatch(vulcanizerRecipe -> vulcanizerRecipe.sulfurInput.matchesItemStackIgnoringSize(itemStack));
            }
        }
        return false;
    }

    public int getSlotLimit(int i) {
        return 64;
    }

    public void doGraphicalUpdates(int i) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    private EnumFacing getOutFacing() {
        return this.facing.func_176734_d();
    }

    private EnumFacing getInFacing() {
        return this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityVulcanizer master = (TileEntityVulcanizer)this.master();
            if (master == null) {
                return false;
            }
            return (this.field_174879_c == 53 || this.field_174879_c == 71 || this.field_174879_c == 95) && facing == this.getInFacing();
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityVulcanizer master = (TileEntityVulcanizer)this.master();
            if (master == null) {
                return null;
            }
            switch (this.field_174879_c) {
                case 53: {
                    return (T)master.insertionHandlerSulfur;
                }
                case 71: {
                    return (T)master.insertionHandlerCompound;
                }
                case 95: {
                    return (T)master.insertionHandlerRubber;
                }
            }
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shoudlPlaySound(String sound) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        Vec3d facing = new Vec3d(this.getFacing().func_176734_d().func_176730_m()).func_186678_a(0.25);
        facing = facing.func_186678_a((double)0.65f);
        for (int p = 48; p <= 50; ++p) {
            for (int i = 0; i < 6; ++i) {
                Vec3d bpos = new Vec3d((Vec3i)this.getBlockPosForPos(p)).func_72441_c(0.5, -0.5, 0.5).func_178787_e(facing);
                float mod = Utils.RAND.nextFloat();
                ParticleShockwave particle = new ParticleShockwave((World)ClientUtils.mc().field_71441_e, bpos.func_72441_c(0.0, 0.125 * (double)i, 0.0), facing.func_186678_a((double)mod).func_72441_c(0.0, (double)(-mod) * 0.1, 0.0), (float)i + mod);
                ParticleUtils.particleRenderer.addEffect(particle);
            }
        }
    }

    public boolean canOpenGui() {
        return this.formed;
    }

    public int getGuiID() {
        return IIGuiList.GUI_VULCANIZER.ordinal();
    }

    @Nullable
    public TileEntity getGuiMaster() {
        return this.master();
    }

    public NonNullList<ItemStack> getDroppedItems() {
        return NonNullList.func_193580_a((Object)this.inventory.get(0), (Object[])new ItemStack[]{(ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(2), this.mold});
    }
}

