/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.multiblock.wooden_multiblock.tileentity;

import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.particle.ParticleRedstone;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.api.crafting.SawmillRecipe;
import pl.pabilo8.immersiveintelligence.api.rotary.CapabilityRotaryEnergy;
import pl.pabilo8.immersiveintelligence.api.rotary.IRotaryEnergy;
import pl.pabilo8.immersiveintelligence.api.rotary.IRotationalEnergyBlock;
import pl.pabilo8.immersiveintelligence.api.rotary.RotaryStorage;
import pl.pabilo8.immersiveintelligence.api.utils.IBooleanAnimatedPartsBlock;
import pl.pabilo8.immersiveintelligence.api.utils.tools.ISawblade;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.wooden_multiblock.multiblock.MultiblockSawmill;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageBooleanAnimatedPartsSync;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageRotaryPowerSync;
import pl.pabilo8.immersiveintelligence.common.util.IIDamageSources;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.production.TileEntityMultiblockProductionBase;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.production.TileEntityMultiblockProductionSingle;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.util.MultiblockInteractablePart;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.util.MultiblockPOI;

public class TileEntitySawmill
extends TileEntityMultiblockProductionSingle<TileEntitySawmill, SawmillRecipe>
implements IRotationalEnergyBlock,
IBooleanAnimatedPartsBlock {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_SAWBLADE = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int SLOT_SAWDUST = 3;
    IItemHandler insertionHandler = this.getSingleInventoryHandler(0, true, false);
    IItemHandler dustExtractionHandler = this.getSingleInventoryHandler(3, false, true);
    IItemHandler outputHandler = this.getSingleInventoryHandler(2);
    IItemHandler sawdustOutputHandler = this.getSingleInventoryHandler(3);
    public MultiblockInteractablePart vice;
    public RotaryStorage rotation = new RotaryStorage(0.0f, 0.0f){

        @Override
        public IRotaryEnergy.RotationSide getSide(@Nullable EnumFacing facing) {
            return facing == TileEntitySawmill.this.getFacing() ? IRotaryEnergy.RotationSide.INPUT : IRotaryEnergy.RotationSide.NONE;
        }
    };

    public TileEntitySawmill() {
        super(MultiblockSawmill.INSTANCE);
        this.energyStorage = new FluxStorageAdvanced(0);
        this.inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        this.vice = new MultiblockInteractablePart(20.0f);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        this.rotation.fromNBT(nbt.func_74775_l("rotation"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        nbt.func_74782_a("rotation", (NBTBase)this.rotation.toNBT());
    }

    @Override
    public void receiveMessageFromServer(NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (message.func_74764_b("rotation")) {
            this.rotation.fromNBT(message.func_74775_l("rotation"));
        }
    }

    @Override
    protected int[] listAllPOI(MultiblockPOI poi) {
        switch (poi) {
            case ROTARY_INPUT: {
                return this.getPOI("rotary");
            }
            case ITEM_INPUT: {
                return this.getPOI("all_item_input");
            }
            case ITEM_OUTPUT: {
                return this.getPOI("item_output");
            }
        }
        return new int[0];
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntitySawmill master = (TileEntitySawmill)this.master();
            if (this.isPOI("item_input")) {
                return (T)master.insertionHandler;
            }
            if (this.isPOI("sawdust")) {
                return (T)master.dustExtractionHandler;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    protected void onUpdate() {
        this.vice.update();
        if (!this.field_145850_b.field_72995_K) {
            boolean receivesPower = false;
            if (this.rotation.getRotationSpeed() > (float)IIConfigHandler.IIConfig.Machines.Sawmill.rpmBreakingMax || this.rotation.getTorque() > (float)IIConfigHandler.IIConfig.Machines.Sawmill.torqueBreakingMax) {
                this.selfDestruct();
                return;
            }
            TileEntity te = this.field_145850_b.func_175625_s(this.getPOIPos(MultiblockPOI.ROTARY_INPUT).func_177972_a(this.facing));
            if (te != null && te.hasCapability(CapabilityRotaryEnergy.ROTARY_ENERGY, this.facing.func_176734_d())) {
                IRotaryEnergy cap = (IRotaryEnergy)te.getCapability(CapabilityRotaryEnergy.ROTARY_ENERGY, this.facing.func_176734_d());
                assert (cap != null);
                if (this.rotation.handleRotation(cap, this.facing.func_176734_d())) {
                    IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageRotaryPowerSync(this.rotation, 0, this.func_174877_v()), IIPacketHandler.targetPointFromTile((TileEntity)this, 24));
                }
                receivesPower = true;
            }
            if (this.rotation.getTorque() > 0.0f || this.rotation.getRotationSpeed() > 0.0f) {
                ItemStack sawStack;
                if (!receivesPower) {
                    this.rotation.grow(0.0f, 0.0f, 0.98f);
                    IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageRotaryPowerSync(this.rotation, 0, this.func_174877_v()), IIPacketHandler.targetPointFromTile((TileEntity)this, 24));
                }
                if ((sawStack = (ItemStack)this.inventory.get(1)).func_77973_b() instanceof ISawblade && (double)this.field_145850_b.func_82737_E() % Math.ceil(4.0f / MathHelper.func_76131_a((float)(this.rotation.getRotationSpeed() / 360.0f), (float)0.0f, (float)1.0f)) == 0.0) {
                    int hardness = ((ISawblade)sawStack.func_77973_b()).getHardness(sawStack);
                    Vec3i v = this.facing.func_176730_m();
                    List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.getBlockPosForPos(2).func_177972_a(EnumFacing.UP)).func_72317_d((double)v.func_177958_n() * 0.5, (double)v.func_177956_o() * 0.5, (double)v.func_177952_p() * 0.5));
                    for (EntityLivingBase l : entities) {
                        l.func_70097_a(IIDamageSources.SAWMILL_DAMAGE, (float)hardness);
                    }
                }
            }
        }
        super.onUpdate();
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnDustParticleLast() {
        Vec3d pos = new Vec3d((Vec3i)this.getBlockPosForPos(2)).func_72441_c(0.5, 0.75, 0.5);
        Vec3d facing = new Vec3d(this.getFacing().func_176730_m());
        facing = facing.func_186678_a((double)0.65f);
        float mod = (float)(Math.random() * 2.0);
        float[] rgb = this.getCurrentProcessColor();
        ParticleRedstone particle = (ParticleRedstone)ClientUtils.mc().field_71452_i.func_178927_a(EnumParticleTypes.REDSTONE.func_179348_c(), pos.field_72450_a + facing.field_72450_a, pos.field_72448_b + facing.field_72448_b, pos.field_72449_c + facing.field_72449_c, 0.0, -4.0, 0.0, new int[0]);
        if (particle != null) {
            particle.field_70570_a = 3.25f;
            particle.func_70538_b(rgb[0] * mod, rgb[1] * mod, rgb[2] * mod);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnDustParticle() {
        Vec3d pos = new Vec3d((Vec3i)this.getBlockPosForPos(2)).func_72441_c(0.5, 0.0, 0.5);
        Vec3d facing = new Vec3d(this.getFacing().func_176730_m());
        facing = facing.func_186678_a((double)0.65f);
        float mod = (float)(Math.random() * 2.0);
        ParticleRedstone particle = (ParticleRedstone)ClientUtils.mc().field_71452_i.func_178927_a(EnumParticleTypes.REDSTONE.func_179348_c(), pos.field_72450_a + facing.field_72450_a, pos.field_72448_b + 1.125 + facing.field_72448_b, pos.field_72449_c + facing.field_72449_c, 0.0, -4.0, 0.0, new int[0]);
        ParticleRedstone particle2 = (ParticleRedstone)ClientUtils.mc().field_71452_i.func_178927_a(EnumParticleTypes.REDSTONE.func_179348_c(), pos.field_72450_a + facing.field_72450_a, pos.field_72448_b + 0.65 + facing.field_72448_b, pos.field_72449_c + facing.field_72449_c, 0.0, -4.0, 0.0, new int[0]);
        ParticleRedstone particle3 = (ParticleRedstone)ClientUtils.mc().field_71452_i.func_178927_a(EnumParticleTypes.REDSTONE.func_179348_c(), pos.field_72450_a + facing.field_72450_a, pos.field_72448_b + facing.field_72448_b, pos.field_72449_c + facing.field_72449_c, 0.0, -4.0, 0.0, new int[0]);
        float[] rgb = this.getCurrentProcessColor();
        float dmod = 1.3043479f;
        if (particle != null) {
            particle.field_70570_a = 3.0f;
            particle.func_70538_b(rgb[0] * mod, rgb[1] * mod, rgb[2] * mod);
        }
        if (particle2 != null) {
            particle2.field_70570_a = 4.0f;
            particle2.func_70538_b(rgb[0] * 1.3043479f * mod, rgb[1] * 1.3043479f * mod, rgb[2] * 1.3043479f * mod);
        }
        if (particle3 != null) {
            particle3.field_70570_a = 3.0f;
            particle3.func_70538_b(rgb[0] * mod, rgb[1] * mod, rgb[2] * mod);
        }
    }

    private float[] getCurrentProcessColor() {
        if (this.currentProcess != null) {
            return ((SawmillRecipe)this.currentProcess.recipe).getDustColor();
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public float getCurrentEfficiency() {
        float e1 = MathHelper.func_76131_a((float)(this.rotation.getRotationSpeed() / (float)IIConfigHandler.IIConfig.Machines.Sawmill.rpmMin), (float)0.0f, (float)1.0f);
        float e2 = MathHelper.func_76131_a((float)(this.rotation.getTorque() / (float)IIConfigHandler.IIConfig.Machines.Sawmill.torqueMin), (float)0.0f, (float)1.0f);
        return (e1 + e2) / 2.0f;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public IIGuiList getGUI() {
        return IIGuiList.GUI_SAWMILL;
    }

    @Override
    protected TileEntityMultiblockProductionBase.IIMultiblockProcess<SawmillRecipe> findNewProductionProcess() {
        ItemStack stackSawblade = (ItemStack)this.inventory.get(1);
        if (stackSawblade.func_190926_b()) {
            return null;
        }
        SawmillRecipe recipe = SawmillRecipe.findRecipe((ItemStack)this.inventory.get(0));
        if (recipe != null) {
            Item item = stackSawblade.func_77973_b();
            if (!(item instanceof ISawblade)) {
                return null;
            }
            ISawblade saw = (ISawblade)item;
            if (saw.getHardness(stackSawblade) < recipe.getHardness()) {
                return null;
            }
            ((ItemStack)this.inventory.get(0)).func_190918_g(recipe.itemInput.inputSize);
            return new TileEntityMultiblockProductionBase.IIMultiblockProcess<SawmillRecipe>(recipe);
        }
        return null;
    }

    @Override
    public float getProductionStep(TileEntityMultiblockProductionBase.IIMultiblockProcess<SawmillRecipe> process, boolean simulate) {
        if (((ItemStack)this.inventory.get(1)).func_77973_b() instanceof ISawblade && (double)this.getCurrentEfficiency() > 0.95 && ((ItemStack)this.inventory.get(2)).func_190916_E() + ((SawmillRecipe)process.recipe).itemOutput.func_190916_E() <= this.getSlotLimit(2)) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    protected boolean attemptProductionOutput(TileEntityMultiblockProductionBase.IIMultiblockProcess<SawmillRecipe> process) {
        ItemStack output = ((SawmillRecipe)process.recipe).itemOutput.func_77946_l();
        ItemStack sawdust = ((SawmillRecipe)process.recipe).itemSecondaryOutput.func_77946_l();
        this.outputOrDrop(output, this.outputHandler, this.facing, this.getPOI("item_output"));
        this.outputOrDrop(sawdust, this.sawdustOutputHandler, EnumFacing.DOWN, this.getPOI("sawdust"));
        return true;
    }

    @Override
    protected void onProductionFinish(TileEntityMultiblockProductionBase.IIMultiblockProcess<SawmillRecipe> process) {
        ItemStack sawblade = (ItemStack)this.inventory.get(1);
        if (sawblade.func_77973_b() instanceof ISawblade) {
            ((ISawblade)sawblade.func_77973_b()).damageSawblade(sawblade, ((SawmillRecipe)process.recipe).getHardness());
        }
    }

    private void selfDestruct() {
        this.field_145850_b.func_72876_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 4.0f, true);
    }

    @Override
    public void updateRotationStorage(float rpm, float torque, int part) {
        if (this.field_145850_b.field_72995_K) {
            this.rotation.setRotationSpeed(rpm);
            this.rotation.setTorque(torque);
        }
    }

    @Override
    public void onAnimationChangeClient(boolean state, int part) {
        this.vice.setState(state);
    }

    @Override
    public void onAnimationChangeServer(boolean state, int part) {
        this.vice.setState(state);
        IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBooleanAnimatedPartsSync(state, part, this.func_174877_v()), IIPacketHandler.targetPointFromTile((TileEntity)this, 32));
    }
}

