/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.rotary_device.tileentity;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pl.pabilo8.immersiveintelligence.api.rotary.CapabilityRotaryEnergy;
import pl.pabilo8.immersiveintelligence.api.rotary.IMotorBeltConnector;
import pl.pabilo8.immersiveintelligence.api.rotary.IRotaryEnergy;
import pl.pabilo8.immersiveintelligence.api.rotary.IRotationalEnergyBlock;
import pl.pabilo8.immersiveintelligence.api.rotary.MotorBeltNetwork;
import pl.pabilo8.immersiveintelligence.api.rotary.MotorBeltType;
import pl.pabilo8.immersiveintelligence.api.rotary.RotaryStorage;
import pl.pabilo8.immersiveintelligence.api.rotary.RotaryUtils;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageRotaryPowerSync;

public abstract class TileEntityMechanicalConnectable
extends TileEntityImmersiveConnectable
implements IMotorBeltConnector,
ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IBlockBounds,
IOBJModelCallback<IBlockState>,
IRotationalEnergyBlock {
    protected MotorBeltNetwork beltNetwork = new MotorBeltNetwork().add(this);
    public RotaryStorage energy = new RotaryStorage(){

        @Override
        public IRotaryEnergy.RotationSide getSide(@Nullable EnumFacing facing) {
            return facing == TileEntityMechanicalConnectable.this.getFacing() || facing == null ? IRotaryEnergy.RotationSide.BOTH : IRotaryEnergy.RotationSide.NONE;
        }

        @Override
        public float getOutputRotationSpeed() {
            return TileEntityMechanicalConnectable.this.getNetwork() != null ? (float)TileEntityMechanicalConnectable.this.getNetwork().getNetworkRPM() : this.getRotationSpeed();
        }

        @Override
        public float getOutputTorque() {
            return TileEntityMechanicalConnectable.this.getNetwork() != null ? (float)TileEntityMechanicalConnectable.this.getNetwork().getNetworkTorque() : this.getTorque();
        }
    };
    protected boolean refreshBeltNetwork = false;

    @Override
    public void updateRotationStorage(float rpm, float torque, int part) {
        if (this.field_145850_b.field_72995_K) {
            if (part == 0) {
                this.energy.setRotationSpeed(rpm);
                this.energy.setTorque(torque);
            } else if (part == 1) {
                this.getNetwork().setClient(rpm, torque);
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityRotaryEnergy.ROTARY_ENERGY && (facing == null || facing == this.getFacing())) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityRotaryEnergy.ROTARY_ENERGY && (facing == null || facing == this.getFacing())) {
            return (T)this.energy;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        if (!RotaryUtils.isMechanicalBelt(cableType)) {
            return false;
        }
        return this.limitType == null || this.isRelay() && WireApi.canMix((WireType)this.limitType, (WireType)cableType);
    }

    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (nbt.func_74764_b("energy")) {
            this.energy.fromNBT(nbt.func_74775_l("energy"));
        }
    }

    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("energy", (NBTBase)this.energy.toNBT());
    }

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            IRotaryEnergy other;
            TileEntity te;
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.getNetwork().updateValues();
            }
            if (this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.getFacing())) != null && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.getFacing()))).hasCapability(CapabilityRotaryEnergy.ROTARY_ENERGY, this.getFacing().func_176734_d()) && this.energy.handleRotation(other = (IRotaryEnergy)te.getCapability(CapabilityRotaryEnergy.ROTARY_ENERGY, this.getFacing().func_176734_d()), this.getFacing().func_176734_d())) {
                this.getNetwork().updateValues();
            }
            if (!this.refreshBeltNetwork) {
                this.refreshBeltNetwork = true;
                this.beltNetwork.removeFromNetwork(null);
            }
        }
    }

    @Override
    public MotorBeltNetwork getNetwork() {
        return this.beltNetwork;
    }

    @Override
    public void setNetwork(MotorBeltNetwork net) {
        this.beltNetwork = net;
    }

    @Override
    public void onChange() {
        this.func_70296_d();
        IBlockState stateHere = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.markContainingBlockForUpdate(stateHere);
        this.markBlockForUpdate(this.getConnectionPos(), stateHere);
        IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageRotaryPowerSync(this.getNetwork().getEnergyStorage(), 1, this.func_174877_v()), IIPacketHandler.targetPointFromTile((TileEntity)this, 32));
    }

    public abstract BlockPos getConnectionPos();

    @Override
    public World getConnectorWorld() {
        return this.func_145831_w();
    }

    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        this.onChange();
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 254, 0);
        return true;
    }

    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        super.connectCable(cableType, target, other);
        MotorBeltNetwork.updateConnectors(this.field_174879_c, this.field_145850_b, this.beltNetwork);
    }

    public void processDamage(Entity e, float amount, ImmersiveNetHandler.Connection c) {
    }

    protected float getBaseDamage(ImmersiveNetHandler.Connection c) {
        return 1.0f;
    }

    protected float getMaxDamage(ImmersiveNetHandler.Connection c) {
        return 20.0f;
    }

    public void removeCable(@Nullable ImmersiveNetHandler.Connection connection) {
        super.removeCable(connection);
        this.beltNetwork.removeFromNetwork(this);
    }

    @Override
    public RotaryStorage getRotaryStorage() {
        return this.energy;
    }

    public float getDamageAmount(Entity e, ImmersiveNetHandler.Connection c) {
        if (c.cableType instanceof MotorBeltType) {
            return (float)this.beltNetwork.getNetworkTorque() / 4.0f;
        }
        return super.getDamageAmount(e, c);
    }
}

