/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.simple;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.util.block.BlockIIBase;
import pl.pabilo8.immersiveintelligence.common.util.block.IIBlockInterfaces;
import pl.pabilo8.immersiveintelligence.common.util.block.ItemBlockIIBase;

public class BlockIIRubberLeaves
extends BlockIIBase<RubberStuff>
implements IShearable,
IEBlockInterfaces.IColouredBlock,
IEItemInterfaces.IColouredItem {
    protected boolean leavesFancy;
    int[] surroundings;

    public BlockIIRubberLeaves() {
        super("rubber_leaves", PropertyEnum.func_177709_a((String)"type", RubberStuff.class), Material.field_151584_j, ItemBlockIILeaves::new, BlockLeaves.field_176236_b, BlockLeaves.field_176237_a);
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
        this.setLightOpacity(1);
        this.field_149786_r = 0;
    }

    @Override
    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.property, (Comparable)((Object)RubberStuff.RUBBER)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(meta == 1)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(meta == 1));
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        if (state == null || this.enumValues == null || !((Object)((Object)this)).equals(state.func_177230_c())) {
            return 0;
        }
        return (Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176237_a) != false ? 1 : 0;
    }

    @Override
    protected IBlockState getInitDefaultState() {
        return super.getInitDefaultState().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean canIEBlockBePlaced(World world, BlockPos pos, IBlockState newState, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player, ItemStack stack) {
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, @Nonnull IBlockState state) {
        int i1;
        int l;
        int k = pos.func_177958_n();
        if (worldIn.func_175707_a(new BlockPos(k - 2, (l = pos.func_177956_o()) - 2, (i1 = pos.func_177952_p()) - 2), new BlockPos(k + 2, l + 2, i1 + 2))) {
            for (int j1 = -1; j1 <= 1; ++j1) {
                for (int k1 = -1; k1 <= 1; ++k1) {
                    for (int l1 = -1; l1 <= 1; ++l1) {
                        BlockPos blockpos = pos.func_177982_a(j1, k1, l1);
                        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                        if (!iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, blockpos)) continue;
                        iblockstate.func_177230_c().beginLeavesDecay(iblockstate, worldIn, blockpos);
                    }
                }
            }
        }
    }

    public void func_180650_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176237_a)).booleanValue()) {
            int l2;
            int k = pos.func_177958_n();
            int l = pos.func_177956_o();
            int i1 = pos.func_177952_p();
            if (this.surroundings == null) {
                this.surroundings = new int[32768];
            }
            if (!worldIn.func_175697_a(pos, 1)) {
                return;
            }
            if (worldIn.func_175697_a(pos, 6)) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int i2 = -4; i2 <= 4; ++i2) {
                    for (int j2 = -4; j2 <= 4; ++j2) {
                        for (int k2 = -4; k2 <= 4; ++k2) {
                            IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(k + i2, l + j2, i1 + k2));
                            Block block = iblockstate.func_177230_c();
                            int index = (i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16;
                            if (!block.canSustainLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(k + i2, l + j2, i1 + k2))) {
                                if (block.isLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(k + i2, l + j2, i1 + k2))) {
                                    this.surroundings[index] = -2;
                                    continue;
                                }
                                this.surroundings[index] = -1;
                                continue;
                            }
                            this.surroundings[index] = 0;
                        }
                    }
                }
                for (int i3 = 1; i3 <= 4; ++i3) {
                    for (int j3 = -4; j3 <= 4; ++j3) {
                        for (int k3 = -4; k3 <= 4; ++k3) {
                            for (int l3 = -4; l3 <= 4; ++l3) {
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16] != i3 - 1) continue;
                                if (this.surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + (l3 + 16 - 1)] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + (l3 + 16 - 1)] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] != -2) continue;
                                this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] = i3;
                            }
                        }
                    }
                }
            }
            if ((l2 = this.surroundings[16912]) >= 0) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.FALSE), 4);
            } else {
                this.destroy(worldIn, pos);
            }
        }
    }

    private void destroy(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        this.func_176226_b(worldIn, pos, worldIn.func_180495_p(pos), 0);
        worldIn.func_175698_g(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState stateIn, World worldIn, BlockPos pos, @Nonnull Random rand) {
        if (worldIn.func_175727_C(pos.func_177984_a()) && !worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() && rand.nextInt(15) == 1) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.DRIP_WATER, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public int func_149745_a(@Nonnull Random random) {
        return random.nextInt(20) == 0 ? 1 : 0;
    }

    @Nonnull
    public Item func_180660_a(@Nonnull IBlockState state, @Nonnull Random rand, int fortune) {
        return Item.func_150898_a((Block)IIContent.blockRubberSapling);
    }

    public void func_180653_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, float chance, int fortune) {
        super.func_180653_a(worldIn, pos, state, chance, fortune);
    }

    @Override
    public boolean func_149662_c(@Nonnull IBlockState state) {
        return !this.leavesFancy;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        this.leavesFancy = Minecraft.func_71410_x().field_71474_y.field_74347_j;
        return this.leavesFancy ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == this.func_180664_k();
    }

    public boolean func_176214_u(@Nonnull IBlockState state) {
        return false;
    }

    public boolean isLeaves(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    public void beginLeavesDecay(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true)), 4);
        }
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        ItemStack drop;
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int chance = 20;
        if (fortune > 0 && (chance -= 2 << fortune) < 30) {
            chance = 30;
        }
        if (rand.nextInt(chance) == 0 && !(drop = new ItemStack(this.func_180660_a(state, rand, fortune), 1)).func_190926_b()) {
            drops.add((Object)drop);
        }
        this.captureDrops(true);
        drops.addAll((Collection)this.captureDrops(false));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return (this.leavesFancy || blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this) && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean isShearable(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack itemStack, IBlockAccess iBlockAccess, BlockPos blockPos, int i) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this, 1));
    }

    public boolean hasCustomBlockColours() {
        return true;
    }

    public int getRenderColour(@Nonnull IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        return worldIn != null && pos != null ? BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerFoliage.func_77468_c();
    }

    public static class ItemBlockIILeaves
    extends ItemBlockIIBase
    implements IEItemInterfaces.IColouredItem {
        public ItemBlockIILeaves(BlockIIBase b) {
            super(b);
        }

        public boolean hasCustomItemColours() {
            return true;
        }

        public int getColourForIEItem(ItemStack stack, int pass) {
            return ColorizerFoliage.func_77468_c();
        }
    }

    public static enum RubberStuff implements IIBlockInterfaces.IIBlockEnum
    {
        RUBBER;

    }
}

