/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.simple;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.block.simple.BlockIIRubberLeaves;
import pl.pabilo8.immersiveintelligence.common.util.block.BlockIIBase;
import pl.pabilo8.immersiveintelligence.common.util.block.ItemBlockIIBase;
import pl.pabilo8.immersiveintelligence.common.world.IIWorldGen;

public class BlockIIRubberSapling
extends BlockIIBase<BlockIIRubberLeaves.RubberStuff>
implements IGrowable,
IPlantable {
    private static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);

    public BlockIIRubberSapling() {
        super("rubber_sapling", PropertyEnum.func_177709_a((String)"type", BlockIIRubberLeaves.RubberStuff.class), Material.field_151585_k, ItemBlockIIBase::new, BlockSapling.field_176479_b);
        this.setBlockLayer(BlockRenderLayer.CUTOUT_MIPPED);
        this.setLightOpacity(0);
        this.setFullCube(false);
    }

    @Override
    public boolean useCustomStateMapper() {
        return true;
    }

    @Override
    public String getCustomStateMapping(int meta, boolean itemBlock) {
        return itemBlock ? "item" : null;
    }

    @Override
    protected IBlockState getInitDefaultState() {
        return super.getInitDefaultState().func_177226_a((IProperty)this.property, (Comparable)((Object)BlockIIRubberLeaves.RubberStuff.RUBBER)).func_177226_a((IProperty)BlockSapling.field_176479_b, (Comparable)Integer.valueOf(0));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.property, (Comparable)((Object)BlockIIRubberLeaves.RubberStuff.RUBBER)).func_177226_a((IProperty)BlockSapling.field_176479_b, (Comparable)Integer.valueOf(meta));
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        if (state == null || this.enumValues == null || !((Object)((Object)this)).equals(state.func_177230_c())) {
            return 0;
        }
        return (Integer)state.func_177229_b((IProperty)BlockSapling.field_176479_b);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            this.checkAndDropBlock(worldIn, pos, state);
            if (!worldIn.func_175697_a(pos, 1)) {
                return;
            }
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(worldIn, pos, state, rand);
            }
        }
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)BlockSapling.field_176479_b) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)BlockSapling.field_176479_b), 4);
        } else {
            this.generateTree(worldIn, pos, state, rand);
        }
    }

    public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        IIWorldGen.worldGenRubberTree.func_180709_b(worldIn, rand, pos);
        worldIn.func_180501_a(pos, IIContent.blockRubberLog.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y), 1);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state, rand);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(worldIn, pos) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    protected boolean canSustainBush(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150458_ak;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return this.canSustainBush(worldIn.func_180495_p(pos.func_177977_b()));
    }

    public EnumPlantType getPlantType(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

