/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.commands.ii;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.server.command.CommandTreeBase;
import net.minecraftforge.server.command.CommandTreeHelp;
import org.apache.commons.lang3.time.StopWatch;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoUtils;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IVehicleMultiPart;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.EntityParachute;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.util.IIExplosion;
import pl.pabilo8.immersiveintelligence.common.util.raytracer.BlacklistedRayTracer;
import pl.pabilo8.immersiveintelligence.common.util.raytracer.MultipleRayTracer;
import pl.pabilo8.immersiveintelligence.common.world.IIWorldGen;

public class CommandIIDev
extends CommandTreeHelp {
    private static final Set<String> OPTIONS = new HashSet<String>();

    public CommandIIDev(CommandTreeBase parent) {
        super(parent);
    }

    @Nonnull
    public String func_71517_b() {
        return "dev";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "Executes an Immersive Intelligence command, for more info use /ii dev help";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        block73: {
            block74: {
                if (args.length <= 0) break block74;
                Entity senderEntity = sender.func_174793_f();
                block25 : switch (args[0]) {
                    case "help": {
                        sender.func_145747_a(new TextComponentString("Executes an Immersive Intelligence command, usage /ii dev <option>").func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
                        sender.func_145747_a(this.getMessageForCommand("slowmo", "toggles bullets slowmo"));
                        sender.func_145747_a(this.getMessageForCommand("zawarudo", "toggles bullets slowmo, but it was me, D I O"));
                        sender.func_145747_a(this.getMessageForCommand("bulletspeed", "sets bullets slowmo speed", "<0.0-1.0>"));
                        sender.func_145747_a(this.getMessageForCommand("killbullets", "removes all bullets in 20 block radius"));
                        sender.func_145747_a(this.getMessageForCommand("killvehicles", "removes all vehicles (II multipart entities) in 20 block radius"));
                        sender.func_145747_a(this.getMessageForCommand("killitems", "removes all items in 20 block radius"));
                        sender.func_145747_a(this.getMessageForCommand("killhanses", "removes all ze Hanses in 20 block radius"));
                        sender.func_145747_a(this.getMessageForCommand("world_setup", "disables day and night and weather cycles, disables mob spawning"));
                        sender.func_145747_a(this.getMessageForCommand("tpd", "teleports the player to a dimension", "<dim>"));
                        sender.func_145747_a(this.getMessageForCommand("decaybullets", "toggles bullets decay (despawning after x amount of ticks existing)"));
                        sender.func_145747_a(this.getMessageForCommand("test_enemies", "spawns enemies", "<amount>"));
                        sender.func_145747_a(this.getMessageForCommand("explosion", "spawns an II explosion", "<size>"));
                        sender.func_145747_a(this.getMessageForCommand("nuke", "plants a seed on ground zero"));
                        sender.func_145747_a(this.getMessageForCommand("power", "charges held item or looked entity with IF, absolutely free"));
                        sender.func_145747_a(this.getMessageForCommand("tree", "creates a happy little [R E B B U R] tree"));
                        sender.func_145747_a(this.getMessageForCommand("parachute", "spawns and mounts the command user on a parachute"));
                        sender.func_145747_a(this.getMessageForCommand("deth", "removes the entity player is looking at"));
                        sender.func_145747_a(this.getMessageForCommand("get_mb", "gets the internal data of a multiblock player is looking at"));
                        sender.func_145747_a(this.getMessageForCommand("place_mb", "places a multiblock", "<id>"));
                        break;
                    }
                    case "deth": {
                        if (senderEntity == null) {
                            return;
                        }
                        float blockReachDistance = 100.0f;
                        Vec3d vec3d = senderEntity.func_174824_e(0.0f);
                        Vec3d vec3d1 = senderEntity.func_70676_i(0.0f);
                        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * (double)blockReachDistance, vec3d1.field_72448_b * (double)blockReachDistance, vec3d1.field_72449_c * (double)blockReachDistance);
                        MultipleRayTracer rayTracer = MultipleRayTracer.volumetricTrace(sender.func_130014_f_(), vec3d, vec3d2, new AxisAlignedBB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5), Collections.emptyList(), true, Collections.singletonList(senderEntity), null);
                        for (RayTraceResult hit : rayTracer) {
                            if (hit.field_72313_a != RayTraceResult.Type.ENTITY) continue;
                            hit.field_72308_g.func_70106_y();
                            sender.func_145747_a((ITextComponent)new TextComponentString(hit.field_72308_g.func_145748_c_().func_150254_d() + " is dead, no big surprise."));
                            break block25;
                        }
                        break block73;
                    }
                    case "tree": {
                        if (senderEntity == null) {
                            return;
                        }
                        float blockReachDistance = 100.0f;
                        RayTraceResult traceResult = CommandIIDev.getRayTraceResult(senderEntity, blockReachDistance);
                        if (traceResult == null || traceResult.field_72313_a == RayTraceResult.Type.MISS) {
                            return;
                        }
                        IIWorldGen.worldGenRubberTree.func_180709_b(sender.func_130014_f_(), Utils.RAND, traceResult.func_178782_a().func_177984_a());
                        sender.func_145747_a((ITextComponent)new TextComponentString("Adding a happy little tree :)"));
                        break;
                    }
                    case "slowmo": {
                        EntityBullet.DEV_SLOMO = 0.005f;
                        EntityBullet.DEV_DECAY = false;
                        sender.func_145747_a((ITextComponent)new TextComponentString("Slomo activated!"));
                        break;
                    }
                    case "zawarudo": {
                        if (EntityBullet.DEV_SLOMO == 0.0f) {
                            sender.func_145747_a((ITextComponent)new TextComponentString("Toki wo tomatta."));
                            EntityBullet.DEV_SLOMO = 1.0f;
                            EntityBullet.DEV_DECAY = true;
                            break;
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentString("Za Warudo! Toki wo tomare!"));
                        EntityBullet.DEV_SLOMO = 0.0f;
                        EntityBullet.DEV_DECAY = false;
                        break;
                    }
                    case "bulletspeed": {
                        if (args.length > 1) {
                            EntityBullet.DEV_SLOMO = (float)CommandIIDev.func_175765_c((String)args[1]);
                            sender.func_145747_a((ITextComponent)new TextComponentString("Bullet speed set to " + args[1]));
                            break;
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Please enter a speed value, default 1, current " + (int)EntityBullet.DEV_SLOMO));
                        break;
                    }
                    case "killbullets": {
                        sender.func_130014_f_().func_175644_a(EntityBullet.class, input -> true).forEach(Entity::func_70106_y);
                        sender.func_145747_a((ITextComponent)new TextComponentString("All bullets killed!"));
                        break;
                    }
                    case "killitems": {
                        sender.func_130014_f_().func_175644_a(EntityItem.class, input -> (input != null ? input.func_174791_d().func_72438_d(sender.func_174791_d()) : 25.0) < 25.0).forEach(Entity::func_70106_y);
                        sender.func_130014_f_().func_175644_a(EntityXPOrb.class, input -> (input != null ? input.func_174791_d().func_72438_d(sender.func_174791_d()) : 25.0) < 25.0).forEach(Entity::func_70106_y);
                        sender.func_130014_f_().func_175644_a(EntityArrow.class, input -> (input != null ? input.func_174791_d().func_72438_d(sender.func_174791_d()) : 25.0) < 25.0).forEach(Entity::func_70106_y);
                        sender.func_145747_a((ITextComponent)new TextComponentString("Items Killed!"));
                        break;
                    }
                    case "killvehicles": {
                        sender.func_130014_f_().func_175644_a(Entity.class, input -> (input instanceof IVehicleMultiPart ? input.func_174791_d().func_72438_d(sender.func_174791_d()) : 25.0) < 25.0).forEach(Entity::func_70106_y);
                        sender.func_145747_a((ITextComponent)new TextComponentString("Vehicles Killed!"));
                        break;
                    }
                    case "killhanses": {
                        sender.func_130014_f_().func_175644_a(EntityHans.class, input -> (input != null ? input.func_174791_d().func_72438_d(sender.func_174791_d()) : 25.0) < 25.0).forEach(Entity::func_70106_y);
                        sender.func_145747_a((ITextComponent)new TextComponentString("All Hanses killed :("));
                        break;
                    }
                    case "decaybullets": {
                        EntityBullet.DEV_DECAY = !EntityBullet.DEV_DECAY;
                        sender.func_145747_a((ITextComponent)new TextComponentString(String.valueOf(EntityBullet.DEV_DECAY)));
                        break;
                    }
                    case "world_setup": {
                        server.func_130014_f_().func_82736_K().func_82764_b("doDaylightCycle", "false");
                        server.func_130014_f_().func_82736_K().func_82764_b("doWeatherCycle", "false");
                        server.func_130014_f_().func_82736_K().func_82764_b("doMobSpawning", "false");
                        sender.func_145747_a((ITextComponent)new TextComponentString("World setup done!"));
                        break;
                    }
                    case "tpd": {
                        if (args.length <= 1 || senderEntity == null) break;
                        senderEntity.changeDimension(Integer.parseInt(args[1]), (ITeleporter)new IITeleporter());
                        sender.func_145747_a((ITextComponent)new TextComponentString("Preparing to jump!"));
                        break;
                    }
                    case "vtrace": {
                        float blockReachDistance = 6.0f;
                        Vec3d vec3d = senderEntity.func_174824_e(0.0f);
                        Vec3d vec3d1 = senderEntity.func_70676_i(0.0f);
                        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * (double)blockReachDistance, vec3d1.field_72448_b * (double)blockReachDistance, vec3d1.field_72449_c * (double)blockReachDistance);
                        StopWatch watch = new StopWatch();
                        watch.start();
                        BlacklistedRayTracer.traceIgnoringBlocks(senderEntity.field_70170_p, vec3d, vec3d2, Collections.emptyList(), 0);
                        watch.stop();
                        sender.func_145747_a((ITextComponent)new TextComponentString("Time: " + watch.getNanoTime() + " ns"));
                        watch.reset();
                        watch.start();
                        senderEntity.field_70170_p.func_72933_a(vec3d, vec3d2);
                        watch.stop();
                        sender.func_145747_a((ITextComponent)new TextComponentString("Time: " + watch.getNanoTime() + " ns"));
                        watch.reset();
                        watch.start();
                        MultipleRayTracer.volumetricTrace(sender.func_130014_f_(), vec3d, vec3d2, new AxisAlignedBB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5), Collections.emptyList(), false, Collections.singletonList(senderEntity), null);
                        watch.stop();
                        sender.func_145747_a((ITextComponent)new TextComponentString("Time: " + watch.getNanoTime() + " ns"));
                        break;
                    }
                    case "power": {
                        IEnergyStorage capability;
                        Entity entityHit;
                        if (senderEntity == null) {
                            return;
                        }
                        float blockReachDistance = 6.0f;
                        Vec3d vec3d = senderEntity.func_174824_e(0.0f);
                        Vec3d vec3d1 = senderEntity.func_70676_i(0.0f);
                        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * (double)blockReachDistance, vec3d1.field_72448_b * (double)blockReachDistance, vec3d1.field_72449_c * (double)blockReachDistance);
                        MultipleRayTracer rayTracer = MultipleRayTracer.volumetricTrace(sender.func_130014_f_(), vec3d, vec3d2, new AxisAlignedBB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5), Collections.emptyList(), true, Collections.singletonList(senderEntity), null);
                        if (!rayTracer.getHits().isEmpty() && (entityHit = rayTracer.getHits().get((int)0).field_72308_g) != null && entityHit.hasCapability(CapabilityEnergy.ENERGY, null) && (capability = (IEnergyStorage)entityHit.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
                            while (capability.getEnergyStored() != capability.getMaxEnergyStored()) {
                                capability.receiveEnergy(Integer.MAX_VALUE, false);
                            }
                            return;
                        }
                        senderEntity.func_184214_aD().forEach(stack -> {
                            if (stack.func_77973_b() instanceof IEItemInterfaces.IAdvancedFluidItem) {
                                IEItemInterfaces.IAdvancedFluidItem item = (IEItemInterfaces.IAdvancedFluidItem)stack.func_77973_b();
                                for (Fluid f : FluidRegistry.getRegisteredFluids().values()) {
                                    IFluidHandler capability;
                                    FluidStack fluidStack = new FluidStack(f, 10000000);
                                    if (!item.allowFluid(stack, fluidStack) || (capability = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) == null) continue;
                                    capability.fill(fluidStack, true);
                                    break;
                                }
                            }
                            if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                                ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).receiveEnergy(Integer.MAX_VALUE, false);
                            }
                        });
                        break;
                    }
                    case "explosion": 
                    case "nuke": {
                        if (senderEntity == null || server.func_130014_f_().field_72995_K) {
                            return;
                        }
                        float blockReachDistance = 100.0f;
                        RayTraceResult traceResult = CommandIIDev.getRayTraceResult(senderEntity, blockReachDistance);
                        if (traceResult == null || traceResult.field_72313_a == RayTraceResult.Type.MISS) {
                            return;
                        }
                        BlockPos pos = traceResult.func_178782_a();
                        if (args[0].equals("nuke")) {
                            ItemStack s2 = IIContent.itemAmmoArtillery.getBulletWithParams("core_brass", "canister", "nuke");
                            EntityBullet a = AmmoUtils.createBullet(senderEntity.func_130014_f_(), s2, new Vec3d((Vec3i)pos).func_72441_c(0.0, 2.0, 0.0), new Vec3d(0.0, -1.0, 0.0));
                            senderEntity.func_130014_f_().func_72838_d((Entity)a);
                            return;
                        }
                        int num = 0;
                        try {
                            num = Math.abs(Integer.parseInt(args[1]));
                        }
                        catch (Exception a) {
                            // empty catch block
                        }
                        IIExplosion exp = new IIExplosion(server.func_130014_f_(), senderEntity, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p(), num, 1.0f, false, true);
                        exp.func_77278_a();
                        exp.func_77279_a(true);
                        break;
                    }
                    case "test_enemies": {
                        if (senderEntity == null || server.func_130014_f_().field_72995_K) {
                            return;
                        }
                        float blockReachDistance = 100.0f;
                        RayTraceResult traceResult = CommandIIDev.getRayTraceResult(senderEntity, blockReachDistance);
                        if (traceResult == null || traceResult.field_72313_a == RayTraceResult.Type.MISS) {
                            return;
                        }
                        Vec3d pos = new Vec3d((Vec3i)traceResult.func_178782_a().func_177984_a());
                        int num = 0;
                        try {
                            num = Math.abs(Integer.parseInt(args[1]));
                        }
                        catch (Exception exp) {
                            // empty catch block
                        }
                        if (!server.func_130014_f_().field_72995_K) {
                            World world = senderEntity.func_130014_f_();
                            int row = (int)Math.floor(Math.sqrt(num));
                            int roff = (int)Math.floor((float)row / 2.0f);
                            int i = 0;
                            int missed = 0;
                            while (i < num) {
                                int c = i + missed;
                                Vec3d offset = pos.func_72441_c((double)(-roff), 0.0, (double)(-roff)).func_178787_e(new Vec3d(Math.floor((float)c / (float)row), 0.0, (double)(c % row)));
                                if (world.func_180495_p(new BlockPos(offset)).func_191058_s()) {
                                    ++missed;
                                    continue;
                                }
                                EntitySkeleton z1 = new EntitySkeleton(senderEntity.func_130014_f_());
                                z1.func_184611_a(EnumHand.MAIN_HAND, new ItemStack((Item)Items.field_151031_f));
                                z1.func_70659_e(0.125f);
                                z1.func_70107_b(offset.field_72450_a + 0.5, offset.field_72448_b, offset.field_72449_c + 0.5);
                                z1.func_96094_a("Zombie #" + i);
                                z1.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)IIContent.itemLightEngineerHelmet));
                                senderEntity.func_130014_f_().func_72838_d((Entity)z1);
                                ++i;
                            }
                            sender.func_145747_a((ITextComponent)new TextComponentString("Test enemies summoned!"));
                            break;
                        }
                        break block73;
                    }
                    case "parachute": {
                        if (senderEntity == null) break;
                        EntityParachute para = new EntityParachute(senderEntity.func_130014_f_());
                        para.func_70107_b(senderEntity.field_70165_t, senderEntity.field_70163_u, senderEntity.field_70161_v);
                        senderEntity.func_130014_f_().func_72838_d((Entity)para);
                        senderEntity.func_184220_m((Entity)para);
                        break;
                    }
                    case "get_mb": {
                        RayTraceResult traceResult = CommandIIDev.getRayTraceResult(senderEntity, 40.0f);
                        if (traceResult == null || traceResult.field_72313_a == RayTraceResult.Type.MISS) {
                            return;
                        }
                        TileEntity te = senderEntity.func_130014_f_().func_175625_s(traceResult.func_178782_a());
                        if (te instanceof TileEntityMultiblockPart) {
                            senderEntity.func_145747_a(new TextComponentString(TextFormatting.GOLD + "ID: " + TextFormatting.RESET + ((TileEntityMultiblockPart)te).field_174879_c + " | ").func_150257_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Mirrored: " + TextFormatting.RESET + ((TileEntityMultiblockPart)te).mirrored + " | ")).func_150257_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Facing: " + TextFormatting.RESET + ((TileEntityMultiblockPart)te).facing.name())));
                            break;
                        }
                        break block73;
                    }
                    case "place_mb": {
                        RayTraceResult traceResult = CommandIIDev.getRayTraceResult(senderEntity, 40.0f);
                        if (traceResult == null || traceResult.field_72313_a == RayTraceResult.Type.MISS) {
                            return;
                        }
                        for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
                            if (!mb.getUniqueName().equals(args[1])) continue;
                            BlockPos placed = traceResult.func_178782_a().func_177984_a();
                            ItemStack[][][] manual = mb.getStructureManual();
                            int hh = manual.length;
                            int ww = manual[0][0].length;
                            int ll = manual[0].length;
                            for (int y = 0; y < hh; ++y) {
                                for (int z = 0; z < ll; ++z) {
                                    for (int x = 0; x < ww; ++x) {
                                        IBlockState state;
                                        ItemStack stack2 = manual[y][z][x];
                                        if (stack2 == null || stack2.func_190926_b() || (state = mb.getBlockstateFromStack(y * ww * ll + z * ww + x, stack2)) == null) continue;
                                        senderEntity.field_70170_p.func_175656_a(placed.func_177982_a(x, y, z), state);
                                    }
                                }
                            }
                            break block73;
                        }
                        break;
                    }
                }
                break block73;
            }
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
    }

    @Nullable
    private static RayTraceResult getRayTraceResult(@Nullable Entity entity, float traceDistance) {
        if (entity == null) {
            return null;
        }
        Vec3d eyesPos = entity.func_174824_e(0.0f);
        Vec3d lookVector = entity.func_70676_i(0.0f);
        Vec3d traceVector = eyesPos.func_72441_c(lookVector.field_72450_a * (double)traceDistance, lookVector.field_72448_b * (double)traceDistance, lookVector.field_72449_c * (double)traceDistance);
        return entity.func_130014_f_().func_147447_a(eyesPos, traceVector, false, false, true);
    }

    public int func_82362_a() {
        return 4;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        switch (args.length) {
            case 1: {
                return CommandIIDev.func_175762_a((String[])args, OPTIONS);
            }
            case 2: {
                switch (args[0]) {
                    case "place_mb": {
                        return MultiblockHandler.getMultiblocks().stream().map(MultiblockHandler.IMultiblock::getUniqueName).map(s -> s.startsWith("II:") ? TextFormatting.GOLD + s + TextFormatting.RESET : s).collect(Collectors.toList());
                    }
                }
                return Collections.emptyList();
            }
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public ITextComponent getMessageForCommand(String subcommand, String description) {
        return this.getMessageForCommand(subcommand, description, "");
    }

    public ITextComponent getMessageForCommand(String subcommand, String description, String arguments) {
        return new TextComponentString("/ii dev ").func_150258_a(subcommand).func_150258_a(arguments.isEmpty() ? arguments : " " + arguments).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/ii dev " + subcommand))).func_150257_a(new TextComponentString(" - ").func_150258_a(description).func_150255_a(new Style().func_150238_a(TextFormatting.RESET)));
    }

    static {
        OPTIONS.add("help");
        OPTIONS.add("slowmo");
        OPTIONS.add("zawarudo");
        OPTIONS.add("bulletspeed");
        OPTIONS.add("killbullets");
        OPTIONS.add("killvehicles");
        OPTIONS.add("killitems");
        OPTIONS.add("killhanses");
        OPTIONS.add("world_setup");
        OPTIONS.add("tpd");
        OPTIONS.add("decaybullets");
        OPTIONS.add("test_enemies");
        OPTIONS.add("explosion");
        OPTIONS.add("nuke");
        OPTIONS.add("power");
        OPTIONS.add("tree");
        OPTIONS.add("parachute");
        OPTIONS.add("deth");
        OPTIONS.add("get_mb");
        OPTIONS.add("place_mb");
    }

    private static class IITeleporter
    implements ITeleporter {
        private IITeleporter() {
        }

        public void placeEntity(World world, Entity entity, float yaw) {
            entity.func_174828_a(world.func_175694_M(), yaw, entity.field_70125_A);
        }
    }
}

