/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.BaublesCapabilities;
import blusunrize.immersiveengineering.common.Config;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import pl.pabilo8.immersiveintelligence.client.render.IIBipedLayerRenderer;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.compat.IICompatModule;

public class BaublesHelper
extends IICompatModule {
    private ResourceLocation res = new ResourceLocation("baubles", "bauble_cap");
    private static final IBauble BAUBLE_POWERPACK = new IBauble(){

        public BaubleType getBaubleType(ItemStack itemStack) {
            return BaubleType.BODY;
        }

        public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                IIBipedLayerRenderer.addWornAdvancedPowerpack(player, itemstack);
            }
            if (player instanceof EntityPlayer) {
                IIContent.itemAdvancedPowerPack.onArmorTick(player.field_70170_p, (EntityPlayer)player, itemstack);
            }
        }
    };

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        Config.manual_bool.put("baublesHere", true);
        baubles = true;
    }

    @Override
    public void registerRecipes() {
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }

    public static ItemStack getWornPouch(EntityPlayer player) {
        return BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(BaubleType.AMULET.getValidSlots()[0]);
    }

    @SubscribeEvent
    public void onCapabilitiesAttach(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() == IIContent.itemAdvancedPowerPack) {
            event.addCapability(this.res, this.provideBaubles(BAUBLE_POWERPACK));
        }
        if (((ItemStack)event.getObject()).func_77973_b() == IIContent.itemCasingPouch) {
            event.addCapability(this.res, this.provideBaubles(stack -> BaubleType.AMULET));
        }
    }

    public ICapabilityProvider provideBaubles(final IBauble bauble) {
        return new ICapabilityProvider(){

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                return (T)(capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE ? BaublesCapabilities.CAPABILITY_ITEM_BAUBLE.cast((Object)bauble) : null);
            }
        };
    }
}

