/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat;

import dan200.computercraft.api.lua.ArgumentHelper;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Optional;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeBoolean;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeFloat;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.common.block.data_device.tileentity.TileEntityDataConnector;
import pl.pabilo8.immersiveintelligence.common.compat.IICompatModule;

public class ComputerCraftHelper
extends IICompatModule {
    @Override
    public void preInit() {
    }

    @Override
    public void registerRecipes() {
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }

    public static DataConnectorPeripheral createConnectorPeripheral(TileEntityDataConnector te) {
        return new DataConnectorPeripheral(te);
    }

    @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="computercraft")
    public static class DataConnectorPeripheral
    implements IPeripheral {
        private final TileEntityDataConnector te;

        public DataConnectorPeripheral(TileEntityDataConnector te) {
            this.te = te;
        }

        @Nonnull
        public String getType() {
            return "data_connector";
        }

        @Nonnull
        public String[] getMethodNames() {
            return new String[]{"send", "canReceive", "receive", "getNetworkSize"};
        }

        @Nullable
        public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] args) throws LuaException {
            switch (method) {
                case 0: {
                    DataPacket packet = new DataPacket();
                    if (args.length > 0) {
                        Map map = ArgumentHelper.optTable((Object[])args, (int)0, new HashMap());
                        for (char c : DataPacket.varCharacters) {
                            IDataType type;
                            if (!map.containsKey(String.valueOf(c))) continue;
                            Object o = map.get(String.valueOf(c));
                            switch (ArgumentHelper.getType(o)) {
                                default: {
                                    type = new DataTypeString(o.toString());
                                    break;
                                }
                                case "nil": {
                                    type = new DataTypeNull();
                                    break;
                                }
                                case "boolean": {
                                    type = new DataTypeBoolean((Boolean)o);
                                    break;
                                }
                                case "number": {
                                    Number num = (Number)o;
                                    type = num.floatValue() % 1.0f > 0.0f ? new DataTypeFloat(num.floatValue()) : new DataTypeInteger(num.intValue());
                                }
                            }
                            packet.setVariable(Character.valueOf(c), type);
                        }
                    }
                    this.te.sendPacket(packet);
                    return new Object[0];
                }
                case 1: {
                    return new Object[]{!this.te.compatReceived};
                }
                case 2: {
                    if (!this.te.compatReceived) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        for (Map.Entry<Character, IDataType> entry : this.te.lastReceived.variables.entrySet()) {
                            map.put(entry.getKey().toString(), entry.getValue().valueToString());
                        }
                        this.te.compatReceived = true;
                        return new Object[]{map};
                    }
                    return null;
                }
                case 3: {
                    return new Object[]{this.te.getDataNetwork().connectors.size()};
                }
            }
            return null;
        }

        public boolean equals(@Nullable IPeripheral other) {
            return other instanceof DataConnectorPeripheral && ((DataConnectorPeripheral)other).te == this.te;
        }
    }
}

