/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat;

import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IILogger;
import pl.pabilo8.immersiveintelligence.common.compat.BaublesHelper;
import pl.pabilo8.immersiveintelligence.common.compat.ComputerCraftHelper;
import pl.pabilo8.immersiveintelligence.common.compat.ImmersiveEnergyHelper;
import pl.pabilo8.immersiveintelligence.common.compat.ImmersiveEngineeringHelper;
import pl.pabilo8.immersiveintelligence.common.compat.ImmersivePetroleumHelper;
import pl.pabilo8.immersiveintelligence.common.compat.ImmersivePostsHelper;
import pl.pabilo8.immersiveintelligence.common.compat.OpenComputersHelper;
import pl.pabilo8.immersiveintelligence.common.compat.TerrafirmaHelper;
import pl.pabilo8.immersiveintelligence.common.compat.it.ImmersiveTechnologyHelper;

public abstract class IICompatModule {
    public static HashMap<String, Class<? extends IICompatModule>> moduleClasses = new HashMap();
    public static HashMap<String, String> moduleMinModVersions = new HashMap();
    public static Set<IICompatModule> modules = new HashSet<IICompatModule>();
    public static boolean serene = false;
    public static boolean baubles = false;
    public static boolean petroleum = false;
    public static boolean serverStartingDone;

    public static void doModulesPreInit() {
        for (Map.Entry<String, Class<? extends IICompatModule>> e : moduleClasses.entrySet()) {
            if (!Loader.isModLoaded((String)e.getKey())) continue;
            try {
                Boolean enabled = IIConfigHandler.IIConfig.compat.get(e.getKey());
                IILogger.info(e.getKey() + Utils.getModVersion((String)e.getKey()));
                if (moduleMinModVersions.containsKey(e.getKey()) && new DefaultArtifactVersion(moduleMinModVersions.get(e.getKey())).compareTo((ArtifactVersion)new DefaultArtifactVersion(Utils.getModVersion((String)e.getKey()))) >= 0) {
                    IILogger.info("Consider updating " + e.getKey() + ", II adds additional compat for the new version");
                    continue;
                }
                if (enabled == null || !enabled.booleanValue()) continue;
                IICompatModule m = e.getValue().newInstance();
                modules.add(m);
                m.preInit();
            }
            catch (Exception exception) {
                IILogger.error("Compat module for " + e.getKey() + " could not be pre-initialized. Report this and include the error message below!", exception);
            }
        }
    }

    private static void doModuleAction(Consumer<IICompatModule> action, String message) {
        for (IICompatModule compat : modules) {
            try {
                action.accept(compat);
            }
            catch (Exception exception) {
                IILogger.error("Compat module for %s %s. Report this and include the error message below!", compat, message);
                IILogger.error(exception);
            }
        }
    }

    public static void doModulesRecipes() {
        IICompatModule.doModuleAction(IICompatModule::registerRecipes, "could not register recipes");
    }

    public static void doModulesInit() {
        IICompatModule.doModuleAction(IICompatModule::init, "could not be initialized");
    }

    public static void doModulesPostInit() {
        IICompatModule.doModuleAction(IICompatModule::postInit, "could not be post-initialized");
    }

    public static void doModulesClientPreInit() {
        IICompatModule.doModuleAction(IICompatModule::clientPreInit, "could not pre-initialize on client side");
    }

    public static void doModulesClientInit() {
        IICompatModule.doModuleAction(IICompatModule::clientInit, "could not be initialized on client side");
    }

    public static void doModulesClientPostInit() {
        IICompatModule.doModuleAction(IICompatModule::clientPostInit, "could not be post-initialized on client side");
    }

    public static void doModulesLoadComplete() {
        if (!serverStartingDone) {
            serverStartingDone = true;
            IICompatModule.doModuleAction(IICompatModule::loadComplete, "could not complete loading");
        }
    }

    public abstract void preInit();

    public abstract void registerRecipes();

    public abstract void init();

    public abstract void postInit();

    public void loadComplete() {
    }

    @SideOnly(value=Side.CLIENT)
    public void clientPreInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public void clientInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public void clientPostInit() {
    }

    static {
        moduleClasses.put("immersiveengineering", ImmersiveEngineeringHelper.class);
        moduleClasses.put("immersivepetroleum", ImmersivePetroleumHelper.class);
        moduleClasses.put("immersiveposts", ImmersivePostsHelper.class);
        moduleClasses.put("immersivetech", ImmersiveTechnologyHelper.class);
        moduleMinModVersions.put("immersivetech", "1.7.50");
        moduleClasses.put("immersive_energy", ImmersiveEnergyHelper.class);
        moduleClasses.put("tfc", TerrafirmaHelper.class);
        moduleClasses.put("baubles", BaublesHelper.class);
        moduleClasses.put("opencomputers", OpenComputersHelper.class);
        moduleClasses.put("computercraft", ComputerCraftHelper.class);
        serverStartingDone = false;
    }
}

