/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat;

import blusunrize.immersiveengineering.common.util.compat.opencomputers.ManagedEnvironmentIE;
import java.util.HashMap;
import java.util.Map;
import li.cil.oc.api.API;
import li.cil.oc.api.driver.DriverBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeBoolean;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeFloat;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.common.block.data_device.tileentity.TileEntityDataConnector;
import pl.pabilo8.immersiveintelligence.common.compat.IICompatModule;

public class OpenComputersHelper
extends IICompatModule {
    @Override
    public void preInit() {
    }

    @Override
    public void registerRecipes() {
    }

    @Override
    public void init() {
        API.driver.add((DriverBlock)new DataConnectorDriver());
    }

    @Override
    public void postInit() {
    }

    public static class DataConnectorEnvironment
    extends ManagedEnvironmentIE<TileEntityDataConnector> {
        public DataConnectorEnvironment(World w, BlockPos bp) {
            super(w, bp, TileEntityDataConnector.class);
        }

        @Callback(doc="function(packet):nil -- sends a packet to the data network")
        public Object[] send(Context context, Arguments args) {
            DataPacket packet = new DataPacket();
            if (args.isTable(0)) {
                Map map = args.checkTable(0);
                for (char c : DataPacket.varCharacters) {
                    Number num;
                    if (!map.containsKey(String.valueOf(c))) continue;
                    Object o = map.get(String.valueOf(c));
                    IDataType type = o instanceof Boolean ? new DataTypeBoolean((Boolean)o) : (o == null ? new DataTypeNull() : (o instanceof Number ? ((num = (Number)o).floatValue() % 1.0f > 0.0f ? new DataTypeFloat(num.floatValue()) : new DataTypeInteger(num.intValue())) : new DataTypeString(o.toString())));
                    packet.setVariable(Character.valueOf(c), type);
                }
            }
            ((TileEntityDataConnector)this.getTileEntity()).sendPacket(packet);
            return new Object[0];
        }

        @Callback(doc="function():boolean -- returns true if a new data packet has been received")
        public Object[] canReceive(Context context, Arguments args) {
            return new Object[]{!((TileEntityDataConnector)this.getTileEntity()).compatReceived};
        }

        @Callback(doc="function():table -- returns the last received data packet")
        public Object[] receive(Context context, Arguments args) {
            TileEntityDataConnector te = (TileEntityDataConnector)this.getTileEntity();
            if (!te.compatReceived) {
                HashMap<String, String> map = new HashMap<String, String>();
                for (Map.Entry<Character, IDataType> entry : te.lastReceived.variables.entrySet()) {
                    map.put(entry.getKey().toString(), entry.getValue().valueToString());
                }
                te.compatReceived = true;
                return new Object[]{map};
            }
            return null;
        }

        @Callback(doc="function():number -- gets amount of devices connected to the data network")
        public Object[] getNetworkSize(Context context, Arguments args) {
            return new Object[]{((TileEntityDataConnector)this.getTileEntity()).getDataNetwork().connectors.size()};
        }

        public String preferredName() {
            return "ii_data_connector";
        }

        public int priority() {
            return 1000;
        }
    }

    public static class DataConnectorDriver
    extends DriverSidedTileEntity {
        public ManagedEnvironment createEnvironment(World w, BlockPos bp, EnumFacing f) {
            TileEntity te = w.func_175625_s(bp);
            if (te instanceof TileEntityDataConnector) {
                return new DataConnectorEnvironment(w, bp);
            }
            return null;
        }

        public Class<?> getTileEntityClass() {
            return TileEntityDataConnector.class;
        }
    }
}

