/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.List;
import net.minecraft.item.ItemStack;
import pl.pabilo8.immersiveintelligence.api.crafting.AmmunitionWorkshopRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveintelligence.AmmunitionWorkshop")
@ZenRegister
public class AmmunitionWorkshopTweaker {
    @ZenMethod
    public static void addRecipe(IIngredient coreInput, IIngredient casingInput, IAmmunitionWorkshopFunction function, int energy, int time) {
        IngredientStack iCoreInput = CraftTweakerHelper.toIEIngredientStack((IIngredient)coreInput);
        IngredientStack iCasingInput = CraftTweakerHelper.toIEIngredientStack((IIngredient)casingInput);
        Object oItemInput = CraftTweakerHelper.toObject((IIngredient)coreInput);
        if (oItemInput == null) {
            CraftTweakerAPI.getLogger().logError("Could not add ammunition workshop recipe, input was null");
            return;
        }
        AmmunitionWorkshopRecipe r = new AmmunitionWorkshopRecipe((s1, s2) -> CraftTweakerMC.getItemStack((IItemStack)function.process(CraftTweakerMC.getIItemStack((ItemStack)s1), CraftTweakerMC.getIItemStack((ItemStack)s2))), iCoreInput, iCasingInput, energy, time);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack((IItemStack)output)));
    }

    @ZenClass(value="mods.immersiveintelligence.IAmmunitionWorkshopFunction")
    @ZenRegister
    public static interface IAmmunitionWorkshopFunction {
        public IItemStack process(IItemStack var1, IItemStack var2);
    }

    private static class Remove
    implements IAction {
        private final ItemStack input;
        List<AmmunitionWorkshopRecipe> removedRecipes;

        public Remove(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            this.removedRecipes = AmmunitionWorkshopRecipe.removeRecipesForCore(this.input);
        }

        public String describe() {
            return "Removing Ammunition Workshop Recipe for " + this.input.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final AmmunitionWorkshopRecipe recipe;

        public Add(AmmunitionWorkshopRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            AmmunitionWorkshopRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Ammunition Workshop Recipe for " + this.recipe.coreInput.getExampleStack().func_82833_r();
        }
    }
}

