/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat.crafttweaker;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IMaterial;
import crafttweaker.api.minecraft.CraftTweakerMC;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoUtils;
import pl.pabilo8.immersiveintelligence.api.bullets.PenetrationRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.penhandlers.PenetrationHandlerMetals;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveintelligence.BlockPenetration")
@ZenRegister
public class BlockPenetrationTweaker {
    @ZenMethod
    public static void addMaterial(IMaterial material, float integrity, float density, String penetrationType, String sound) {
        Material mat = CraftTweakerMC.getMaterial((IMaterial)material);
        CTPenetrationHandler pen = new CTPenetrationHandler(integrity, density, sound, penetrationType);
        PenetrationRegistry.registeredMaterials.put(m -> m == mat, pen);
    }

    @ZenMethod
    public static void addBlock(crafttweaker.api.block.IBlockState state, float integrity, float density, String penetrationType, String sound) {
        CTPenetrationHandler pen = new CTPenetrationHandler(integrity, density, sound, penetrationType);
        PenetrationRegistry.registeredBlocks.put(b -> state.compare(CraftTweakerMC.getBlockState((IBlockState)b)) == 0, pen);
    }

    @ZenMethod
    public static void addMetal(String name, final float integrity, final float density) {
        PenetrationHandlerMetals.PenetrationHandlerMetal pen = new PenetrationHandlerMetals.PenetrationHandlerMetal(){

            @Override
            public float getIntegrity() {
                return integrity;
            }

            @Override
            public float getDensity() {
                return density;
            }
        };
        AmmoUtils.registerMetalMaterial(pen, name);
    }

    private static class CTPenetrationHandler
    implements PenetrationRegistry.IPenetrationHandler {
        float integrity;
        float density;
        SoundEvent sound;
        AmmoRegistry.PenMaterialTypes penMat;

        public CTPenetrationHandler(float integrity, float density, @Nullable String sound, String penMat) {
            this.integrity = integrity;
            this.density = density;
            this.sound = sound == null ? null : (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(sound));
            this.penMat = AmmoRegistry.PenMaterialTypes.v(penMat);
        }

        @Override
        public float getIntegrity() {
            return this.integrity;
        }

        @Override
        public float getDensity() {
            return this.density;
        }

        @Override
        @Nullable
        public SoundEvent getSpecialSound(PenetrationRegistry.HitEffect effect) {
            return this.sound;
        }

        @Override
        public AmmoRegistry.PenMaterialTypes getPenetrationType() {
            return this.penMat;
        }
    }
}

