/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat.crafttweaker;

import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import pl.pabilo8.immersiveintelligence.api.crafting.CoagulatorRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveintelligence.Coagulator")
@ZenRegister
public class CoagulatorTweaker {
    @ZenMethod
    public static void addRecipe(IItemStack itemOutput, ILiquidStack fluidInput, ILiquidStack coagulantInput, int energy, int mixingTime) {
        FluidStack f1 = CraftTweakerMC.getLiquidStack((ILiquidStack)fluidInput);
        FluidStack f2 = CraftTweakerMC.getLiquidStack((ILiquidStack)coagulantInput);
        ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)itemOutput);
        if (f1 == null || f2 == null) {
            CraftTweakerAPI.getLogger().logError("Could not add coagulator recipe for " + itemOutput.getDisplayName() + ", input was null");
            return;
        }
        CoagulatorRecipe r = new CoagulatorRecipe(stack, f1, f2, energy, mixingTime);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack((IItemStack)output)));
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<CoagulatorRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = CoagulatorRecipe.removeRecipesForOutput(this.output);
        }

        public String describe() {
            return "Removing Coagulator Recipe for " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final CoagulatorRecipe recipe;

        public Add(CoagulatorRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            CoagulatorRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Coagulator Recipe for " + this.recipe.itemOutput.func_82833_r();
        }
    }
}

