/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration0;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration2;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDevice0;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDevice1;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDecoration;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDevice0;
import blusunrize.immersiveengineering.common.crafting.RecipeRGBColouration;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import pl.pabilo8.immersiveintelligence.api.PackerHandler;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.api.crafting.AmmunitionWorkshopRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.BathingRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.CoagulatorRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.DustStack;
import pl.pabilo8.immersiveintelligence.api.crafting.ElectrolyzerRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.FillerRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.PaintingRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.PrecissionAssemblerRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.SawmillRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.VulcanizerRecipe;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.metal_device.BlockIIMetalDevice;
import pl.pabilo8.immersiveintelligence.common.block.mines.BlockIIMine;
import pl.pabilo8.immersiveintelligence.common.block.simple.BlockIIConcreteDecoration;
import pl.pabilo8.immersiveintelligence.common.block.simple.BlockIIOre;
import pl.pabilo8.immersiveintelligence.common.block.simple.BlockIISmallCrate;
import pl.pabilo8.immersiveintelligence.common.crafting.RecipeCrateConversion;
import pl.pabilo8.immersiveintelligence.common.crafting.RecipeMinecart;
import pl.pabilo8.immersiveintelligence.common.item.ItemIIMinecart;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIAmmoBase;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIAmmoCasing;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIBulletMagazine;
import pl.pabilo8.immersiveintelligence.common.item.crafting.ItemIIMaterial;
import pl.pabilo8.immersiveintelligence.common.item.crafting.ItemIIMetalPressMold;
import pl.pabilo8.immersiveintelligence.common.item.crafting.ItemIIPrecisionTool;
import pl.pabilo8.immersiveintelligence.common.item.crafting.ItemIIVulcanizerMold;
import pl.pabilo8.immersiveintelligence.common.item.crafting.material.ItemIIMaterialBoule;
import pl.pabilo8.immersiveintelligence.common.item.crafting.material.ItemIIMaterialDust;
import pl.pabilo8.immersiveintelligence.common.item.crafting.material.ItemIIMaterialIngot;
import pl.pabilo8.immersiveintelligence.common.item.crafting.material.ItemIIMaterialNugget;
import pl.pabilo8.immersiveintelligence.common.item.crafting.material.ItemIIMaterialPlate;
import pl.pabilo8.immersiveintelligence.common.item.crafting.material.ItemIIMaterialSpring;
import pl.pabilo8.immersiveintelligence.common.item.data.ItemIIFunctionalCircuit;
import pl.pabilo8.immersiveintelligence.common.item.mechanical.ItemIIMotorGear;

public class IIRecipes {
    public static ItemStack BASIC_CIRCUIT;
    public static ItemStack TOOL_HAMMER;
    public static ItemStack TOOL_CUTTERS;
    public static IngredientStack AMMO_CASINGS;

    public static void doRecipes(IForgeRegistry<IRecipe> recipeRegistry) {
        BASIC_CIRCUIT = new ItemStack((Item)IEContent.itemMaterial, 1, 27);
        TOOL_HAMMER = new ItemStack((Item)IEContent.itemTool, 1, 0);
        TOOL_CUTTERS = new ItemStack((Item)IEContent.itemTool, 1, 1);
        AMMO_CASINGS = new IngredientStack(AmmoRegistry.INSTANCE.registeredBulletItems.values().stream().map(iAmmo -> iAmmo.getCasingStack(1)).collect(Collectors.toList()));
        IIRecipes.addMinecartRecipes(recipeRegistry);
        IIRecipes.addSmallCrateRecipes(recipeRegistry);
        IIRecipes.addMetalPressRecipes();
        IIRecipes.addBulletPressRecipes();
        IIRecipes.addFillerRecipes();
        IIRecipes.addSiliconProcessingRecipes();
        IIRecipes.addCircuitRecipes();
        IIRecipes.addFunctionalCircuits();
        IIRecipes.addSpringRecipes();
        IIRecipes.addHandWeaponRecipes(recipeRegistry);
        IIRecipes.addMiscIERecipes();
        IIRecipes.addWoodTableSawRecipes();
        IIRecipes.addRotaryPowerRecipes();
        IIRecipes.addUpgradeRecipes();
        IIRecipes.addRDXProductionRecipes();
        IIRecipes.addHMXProductionRecipes();
        IIRecipes.addConcreteRecipes();
        IIRecipes.addChemicalBathCleaningRecipes();
        IIRecipes.addColouringRecipes(recipeRegistry);
        IIRecipes.addChemicalPainterRecipes();
        IIRecipes.addPackerHandling();
        IIRecipes.addElectrolyzerRecipes();
        IIRecipes.addInkRecipes();
        IIRecipes.addSmeltingRecipes();
        IIRecipes.addArcFurnaceRecyclingRecipes();
        IIRecipes.addAmmunitionCasingRecipes();
        IIRecipes.addRubberRecipes();
        IIRecipes.addDuraluminiumRecipes();
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidEtchingAcid, 1000), (FluidStack)new FluidStack(IIContent.gasChlorine, 500), (Object[])new Object[]{"dustIron"}, (int)4800);
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidSulfuricAcid, 500), (FluidStack)new FluidStack(FluidRegistry.WATER, 1000), (Object[])new Object[]{"dustSulfur"}, (int)4800);
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidHydrofluoricAcid, 500), (FluidStack)new FluidStack(IIContent.fluidSulfuricAcid, 1000), (Object[])new Object[]{"dustFluorite"}, (int)5600);
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidNitricAcid, 250), (FluidStack)new FluidStack(IIContent.fluidSulfuricAcid, 1000), (Object[])new Object[]{"dustSaltpeter"}, (int)5600);
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidBrine, 750), (FluidStack)new FluidStack(FluidRegistry.WATER, 750), (Object[])new Object[]{"dustSalt"}, (int)3200);
    }

    private static void addElectrolyzerRecipes() {
        ElectrolyzerRecipe.addRecipe(FluidRegistry.getFluidStack((String)"water", (int)750), FluidRegistry.getFluidStack((String)"oxygen", (int)250), FluidRegistry.getFluidStack((String)"hydrogen", (int)500), 160, 80);
        ElectrolyzerRecipe.addRecipe(FluidRegistry.getFluidStack((String)"brine", (int)750), FluidRegistry.getFluidStack((String)"chlorine", (int)375), FluidRegistry.getFluidStack((String)"hydrogen", (int)375), 160, 80);
        ElectrolyzerRecipe.addRecipe(new FluidStack(IIContent.gasCO2, 750), new FluidStack(IIContent.gasCO, 500), new FluidStack(IIContent.gasOxygen, 250), 160, 160);
        RefineryRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidFormicAcid, 16), (FluidStack)new FluidStack(IIContent.fluidMethanol, 8), (FluidStack)new FluidStack(IIContent.gasCO, 8), (int)65);
    }

    private static void addColouringRecipes(IForgeRegistry<IRecipe> registry) {
        IIRecipes.addColoringRecipe(registry, IIContent.itemTracerPowder, 0, "colour", "tracer_powder_colour");
        IIRecipes.addColoringRecipe(registry, IIContent.itemTracerPowder, 1, "colour", "flare_powder_colour");
        IIRecipes.addColoringRecipe(registry, (Item)IIContent.itemAdvancedPowerPack, -1, "II:AdvancedPowerpackColour", "advanced_powerpack_coloring");
        IIRecipes.addColoringRecipe(registry, (Item)IIContent.itemLightEngineerHelmet, -1, "colour", "light_engineer_armor_helmet_coloring");
        IIRecipes.addColoringRecipe(registry, (Item)IIContent.itemLightEngineerChestplate, -1, "colour", "light_engineer_armor_chestplate_coloring");
        IIRecipes.addColoringRecipe(registry, (Item)IIContent.itemLightEngineerLeggings, -1, "colour", "light_engineer_armor_leggings_coloring");
        IIRecipes.addColoringRecipe(registry, (Item)IIContent.itemLightEngineerBoots, -1, "colour", "light_engineer_armor_boots_coloring");
    }

    private static void addColoringRecipe(IForgeRegistry<IRecipe> registry, Item item, int meta, String colorTag, String recipeName) {
        registry.register(new RecipeRGBColouration(s -> OreDictionary.itemMatches((ItemStack)new ItemStack(item, 1, meta == -1 ? 0 : meta), (ItemStack)s, (meta != -1 ? 1 : 0) != 0), s -> ItemNBTHelper.hasKey((ItemStack)s, (String)colorTag) ? ItemNBTHelper.getInt((ItemStack)s, (String)colorTag) : 0xFFFFFF, (s, i) -> ItemNBTHelper.setInt((ItemStack)s, (String)colorTag, (int)i)).setRegistryName("immersiveintelligence", recipeName));
    }

    public static void addCircuitRecipes() {
        if (IIConfigHandler.IIConfig.changeCircuitProduction) {
            BlueprintCraftingRecipe.recipeList.get((Object)"components").removeIf(blueprintCraftingRecipe -> blueprintCraftingRecipe.output.func_77969_a(BASIC_CIRCUIT));
            BlueprintCraftingRecipe.addRecipe((String)"basic_circuits", (ItemStack)IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.BASIC_CIRCUIT_BOARD_RAW, 3), (Object[])new Object[]{new ItemStack((Block)IEContent.blockStoneDecoration, 2, BlockTypes_StoneDecoration.INSULATING_GLASS.getMeta()), "plateCopper"});
            BlueprintCraftingRecipe.addRecipe((String)"basic_circuits", (ItemStack)BASIC_CIRCUIT, (Object[])new Object[]{"circuitBasicEtched", new IngredientStack("chipBasic", 2)});
            BlueprintCraftingRecipe.addRecipe((String)"advanced_circuits", (ItemStack)IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.ADVANCED_CIRCUIT_BOARD_RAW), (Object[])new Object[]{new IngredientStack("circuitBasicRaw", 2), "plateAdvancedElectronicAlloy"});
            BlueprintCraftingRecipe.addRecipe((String)"advanced_circuits", (ItemStack)IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.ADVANCED_CIRCUIT_BOARD), (Object[])new Object[]{"circuitAdvancedEtched", new IngredientStack("chipAdvanced", 2)});
            BlueprintCraftingRecipe.addRecipe((String)"advanced_circuits", (ItemStack)IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.CRYPTOGRAPHIC_CIRCUIT_BOARD), (Object[])new Object[]{"circuitAdvanced", new ItemStack((Item)IEContent.itemMaterial, 2, 9)});
            BlueprintCraftingRecipe.addRecipe((String)"processors", (ItemStack)IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.PROCESSOR_CIRCUIT_BOARD_RAW), (Object[])new Object[]{new IngredientStack("circuitAdvancedRaw", 2), new IngredientStack("plateAdvancedElectronicAlloy", 1)});
            BlueprintCraftingRecipe.addRecipe((String)"processors", (ItemStack)IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.PROCESSOR_CIRCUIT_BOARD), (Object[])new Object[]{"circuitProcessorEtched", new IngredientStack("chipProcessor", 2)});
        }
        BathingRecipe.addRecipe(IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.BASIC_CIRCUIT_BOARD_ETCHED), new IngredientStack("circuitBasicRaw"), FluidRegistry.getFluidStack((String)"etching_acid", (int)500), 15000, 360);
        BathingRecipe.addRecipe(IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.ADVANCED_CIRCUIT_BOARD_ETCHED), new IngredientStack("circuitAdvancedRaw"), FluidRegistry.getFluidStack((String)"etching_acid", (int)1000), 150000, 560);
        BathingRecipe.addRecipe(IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.PROCESSOR_CIRCUIT_BOARD_ETCHED), new IngredientStack("circuitProcessorRaw"), FluidRegistry.getFluidStack((String)"etching_acid", (int)2000), 1500000, 720);
        PrecissionAssemblerRecipe.addRecipe(new ItemStack((Item)IEContent.itemMaterial, 4, 26), new ItemStack((Item)IEContent.itemMetal, 1, 20), new IngredientStack[]{new IngredientStack("plateIron"), new IngredientStack("wireCopper", 2), new IngredientStack("blockGlass")}, new String[]{"inserter", "solderer", "drill"}, new String[]{"drill work main", "solderer work first", "inserter pick first", "inserter drop main", "solderer work main", "drill work second", "inserter pick second", "inserter drop main"}, 12000, 1.0f);
        PrecissionAssemblerRecipe.addRecipe(IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.BASIC_ELECTRONIC_ELEMENT), ItemStack.field_190927_a, new IngredientStack[]{new IngredientStack("electronTube"), new IngredientStack("plateNickel"), new IngredientStack("dustRedstone", 4)}, new String[]{"inserter", "solderer", "drill"}, new String[]{"inserter pick second", "drill work main", "inserter drop main", "solderer work main", "inserter pick first", "inserter drop main"}, 18000, 1.0f);
        PrecissionAssemblerRecipe.addRecipe(IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.ADVANCED_ELECTRON_TUBE), ItemStack.field_190927_a, new IngredientStack[]{new IngredientStack("plateSteel"), new IngredientStack("wireTungsten", 2), new IngredientStack("electronTube", 2)}, new String[]{"inserter", "solderer", "drill"}, new String[]{"drill work main", "inserter pick second", "inserter drop main", "inserter pick first", "inserter drop main", "solderer work main"}, 24000, 1.25f);
        PrecissionAssemblerRecipe.addRecipe(IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.ADVANCED_ELECTRONIC_ELEMENT), ItemStack.field_190927_a, new IngredientStack[]{new IngredientStack("electronTubeAdvanced"), new IngredientStack("chipBasic")}, new String[]{"inserter", "solderer", "drill"}, new String[]{"inserter pick second", "drill work main", "inserter drop main", "solderer work main", "inserter pick first", "inserter drop main"}, 32000, 1.25f);
        PrecissionAssemblerRecipe.addRecipe(IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.TRANSISTOR, 4), ItemStack.field_190927_a, new IngredientStack[]{new IngredientStack("plateSilicon", 2), new IngredientStack("plateAdvancedElectronicAlloy"), new IngredientStack("plateAluminum"), new IngredientStack("dyeBlack")}, new String[]{"inserter", "solderer", "drill"}, new String[]{"drill work main", "solderer work first", "inserter pick first", "drill work main", "inserter drop main", "inserter pick second", "solderer work main", "inserter drop main", "inserter pick third", "inserter drop third", "solderer work main"}, 50000, 0.9f);
        PrecissionAssemblerRecipe.addRecipe(IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.PROCESSOR_ELECTRONIC_ELEMENT), IIContent.itemMaterialNugget.getStack(ItemIIMaterialNugget.MaterialsNugget.SILICON), new IngredientStack[]{new IngredientStack("transistor", 32), new IngredientStack("electronTubeAdvanced", 2)}, new String[]{"inserter", "solderer", "buzzsaw"}, new String[]{"solderer work first", "inserter pick first", "buzzsaw work main", "solderer work main", "inserter drop main", "buzzsaw work main", "solderer work main"}, 500000, 1.5f);
    }

    public static void addSiliconProcessingRecipes() {
        PrecissionAssemblerRecipe.addRecipe(IIContent.itemMaterialPlate.getStack(ItemIIMaterialPlate.MaterialsPlate.SILICON), ItemStack.field_190927_a, new IngredientStack[]{new IngredientStack("bouleSilicon")}, new String[]{"buzzsaw"}, new String[]{"buzzsaw work main"}, 24000, 3.0f);
        PrecissionAssemblerRecipe.addRecipe(IIContent.itemMaterialIngot.getStack(ItemIIMaterialIngot.MaterialsIngot.SILICON), ItemStack.field_190927_a, new IngredientStack[]{new IngredientStack("bouleSilicon")}, new String[]{"hammer", "buzzsaw"}, new String[]{"hammer work main", "hammer work main", "buzzsaw work main", "hammer work main"}, 24000, 1.0f);
        CrusherRecipe.removeRecipesForInput((ItemStack)new ItemStack(Items.field_151128_bU));
        CrusherRecipe.addRecipe((ItemStack)IIContent.itemMaterialDust.getStack(ItemIIMaterialDust.MaterialsDust.QUARTZ_DIRTY), (Object)new IngredientStack("gemQuartz"), (int)3200);
        BathingRecipe.addRecipe(IIContent.itemMaterialDust.getStack(ItemIIMaterialDust.MaterialsDust.QUARTZ), new IngredientStack("dustQuartzDirty"), new FluidStack(IIContent.fluidHydrofluoricAcid, 1000), 4200, 240);
        ArcFurnaceRecipe.addRecipe((ItemStack)IIContent.itemMaterialBoule.getStack(ItemIIMaterialBoule.MaterialsBoule.SILICON), (Object)new IngredientStack("dustQuartz", 6), (ItemStack)ItemStack.field_190927_a, (int)400, (int)512, (Object[])new Object[0]);
    }

    public static void addInkRecipes() {
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidInkCyan, 1000), (FluidStack)new FluidStack(FluidRegistry.WATER, 500), (Object[])new Object[]{"dyeCyan"}, (int)3200);
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidInkYellow, 1000), (FluidStack)new FluidStack(FluidRegistry.WATER, 500), (Object[])new Object[]{"dyeYellow"}, (int)3200);
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidInkMagenta, 1000), (FluidStack)new FluidStack(FluidRegistry.WATER, 500), (Object[])new Object[]{"dyeMagenta"}, (int)3200);
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidInkBlack, 1000), (FluidStack)new FluidStack(FluidRegistry.WATER, 500), (Object[])new Object[]{"dyeBlack"}, (int)3200);
    }

    public static void addBulletPressRecipes() {
        IIRecipes.addMetalPressBullet(ItemIIAmmoCasing.Casings.ARTILLERY_8BCAL, new IngredientStack("plateBrass", 4), ItemIIMetalPressMold.PressMolds.HOWITZER, 2800);
        IIRecipes.addMetalPressBullet(ItemIIAmmoCasing.Casings.MORTAR_6BCAL, new IngredientStack("plateAluminum", 3), ItemIIMetalPressMold.PressMolds.MORTAR, 2500);
        IIRecipes.addMetalPressBullet(ItemIIAmmoCasing.Casings.LIGHT_ARTILLERY_6BCAL, new IngredientStack("plateBrass", 3), ItemIIMetalPressMold.PressMolds.LIGHT_HOWITZER, 2200);
        IIRecipes.addMetalPressBullet(ItemIIAmmoCasing.Casings.AUTOCANNON_3BCAL, new IngredientStack("ingotBrass", 2), ItemIIMetalPressMold.PressMolds.AUTOCANNON, 1600);
        IIRecipes.addMetalPressBullet(ItemIIAmmoCasing.Casings.MG_2BCAL, new IngredientStack("ingotBrass"), ItemIIMetalPressMold.PressMolds.MACHINEGUN, 1600);
        IIRecipes.addMetalPressBullet(ItemIIAmmoCasing.Casings.STG_1BCAL, new IngredientStack("ingotBrass"), ItemIIMetalPressMold.PressMolds.ASSAULT_RIFLE, 1400);
        IIRecipes.addMetalPressBullet(ItemIIAmmoCasing.Casings.SMG_1BCAL, new IngredientStack("ingotBrass"), ItemIIMetalPressMold.PressMolds.SUBMACHINEGUN, 1200);
        IIRecipes.addMetalPressBullet(ItemIIAmmoCasing.Casings.NAVAL_MINE, new IngredientStack("plateSteel", 4), ItemIIMetalPressMold.PressMolds.NAVAL_MINE, 4800);
        IIRecipes.addMetalPressBullet(ItemIIAmmoCasing.Casings.TRIPMINE, new IngredientStack("plateBrass", 2), ItemIIMetalPressMold.PressMolds.TRIPMINE, 3600);
        IIRecipes.addMetalPressBullet(ItemIIAmmoCasing.Casings.TELLERMINE, new IngredientStack("plateBrass", 2), ItemIIMetalPressMold.PressMolds.TELLERMINE, 3600);
        MetalPressRecipe.removeRecipes((ItemStack)new ItemStack((Item)IEContent.itemBullet, 2, 0));
        MetalPressRecipe.addRecipe((ItemStack)new ItemStack((Item)IEContent.itemBullet, 3, 0), (Object)"ingotBrass", (ItemStack)new ItemStack((Item)IEContent.itemMold, 1, 3), (int)2800);
        BlueprintCraftingRecipe.addRecipe((String)"bullet_magazines", (ItemStack)IIContent.itemBulletMagazine.getStack(ItemIIBulletMagazine.Magazines.MACHINEGUN), (Object[])new Object[]{new IngredientStack("plateSteel", 2), new IngredientStack("springSteel")});
        BlueprintCraftingRecipe.addRecipe((String)"bullet_magazines", (ItemStack)IIContent.itemBulletMagazine.getStack(ItemIIBulletMagazine.Magazines.SUBMACHINEGUN), (Object[])new Object[]{new IngredientStack("plateSteel", 2), new IngredientStack("springSteel")});
        BlueprintCraftingRecipe.addRecipe((String)"bullet_magazines", (ItemStack)IIContent.itemBulletMagazine.getStack(ItemIIBulletMagazine.Magazines.ASSAULT_RIFLE), (Object[])new Object[]{new IngredientStack("plateSteel", 2), new IngredientStack("springSteel")});
        BlueprintCraftingRecipe.addRecipe((String)"bullet_magazines", (ItemStack)IIContent.itemBulletMagazine.getStack(ItemIIBulletMagazine.Magazines.SUBMACHINEGUN_DRUM), (Object[])new Object[]{new IngredientStack("plateSteel", 5), new IngredientStack("springSteel")});
        BlueprintCraftingRecipe.addRecipe((String)"bullet_magazines", (ItemStack)IIContent.itemBulletMagazine.getStack(ItemIIBulletMagazine.Magazines.AUTOCANNON), (Object[])new Object[]{new IngredientStack("plateSteel", 3), new IngredientStack("springSteel", 2)});
        BlueprintCraftingRecipe.addRecipe((String)"bullet_magazines", (ItemStack)IIContent.itemBulletMagazine.getStack(ItemIIBulletMagazine.Magazines.CPDS_DRUM), (Object[])new Object[]{new IngredientStack("plateSteel", 8), new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 1, 8)), new IngredientStack("springSteel", 2), new IngredientStack("dyeGreen", 2)});
    }

    private static void addMetalPressBullet(ItemIIAmmoCasing.Casings casing, IngredientStack stack, ItemIIMetalPressMold.PressMolds mold, int energy) {
        MetalPressRecipe.addRecipe((ItemStack)IIContent.itemAmmoCasing.getStack(casing), (Object)stack, (ItemStack)IIContent.itemPressMold.getStack(mold), (int)energy);
    }

    public static void addFunctionalCircuits() {
        for (ItemIIFunctionalCircuit.Circuits value : ItemIIFunctionalCircuit.Circuits.values()) {
            BlueprintCraftingRecipe.addRecipe((String)(value.tier.func_176610_l() + "_functional_circuits"), (ItemStack)IIContent.itemCircuit.getStack(value), (Object[])new Object[]{new IngredientStack(value.tier.material), TOOL_CUTTERS});
        }
    }

    public static void addSpringRecipes() {
        BlueprintCraftingRecipe.addRecipe((String)"metal_springs", (ItemStack)IIContent.itemMaterialSpring.getStack(ItemIIMaterialSpring.MaterialsSpring.IRON, 2), (Object[])new Object[]{new IngredientStack("plateIron", 1), TOOL_HAMMER});
        BlueprintCraftingRecipe.addRecipe((String)"metal_springs", (ItemStack)IIContent.itemMaterialSpring.getStack(ItemIIMaterialSpring.MaterialsSpring.STEEL, 2), (Object[])new Object[]{new IngredientStack("plateSteel", 1), TOOL_HAMMER});
        BlueprintCraftingRecipe.addRecipe((String)"metal_springs", (ItemStack)IIContent.itemMaterialSpring.getStack(ItemIIMaterialSpring.MaterialsSpring.BRASS, 2), (Object[])new Object[]{new IngredientStack("plateBrass", 1), TOOL_HAMMER});
    }

    public static void addHandWeaponRecipes(IForgeRegistry<IRecipe> recipeRegistry) {
        if (IIConfigHandler.IIConfig.changeRevolverProduction) {
            // empty if block
        }
        PrecissionAssemblerRecipe.addRecipe(IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.TUNGSTEN_GUN_BARREL), ItemStack.field_190927_a, new IngredientStack[]{new IngredientStack("gunbarrelSteel"), new IngredientStack("dustTungsten")}, new String[]{"drill", "inserter", "welder"}, new String[]{"drill work main", "inserter pick first", "inserter drop main", "welder work main", "drill work main"}, 32000, 0.9f);
        PrecissionAssemblerRecipe.addRecipe(new ItemStack((Item)IIContent.itemRifle), ItemStack.field_190927_a, new IngredientStack[]{new IngredientStack("gunstockWood"), new IngredientStack("gunbarrelIron", 2), new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 1, 8)), new IngredientStack("gunpartBasic")}, new String[]{"welder", "inserter"}, new String[]{"welder work first", "inserter pick second", "inserter drop third", "inserter pick second", "inserter drop third", "welder work third", "inserter pick third", "inserter drop main"}, 32000, 1.2f);
    }

    public static void addMiscIERecipes() {
        BathingRecipe.addRecipe(new ItemStack((Block)IEContent.blockTreatedWood, 12), new IngredientStack("plankWood", 8), new FluidStack(IEContent.fluidCreosote, 1000), 3200, 120);
        MetalPressRecipe.addRecipe((ItemStack)new ItemStack((Item)IIContent.itemPrintedPage, 1, 0), (Object)new IngredientStack("paper"), (ItemStack)new ItemStack((Item)IEContent.itemMold, 1, 0), (int)600);
        ArcFurnaceRecipe.addRecipe((ItemStack)IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.WHITE_PHOSPHORUS, 4), (Object)new IngredientStack("dustPhosphorus", 4), (ItemStack)ItemStack.field_190927_a, (int)400, (int)512, (Object[])new Object[]{"dustCoke"});
    }

    public static void addWoodTableSawRecipes() {
        CraftingManager.field_193380_a.forEach(iRecipe -> {
            if (Utils.compareToOreName((ItemStack)iRecipe.func_77571_b(), (String)"plankWood")) {
                ItemStack out = iRecipe.func_77571_b().func_77946_l();
                out.func_190920_e(Math.round((float)out.func_190916_E() * 1.5f));
                ArrayList stacks = new ArrayList();
                for (Ingredient ingredient : iRecipe.func_192400_c()) {
                    Arrays.stream(ingredient.func_193365_a()).filter(stack -> Utils.compareToOreName((ItemStack)stack, (String)"logWood")).forEachOrdered(stacks::add);
                }
                if (!stacks.isEmpty()) {
                    SawmillRecipe.addRecipe(out, new IngredientStack(stacks).setUseNBT(false), IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.DUST_WOOD), IIConfigHandler.IIConfig.Machines.Sawmill.torqueMin + 2, 200, 1);
                }
            }
        });
        CrusherRecipe.addRecipe((ItemStack)IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.DUST_WOOD, 2), (Object)new IngredientStack("logWood"), (int)4096);
        CrusherRecipe.addRecipe((ItemStack)IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.DUST_WOOD), (Object)new IngredientStack("plankWood", 2), (int)3192);
        SawmillRecipe.addRecipe(new ItemStack(Items.field_151055_y, 3), new IngredientStack("plankWood"), IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.DUST_WOOD), IIConfigHandler.IIConfig.Machines.Sawmill.torqueMin, 100, 1);
        SawmillRecipe.addRecipe(new ItemStack((Item)IEContent.itemMaterial, 3, 0), new IngredientStack("plankTreatedWood"), IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.DUST_WOOD), IIConfigHandler.IIConfig.Machines.Sawmill.torqueMin, 100, 1);
        BottlingMachineRecipe.addRecipe((ItemStack)IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.PULP_WOOD), (Object)new IngredientStack("dustWood"), (FluidStack)new FluidStack(FluidRegistry.WATER, 250));
        BottlingMachineRecipe.addRecipe((ItemStack)IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.PULP_WOOD_TREATED), (Object)new IngredientStack("pulpWood"), (FluidStack)new FluidStack(IEContent.fluidCreosote, 1000));
        MetalPressRecipe.addRecipe((ItemStack)new ItemStack(Items.field_151121_aF, 2, 0), (Object)new IngredientStack("pulpWood"), (ItemStack)new ItemStack((Item)IEContent.itemMold, 1, 0), (int)100);
        MetalPressRecipe.addRecipe((ItemStack)IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.ARTIFICIAL_LEATHER), (Object)new IngredientStack("pulpWoodTreated"), (ItemStack)new ItemStack((Item)IEContent.itemMold, 1, 0), (int)600);
        CrusherRecipe.addRecipe((ItemStack)new ItemStack((Item)IIContent.itemMaterial, 1, 17), (Object)new IngredientStack(new ItemStack((Block)IIContent.blockCharredLog)), (int)2024).addToSecondaryOutput(new Object[]{IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.DUST_WOOD), Float.valueOf(1.0f)});
    }

    public static void addRotaryPowerRecipes() {
    }

    public static void addMinecartRecipes(IForgeRegistry<IRecipe> registry) {
        for (ItemIIMinecart.Minecarts value : ItemIIMinecart.Minecarts.values()) {
            registry.register(new RecipeMinecart(IIContent.itemMinecart.getStack(value), value.stack.get()).setRegistryName("immersiveintelligence", "minecart_" + value.func_176610_l()));
        }
    }

    public static void addSmallCrateRecipes(IForgeRegistry<IRecipe> registry) {
        registry.register(new RecipeCrateConversion(new ItemStack((Block)IEContent.blockWoodenDevice0, 1, 0), IIContent.blockSmallCrate.getStack(BlockIISmallCrate.IIBlockTypes_SmallCrate.WOODEN_CRATE_BOX), IIContent.blockSmallCrate.getStack(BlockIISmallCrate.IIBlockTypes_SmallCrate.WOODEN_CRATE_CUBE), IIContent.blockSmallCrate.getStack(BlockIISmallCrate.IIBlockTypes_SmallCrate.WOODEN_CRATE_WIDE)).setRegistryName("immersiveintelligence", "small_crate_wooden"));
        registry.register(new RecipeCrateConversion(IIContent.blockMetalDevice.getStack(BlockIIMetalDevice.IIBlockTypes_MetalDevice.METAL_CRATE), IIContent.blockSmallCrate.getStack(BlockIISmallCrate.IIBlockTypes_SmallCrate.METAL_CRATE_BOX), IIContent.blockSmallCrate.getStack(BlockIISmallCrate.IIBlockTypes_SmallCrate.METAL_CRATE_CUBE), IIContent.blockSmallCrate.getStack(BlockIISmallCrate.IIBlockTypes_SmallCrate.METAL_CRATE_WIDE)).setRegistryName("immersiveintelligence", "small_crate_metal"));
    }

    public static void addRDXProductionRecipes() {
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidMethanol, 500), (FluidStack)new FluidStack(IIContent.gasHydrogen, 1000), (Object[])new IngredientStack[]{new IngredientStack("dustNickel")}, (int)3200);
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidMethanol, 2000), (FluidStack)new FluidStack(IIContent.gasHydrogen, 3000), (Object[])new IngredientStack[]{new IngredientStack("dustPlatinum")}, (int)4800);
        FermenterRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidAmmonia, 120), (ItemStack)ItemStack.field_190927_a, (Object)new IngredientStack("listAllMeatRaw"), (int)1600);
        FermenterRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidAmmonia, 160), (ItemStack)ItemStack.field_190927_a, (Object)new ItemStack(Items.field_151078_bh), (int)1000);
        BottlingMachineRecipe.addRecipe((ItemStack)IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.DUST_FORMALDEHYDE, 2), (Object)new IngredientStack("nuggetSilver"), (FluidStack)new FluidStack(IIContent.fluidMethanol, 1000));
        BottlingMachineRecipe.addRecipe((ItemStack)IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.DUST_HEXAMINE), (Object)new IngredientStack("dustFormaldehyde"), (FluidStack)new FluidStack(IIContent.fluidAmmonia, 320));
    }

    public static void addHMXProductionRecipes() {
        BottlingMachineRecipe.addRecipe((ItemStack)IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.DUST_HMX), (Object)new IngredientStack("materialHexogen"), (FluidStack)new FluidStack(IIContent.fluidNitricAcid, 500));
    }

    public static void addConcreteRecipes() {
        BathingRecipe.addRecipe(IIContent.blockConcreteDecoration.getStack(BlockIIConcreteDecoration.ConcreteDecorations.CONCRETE_BRICKS), new IngredientStack(new ItemStack(Blocks.field_150336_V)), new FluidStack(FluidRegistry.getFluid((String)"concrete"), 500), 1600, 120);
        ArcFurnaceRecipe.addRecipe((ItemStack)IIContent.blockConcreteDecoration.getStack(BlockIIConcreteDecoration.ConcreteDecorations.STURDY_CONCRETE_BRICKS), (Object)IIContent.blockConcreteDecoration.getStack(BlockIIConcreteDecoration.ConcreteDecorations.CONCRETE_BRICKS), (ItemStack)ItemStack.field_190927_a, (int)200, (int)2400, (Object[])new Object[]{new IngredientStack("stickSteel", 2)});
        ArcFurnaceRecipe.addRecipe((ItemStack)IIContent.blockConcreteDecoration.getStack(BlockIIConcreteDecoration.ConcreteDecorations.UBERCONCRETE, 2), (Object)IIContent.blockConcreteDecoration.getStack(BlockIIConcreteDecoration.ConcreteDecorations.STURDY_CONCRETE_BRICKS), (ItemStack)ItemStack.field_190927_a, (int)200, (int)3600, (Object[])new Object[]{new ItemStack((Block)IEContent.blockStoneDecoration, 1, BlockTypes_StoneDecoration.CONCRETE_LEADED.getMeta())});
    }

    public static void addFillerRecipes() {
        FillerRecipe.addRecipe(IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.SANDBAG), new IngredientStack("fabricHemp"), new DustStack("sand", 50), 100, 2000);
        FillerRecipe.addRecipe(IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.SANDBAG), new IngredientStack("fabricHemp"), new DustStack("gravel", 40), 80, 2500);
    }

    public static void addChemicalBathCleaningRecipes() {
        IIRecipes.addBathingCleaningRecipe(new ItemStack(Blocks.field_150325_L, 1), new IngredientStack("wool"), 1000, 1024, 200, true, false, false);
        IIRecipes.addBathingCleaningRecipe(new ItemStack(Blocks.field_150359_w, 1), new IngredientStack("blockGlass"), 1000, 1024, 200, true);
        IIRecipes.addBathingCleaningRecipe(new ItemStack(Blocks.field_150410_aZ, 1), new IngredientStack("paneGlass"), 1000, 1024, 200, true);
        IIRecipes.addBathingCleaningRecipe(new ItemStack(Blocks.field_150324_C, 1), new IngredientStack(new ItemStack(Blocks.field_150324_C, 1, Short.MAX_VALUE)), 2000, 3096, 240, true, false, false);
        IIRecipes.addBathingCleaningRecipe(new ItemStack(Blocks.field_150404_cg, 1), new IngredientStack(new ItemStack(Blocks.field_150404_cg, 1, Short.MAX_VALUE)), 2000, 3096, 240, true, false, false);
        IIRecipes.addBathingCleaningRecipe(new ItemStack(Blocks.field_150405_ch, 1), new IngredientStack(new ItemStack(Blocks.field_150406_ce, 1, Short.MAX_VALUE)), 2000, 1440, 280, false, true, true);
        Block[] shulker_boxes = new Block[]{Blocks.field_190978_dm, Blocks.field_190979_dn, Blocks.field_190980_do, Blocks.field_190981_dp, Blocks.field_190982_dq, Blocks.field_190983_dr, Blocks.field_190984_ds, Blocks.field_190985_dt, Blocks.field_190986_du, Blocks.field_190988_dw, Blocks.field_190989_dx, Blocks.field_190990_dy, Blocks.field_190991_dz};
        IIRecipes.addBathingCleaningRecipe(new ItemStack(Blocks.field_190987_dv, 1), new IngredientStack(Arrays.stream(shulker_boxes).map(ItemStack::new).collect(Collectors.toList())), 2000, 4096, 120, false, true, true);
        IIRecipes.addBathingCleaningRecipe(new ItemStack(Items.field_179564_cE, 1, Short.MAX_VALUE), new IngredientStack(new ItemStack(Items.field_179564_cE, 1, 15)), 2000, 1024, 160, true, false, false);
    }

    public static void addChemicalPainterRecipes() {
        PaintingRecipe.addRecipe((rgb, stack) -> {
            EnumDyeColor dye = IIUtils.getRGBTextFormatting(rgb);
            return new ItemStack(Blocks.field_150325_L, 1, dye.func_176765_a());
        }, new IngredientStack(new ItemStack(Blocks.field_150325_L)), 512, 240, 125);
        PaintingRecipe.addRecipe((rgb, stack) -> {
            EnumDyeColor dye = IIUtils.getRGBTextFormatting(rgb);
            return new ItemStack(Blocks.field_150404_cg, 1, dye.func_176765_a());
        }, new IngredientStack(new ItemStack(Blocks.field_150404_cg)), 512, 240, 50);
        PaintingRecipe.addRecipe((rgb, stack) -> {
            EnumDyeColor dye = IIUtils.getRGBTextFormatting(rgb);
            return new ItemStack((Block)Blocks.field_150399_cn, 1, dye.func_176765_a());
        }, new IngredientStack(new ItemStack(Blocks.field_150359_w)), 512, 240, 125);
        PaintingRecipe.addRecipe((rgb, stack) -> {
            EnumDyeColor dye = IIUtils.getRGBTextFormatting(rgb);
            return new ItemStack((Block)Blocks.field_150397_co, 1, dye.func_176765_a());
        }, new IngredientStack(new ItemStack(Blocks.field_150410_aZ)), 512, 240, 125);
        PaintingRecipe.addRecipe((rgb, stack) -> {
            EnumDyeColor dye = IIUtils.getRGBTextFormatting(rgb);
            return new ItemStack(Blocks.field_150406_ce, 1, dye.func_176765_a());
        }, new IngredientStack(new ItemStack(Blocks.field_150405_ch)), 512, 240, 125);
        PaintingRecipe.addRecipe((rgb, stack) -> {
            EnumDyeColor dye = IIUtils.getRGBTextFormatting(rgb);
            return new ItemStack(Items.field_151104_aV, 1, dye.func_176765_a());
        }, new IngredientStack(new ItemStack(Items.field_151104_aV)), 512, 240, 200);
        PaintingRecipe.addRecipe((rgb, stack) -> {
            IIContent.itemAdvancedPowerPack.func_82813_b((ItemStack)stack, (int)rgb);
            return stack;
        }, new IngredientStack(new ItemStack((Item)IIContent.itemAdvancedPowerPack)), 8192, 340, 2000);
        PaintingRecipe.addRecipe((rgb, stack) -> {
            Items.field_151024_Q.func_82813_b(stack, rgb.intValue());
            return stack;
        }, new IngredientStack((List)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((Item)Items.field_151024_Q), new ItemStack((Item)Items.field_151027_R), new ItemStack((Item)Items.field_151026_S), new ItemStack((Item)Items.field_151021_T)})), 8192, 340, 2000);
        PaintingRecipe.addRecipe((rgb, stack) -> stack, new IngredientStack((List)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((Item)IIContent.itemLightEngineerHelmet), new ItemStack((Item)IIContent.itemLightEngineerChestplate), new ItemStack((Item)IIContent.itemLightEngineerLeggings), new ItemStack((Item)IIContent.itemLightEngineerBoots)})), 8192, 340, 2000);
        for (IAmmo bullet : AmmoRegistry.INSTANCE.registeredBulletItems.values()) {
            ItemStack bulletStack = bullet.getBulletWithParams("", "", "");
            bulletStack.func_77982_d(new NBTTagCompound());
            PaintingRecipe.addRecipe((rgb, stack) -> {
                ItemStack ret = bullet.setPaintColour((ItemStack)stack, (int)rgb);
                ret.func_190920_e(1);
                return ret;
            }, new IngredientStack(bulletStack).setUseNBT(false), (int)(bullet.getCaliber() * 1024.0f), 100 + (int)(bullet.getCaliber() * 40.0f), 50 + (int)(bullet.getCaliber() * 25.0f));
        }
    }

    private static void addBathingCleaningRecipe(ItemStack out, IngredientStack in, int amount, int energy, int time, boolean allowHFl) {
        IIRecipes.addBathingCleaningRecipe(out, in, amount, energy, time, true, true, allowHFl);
    }

    private static void addBathingCleaningRecipe(ItemStack out, IngredientStack in, int amount, int energy, int time, boolean allowWater, boolean allowSulfuric, boolean allowHFl) {
        if (allowWater) {
            BathingRecipe.addWashingRecipe(out, in, new FluidStack(FluidRegistry.WATER, amount), energy, time);
        }
        if (allowSulfuric) {
            BathingRecipe.addWashingRecipe(out, in, new FluidStack(IIContent.fluidSulfuricAcid, allowWater ? amount / 2 : amount), allowWater ? energy / 2 : energy, allowWater ? time / 2 : time);
        }
        if (allowHFl) {
            BathingRecipe.addWashingRecipe(out, in, new FluidStack(IIContent.fluidHydrofluoricAcid, amount / 2), allowWater ? energy / 4 : energy / 2, allowWater ? time / 4 : time / 2);
        }
    }

    public static void addUpgradeRecipes() {
        IIContent.UPGRADE_INSERTER.addStack(new IngredientStack(IIContent.itemPrecissionTool.getStack(ItemIIPrecisionTool.PrecisionTools.INSERTER))).addStack(new IngredientStack("scaffoldingSteel")).setRequiredProgress(20000).setRequiredSteps(12);
        IIContent.UPGRADE_MG_LOADER.addStack(new IngredientStack("plateSteel", 8)).setRequiredProgress(20000).setRequiredSteps(10);
        IIContent.UPGRADE_SAW_UNREGULATOR.addStack(new IngredientStack(IIContent.itemMotorGear.getStack(ItemIIMotorGear.MotorGear.STEEL))).addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 1, 8))).addStack(new IngredientStack("stickSteel", 2)).setRequiredProgress(32000);
        IIContent.UPGRADE_IMPROVED_GEARBOX.addStack(new IngredientStack(IIContent.itemMotorGear.getStack(ItemIIMotorGear.MotorGear.TUNGSTEN, 2))).addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 1, 9))).addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 2, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta()))).setRequiredProgress(32000);
        IIContent.UPGRADE_PACKER_FLUID.addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice0, 1, BlockTypes_MetalDevice0.FLUID_PUMP.getMeta()))).addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice0, 2, BlockTypes_MetalDevice0.BARREL.getMeta()))).setRequiredProgress(20000);
        IIContent.UPGRADE_PACKER_ENERGY.addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice1, 1, BlockTypes_MetalDevice1.TESLA_COIL.getMeta()))).addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice0, 2, BlockTypes_MetalDevice0.CAPACITOR_MV.getMeta()))).setRequiredProgress(20000);
        IIContent.UPGRADE_PACKER_RAILWAY.addStack(new IngredientStack("gravel", 3)).addStack(new IngredientStack("rail", 3)).setRequiredProgress(40000);
        IIContent.UPGRADE_PACKER_NAMING.addStack(new IngredientStack("circuitBasic", 2)).setRequiredProgress(20000);
        IIContent.UPGRADE_RADIO_LOCATORS.addStack(new IngredientStack("plateSteel", 4)).addStack(new IngredientStack(new ItemStack((Item)IIContent.itemRadioTuner, 2, 1))).addStack(new IngredientStack(new ItemStack((Item)IIContent.itemDataWireCoil, 10, 0))).setRequiredProgress(250000).setRequiredSteps(1);
        IIContent.UPGRADE_REDSTONE_ACTIVATION.addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 4, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta()))).addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 2, BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta()))).setRequiredProgress(20000);
        IIContent.UPGRADE_RAZOR_WIRE.addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration2, 6, BlockTypes_MetalDecoration2.RAZOR_WIRE.getMeta()))).setRequiredProgress(20000);
        IIContent.UPGRADE_EMPLACEMENT_WEAPON_MACHINEGUN.addStack(new IngredientStack(new ItemStack((Block)IIContent.blockSandbags, 4))).addStack(new IngredientStack(new ItemStack((Item)IIContent.itemMachinegun, 2))).addStack(new IngredientStack(new ItemStack((Block)IIContent.blockMetalDevice, 2, BlockIIMetalDevice.IIBlockTypes_MetalDevice.AMMUNITION_CRATE.getMeta()))).addStack(new IngredientStack("circuitBasic", 4)).setRequiredProgress(40000);
        IIContent.UPGRADE_EMPLACEMENT_WEAPON_IROBSERVER.addStack(new IngredientStack("blockGlassRed", 1)).addStack(new IngredientStack("blockGlass", 1)).addStack(new IngredientStack("blockSteel", 2)).addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 2, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta()))).addStack(new IngredientStack("circuitBasic", 6)).setRequiredProgress(40000);
        IIContent.UPGRADE_EMPLACEMENT_WEAPON_AUTOCANNON.addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 4, 14))).addStack(new IngredientStack("blockSteel", 2)).addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 3, 9))).addStack(new IngredientStack(new ItemStack((Block)IIContent.blockMetalDevice, 1, BlockIIMetalDevice.IIBlockTypes_MetalDevice.AMMUNITION_CRATE.getMeta()))).addStack(new IngredientStack("circuitAdvanced", 6)).setRequiredProgress(80000);
        IIContent.UPGRADE_EMPLACEMENT_WEAPON_HEAVY_CHEMTHROWER.addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice0, 2, BlockTypes_MetalDevice0.FLUID_PLACER.getMeta()))).addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice1, 4, BlockTypes_MetalDevice1.FLUID_PIPE.getMeta()))).addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 2, 14))).addStack(new IngredientStack("blockSteel", 1)).addStack(new IngredientStack("circuitAdvanced", 6)).setRequiredProgress(80000);
        IIContent.UPGRADE_EMPLACEMENT_WEAPON_HEAVY_RAILGUN.addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice0, 2, BlockTypes_MetalDevice0.CAPACITOR_HV.getMeta()))).addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.COIL_HV.getMeta()))).addStack(new IngredientStack("blockSteel", 1)).addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 2, 9))).addStack(new IngredientStack(new ItemStack((Block)IIContent.blockMetalDevice, 1, BlockIIMetalDevice.IIBlockTypes_MetalDevice.AMMUNITION_CRATE.getMeta()))).addStack(new IngredientStack("circuitAdvanced", 6)).setRequiredProgress(80000);
        IIContent.UPGRADE_EMPLACEMENT_WEAPON_TESLA.addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice0, 8, BlockTypes_MetalDevice0.CAPACITOR_HV.getMeta()))).addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 8, BlockTypes_MetalDecoration0.COIL_HV.getMeta()))).addStack(new IngredientStack("circuitAdvanced", 6)).setRequiredProgress(120000);
        IIContent.UPGRADE_EMPLACEMENT_WEAPON_CPDS.addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 8, 14))).addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 2, 9))).addStack(new IngredientStack("blockSteel", 3)).addStack(new IngredientStack("circuitProcessor", 6)).setRequiredProgress(300000);
    }

    public static void addSmeltingRecipes() {
        FurnaceRecipes.func_77602_a().func_151394_a(IIContent.blockOre.getStack(BlockIIOre.Ores.ZINC), IIContent.itemMaterialIngot.getStack(ItemIIMaterialIngot.MaterialsIngot.ZINC), 0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(IIContent.itemMaterialDust.getStack(ItemIIMaterialDust.MaterialsDust.ZINC), IIContent.itemMaterialIngot.getStack(ItemIIMaterialIngot.MaterialsIngot.ZINC), 0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(IIContent.itemMaterialDust.getStack(ItemIIMaterialDust.MaterialsDust.BRASS), IIContent.itemMaterialIngot.getStack(ItemIIMaterialIngot.MaterialsIngot.BRASS), 0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(IIContent.blockOre.getStack(BlockIIOre.Ores.PLATINUM), IIContent.itemMaterialIngot.getStack(ItemIIMaterialIngot.MaterialsIngot.PLATINUM), 0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(IIContent.itemMaterialDust.getStack(ItemIIMaterialDust.MaterialsDust.PLATINUM), IIContent.itemMaterialIngot.getStack(ItemIIMaterialIngot.MaterialsIngot.PLATINUM), 0.5f);
        if (IIConfigHandler.IIConfig.smeltableTungsten) {
            FurnaceRecipes.func_77602_a().func_151394_a(IIContent.blockOre.getStack(BlockIIOre.Ores.TUNGSTEN), IIContent.itemMaterialIngot.getStack(ItemIIMaterialIngot.MaterialsIngot.TUNGSTEN), 0.5f);
            FurnaceRecipes.func_77602_a().func_151394_a(IIContent.itemMaterialDust.getStack(ItemIIMaterialDust.MaterialsDust.TUNGSTEN), IIContent.itemMaterialIngot.getStack(ItemIIMaterialIngot.MaterialsIngot.TUNGSTEN), 0.5f);
        }
        if (IIConfigHandler.IIConfig.smeltableAEA) {
            FurnaceRecipes.func_77602_a().func_151394_a(IIContent.itemMaterialDust.getStack(ItemIIMaterialDust.MaterialsDust.ADVANCED_ELECTRONIC_ALLOY), IIContent.itemMaterialIngot.getStack(ItemIIMaterialIngot.MaterialsIngot.ADVANCED_ELECTRONIC_ALLOY), 0.5f);
        }
    }

    public static void addArcFurnaceRecyclingRecipes() {
        ArcFurnaceRecipe.allowItemForRecycling((Object)new ItemStack((Item)IIContent.itemDrillhead, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling((Object)new ItemStack((Item)IIContent.itemSawblade, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling((Object)new ItemStack((Block)IIContent.blockMetalDecoration, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling((Object)new ItemStack((Block)IIContent.blockMetalDevice, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling((Object)new ItemStack((Block)IIContent.blockMetalFortification, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling((Object)new ItemStack((Block)IIContent.blockMetalFortification1, 1, Short.MAX_VALUE));
    }

    public static void addAmmunitionCasingRecipes() {
        FillerRecipe.recipeList.clear();
        FillerRecipe.addRecipe(IIContent.itemAmmoArtillery, 160, 8000);
        FillerRecipe.addRecipe(IIContent.itemAmmoLightArtillery, 140, 6000);
        FillerRecipe.addRecipe(IIContent.itemAmmoMortar, 140, 6000);
        FillerRecipe.addRecipe(IIContent.itemAmmoAutocannon, 80, 1000);
        FillerRecipe.addRecipe(IIContent.itemAmmoMachinegun, 60, 800);
        FillerRecipe.addRecipe(IIContent.itemAmmoAssaultRifle, 55, 700);
        FillerRecipe.addRecipe(IIContent.itemAmmoSubmachinegun, 50, 600);
        FillerRecipe.addRecipe(IIContent.itemAmmoRevolver, 40, 400);
        for (ItemIIAmmoBase itemIIAmmoBase : new ItemIIAmmoBase[]{IIContent.itemAmmoArtillery, IIContent.itemAmmoLightArtillery, IIContent.itemAmmoMortar, IIContent.itemAmmoAutocannon, IIContent.itemAmmoMachinegun, IIContent.itemAmmoAssaultRifle, IIContent.itemAmmoSubmachinegun}) {
            assert (itemIIAmmoBase != null);
            ItemStack casingStack = itemIIAmmoBase.getCasingStack(1);
            ItemNBTHelper.setBoolean((ItemStack)casingStack, (String)"ii_FilledCasing", (boolean)true);
            AmmunitionWorkshopRecipe.addRecipe((core, casing) -> {
                ItemStack stack = item.getStack(ItemIIAmmoBase.AmmoParts.BULLET);
                stack.deserializeNBT(core.serializeNBT());
                return stack;
            }, new IngredientStack(itemIIAmmoBase.getBulletCore("coreBrass", itemIIAmmoBase.getAllowedCoreTypes()[0].func_176610_l())), new IngredientStack(casingStack).setUseNBT(true), (int)(128.0f * itemIIAmmoBase.getCaliber()), (int)(140.0f + 25.0f * Math.max(0.0f, itemIIAmmoBase.getCaliber() - 1.0f)));
        }
        for (ItemIIAmmoBase itemIIAmmoBase : new Item[]{IIContent.blockTripmine.itemBlock, IIContent.blockTellermine.itemBlock, IIContent.blockRadioExplosives.itemBlock, IIContent.itemNavalMine}) {
            assert (itemIIAmmoBase != null);
            IAmmo bullet = itemIIAmmoBase;
            AmmunitionWorkshopRecipe.addRecipe((core, casing) -> {
                ItemStack stack = new ItemStack(item, 1, BlockIIMine.IIBlockTypes_Mine.MAIN.getMeta());
                stack.deserializeNBT(core.serializeNBT());
                return stack;
            }, new IngredientStack(bullet.getBulletCore("coreBrass", bullet.getAllowedCoreTypes()[0].func_176610_l())), new IngredientStack(bullet.getCasingStack(1)).setUseNBT(true), (int)(256.0f * bullet.getCaliber()), 480);
        }
        AmmunitionWorkshopRecipe.addRecipe((core, casing) -> {
            ItemStack stack = IIContent.itemGrenade.getStack(ItemIIAmmoBase.AmmoParts.BULLET);
            stack.deserializeNBT(core.serializeNBT());
            return stack;
        }, new IngredientStack(IIContent.itemGrenade.getBulletCore("coreBrass", IIContent.itemGrenade.getAllowedCoreTypes()[0].func_176610_l())), new IngredientStack("stickTreatedWood"), 600, 480);
        AmmunitionWorkshopRecipe.addRecipe((core, casing) -> {
            ItemStack stack = IIContent.itemRailgunGrenade.getStack(ItemIIAmmoBase.AmmoParts.BULLET);
            stack.deserializeNBT(core.serializeNBT());
            return stack;
        }, new IngredientStack(IIContent.itemGrenade.getBulletCore("coreBrass", IIContent.itemGrenade.getAllowedCoreTypes()[0].func_176610_l())), new IngredientStack("stickSteel"), 1200, 540);
    }

    public static void addRubberRecipes() {
        for (ItemIIVulcanizerMold.VulcanizerMolds mold : ItemIIVulcanizerMold.VulcanizerMolds.values()) {
            BlueprintCraftingRecipe.addRecipe((String)"vulcanizer_molds", (ItemStack)IIContent.itemVulcanizerMold.getStack(mold), (Object[])new Object[]{new IngredientStack("plateSteel", 8), TOOL_CUTTERS});
        }
        MetalPressRecipe.addRecipe((ItemStack)IIContent.itemMaterialPlate.getStack(ItemIIMaterialPlate.MaterialsPlate.RUBBER_RAW), (Object)new IngredientStack("rubberRaw"), (ComparableItemStack)ApiUtils.createComparableItemStack((ItemStack)new ItemStack((Item)IEContent.itemMold, 1, 0), (boolean)false), (int)2400);
        VulcanizerRecipe.addRecipe(IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.RUBBER_BELT, 4), IIContent.itemVulcanizerMold.getComparableStack(ItemIIVulcanizerMold.VulcanizerMolds.BELT), new IngredientStack("plateRubberRaw", 10), new IngredientStack("dustVulcanizationCompound", 3), new IngredientStack("dustSulfur", 2), 24000);
        VulcanizerRecipe.addRecipe(IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.RUBBER_TIRE, 3), IIContent.itemVulcanizerMold.getComparableStack(ItemIIVulcanizerMold.VulcanizerMolds.TIRE), new IngredientStack("plateRubberRaw", 10), new IngredientStack("dustVulcanizationCompound", 8), new IngredientStack("dustSulfur", 3), 32000);
        CoagulatorRecipe.addRecipe(IIContent.itemMaterial.getStack(ItemIIMaterial.Materials.NATURAL_RUBBER, 8), new FluidStack(IIContent.fluidLatex, 5500), new FluidStack(IIContent.fluidFormicAcid, 500), 24000, 400, 2400);
    }

    public static void addMetalPressRecipes() {
        for (ItemIIMetalPressMold.PressMolds value : ItemIIMetalPressMold.PressMolds.values()) {
            BlueprintCraftingRecipe.addRecipe((String)"ammo_molds", (ItemStack)IIContent.itemPressMold.getStack(value), (Object[])new Object[]{new IngredientStack("plateSteel", 5), TOOL_CUTTERS});
        }
    }

    public static void addDuraluminiumRecipes() {
        ArcFurnaceRecipe.addRecipe((ItemStack)IIContent.itemMaterialIngot.getStack(ItemIIMaterialIngot.MaterialsIngot.DURALUMINIUM, 6), (Object)new IngredientStack("ingotAluminum", 6), (ItemStack)new ItemStack(Items.field_191525_da), (int)600, (int)640, (Object[])new Object[]{"ingotCopper", "ingotZinc", "ingotIron", "ingotSilicon"});
        ArcFurnaceRecipe.addRecipe((ItemStack)IIContent.itemMaterialIngot.getStack(ItemIIMaterialIngot.MaterialsIngot.DURALUMINIUM, 6), (Object)new IngredientStack("dustAluminum", 6), (ItemStack)new ItemStack(Items.field_191525_da), (int)600, (int)640, (Object[])new Object[]{"dustCopper", "dustZinc", "dustIron", "dustSilicon"});
    }

    public static void addPackerHandling() {
        ItemStack[] crates = new ItemStack[]{new ItemStack((Block)IEContent.blockWoodenDevice0, 1, BlockTypes_WoodenDevice0.CRATE.getMeta()), new ItemStack((Block)IEContent.blockWoodenDevice0, 1, BlockTypes_WoodenDevice0.REINFORCED_CRATE.getMeta()), new ItemStack((Block)IIContent.blockMetalDevice, 1, BlockIIMetalDevice.IIBlockTypes_MetalDevice.METAL_CRATE.getMeta()), new ItemStack((Block)IIContent.blockSmallCrate, 1, 0), new ItemStack((Block)IIContent.blockSmallCrate, 1, 1), new ItemStack((Block)IIContent.blockSmallCrate, 1, 2), new ItemStack((Block)IIContent.blockSmallCrate, 1, 3), new ItemStack((Block)IIContent.blockSmallCrate, 1, 4), new ItemStack((Block)IIContent.blockSmallCrate, 1, 5)};
        PackerHandler.registerItem(stack -> Arrays.stream(crates).anyMatch(s -> s.func_77969_a(stack)), stack -> new ItemStackHandler(Utils.readInventory((NBTTagList)ItemNBTHelper.getTag((ItemStack)stack).func_150295_c("inventory", 10), (int)27), (ItemStack)stack){
            final ItemStack ss;
            final /* synthetic */ ItemStack val$stack;
            {
                this.val$stack = itemStack;
                super(x0);
                this.ss = this.val$stack;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return IEApi.isAllowedInCrate((ItemStack)stack);
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ItemNBTHelper.getTag((ItemStack)this.ss).func_74782_a("inventory", (NBTBase)Utils.writeInventory((Collection)this.stacks));
            }
        });
        ItemStack[] shulkerBoxes = new ItemStack[]{new ItemStack(Blocks.field_190977_dl), new ItemStack(Blocks.field_190978_dm), new ItemStack(Blocks.field_190979_dn), new ItemStack(Blocks.field_190980_do), new ItemStack(Blocks.field_190981_dp), new ItemStack(Blocks.field_190982_dq), new ItemStack(Blocks.field_190983_dr), new ItemStack(Blocks.field_190984_ds), new ItemStack(Blocks.field_190985_dt), new ItemStack(Blocks.field_190986_du), new ItemStack(Blocks.field_190987_dv), new ItemStack(Blocks.field_190988_dw), new ItemStack(Blocks.field_190989_dx), new ItemStack(Blocks.field_190990_dy), new ItemStack(Blocks.field_190991_dz)};
        PackerHandler.registerItem(stack -> Arrays.stream(shulkerBoxes).anyMatch(s -> s.func_77969_a(stack)), stack -> new ItemStackHandler(Utils.readInventory((NBTTagList)ItemNBTHelper.getTag((ItemStack)stack).func_74775_l("BlockEntityTag").func_150295_c("Items", 10), (int)27), (ItemStack)stack){
            final ItemStack ss;
            final /* synthetic */ ItemStack val$stack;
            {
                this.val$stack = itemStack;
                super(x0);
                this.ss = this.val$stack;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return !(Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockShulkerBox);
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                NBTTagCompound tag = ItemNBTHelper.getTagCompound((ItemStack)this.val$stack, (String)"BlockEntityTag");
                tag.func_74782_a("Items", (NBTBase)Utils.writeInventory((Collection)this.stacks));
                ItemNBTHelper.setTagCompound((ItemStack)this.ss, (String)"BlockEntityTag", (NBTTagCompound)tag);
            }
        });
        PackerHandler.registerItem(stack -> stack.func_77973_b() == IIContent.itemBulletMagazine, stack -> new ItemStackHandler((NonNullList)IIContent.itemBulletMagazine.readInventory((ItemStack)stack), (ItemStack)stack){
            final ItemStack ss;
            final /* synthetic */ ItemStack val$stack;
            {
                this.val$stack = itemStack;
                super(x0);
                this.ss = this.val$stack;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                Item item = stack.func_77973_b();
                return item == ((ItemIIBulletMagazine.Magazines)IIContent.itemBulletMagazine.stackToSub((ItemStack)this.ss)).ammo && !((IAmmo)item).isBulletCore(stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                IIContent.itemBulletMagazine.writeInventory(this.ss, (NonNullList<ItemStack>)this.stacks);
            }
        });
        PackerHandler.registerItem(stack -> stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), stack -> (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        ItemStack[] barrels = new ItemStack[]{new ItemStack((Block)IEContent.blockWoodenDevice0, 1, BlockTypes_WoodenDevice0.BARREL.getMeta()), new ItemStack((Block)IEContent.blockMetalDevice0, 1, BlockTypes_MetalDevice0.BARREL.getMeta())};
        PackerHandler.registerFluid(stack -> Arrays.stream(barrels).anyMatch(s -> s.func_77969_a(stack)), stack -> new FluidHandlerItemStack((ItemStack)stack, 12000){

            @Nullable
            public FluidStack getFluid() {
                NBTTagCompound tagCompound = this.container.func_77978_p();
                if (tagCompound == null || !tagCompound.func_74764_b("tank")) {
                    return null;
                }
                return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("tank"));
            }

            protected void setFluid(FluidStack fluid) {
                if (!this.container.func_77942_o()) {
                    this.container.func_77982_d(new NBTTagCompound());
                }
                NBTTagCompound fluidTag = new NBTTagCompound();
                fluid.writeToNBT(fluidTag);
                this.container.func_77978_p().func_74782_a("tank", (NBTBase)fluidTag);
            }

            protected void setContainerToEmpty() {
                this.container.func_77978_p().func_82580_o("tank");
            }
        });
        PackerHandler.registerFluid(stack -> stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null), stack -> (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null));
    }

    public static void addForeignOreDict() {
        OreDictionary.registerOre((String)"circuitBasic", (ItemStack)new ItemStack((Item)IEContent.itemMaterial, 1, 27));
        OreDictionary.registerOre((String)"gungripWood", (ItemStack)new ItemStack((Item)IEContent.itemMaterial, 1, 13));
        OreDictionary.registerOre((String)"gunbarrelSteel", (ItemStack)new ItemStack((Item)IEContent.itemMaterial, 1, 14));
        OreDictionary.registerOre((String)"gunpartRevolver", (ItemStack)new ItemStack((Item)IEContent.itemMaterial, 1, 15));
        OreDictionary.registerOre((String)"gunpartHammer", (ItemStack)new ItemStack((Item)IEContent.itemMaterial, 1, 16));
        OreDictionary.registerOre((String)"listAllMeatRaw", (Item)Items.field_151147_al);
        OreDictionary.registerOre((String)"listAllMeatRaw", (Item)Items.field_151082_bd);
        OreDictionary.registerOre((String)"listAllMeatRaw", (Item)Items.field_151115_aP);
        OreDictionary.registerOre((String)"listAllMeatRaw", (Item)Items.field_151076_bf);
        OreDictionary.registerOre((String)"listAllMeatRaw", (Item)Items.field_179558_bo);
        OreDictionary.registerOre((String)"listAllMeatRaw", (Item)Items.field_179561_bm);
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack((Block)IIContent.blockRubberLog));
        OreDictionary.registerOre((String)"woodRubber", (ItemStack)new ItemStack((Block)IIContent.blockRubberLog));
        OreDictionary.registerOre((String)"blockLeaves", (ItemStack)new ItemStack((Block)IIContent.blockRubberLeaves));
        OreDictionary.registerOre((String)"tnt", (ItemStack)new ItemStack(Blocks.field_150335_W));
        OreDictionary.registerOre((String)"materialTNT", (ItemStack)new ItemStack(Blocks.field_150335_W));
        OreDictionary.registerOre((String)"leadedConcrete", (ItemStack)new ItemStack((Block)IEContent.blockStoneDecoration, 1, BlockTypes_StoneDecoration.CONCRETE_LEADED.getMeta()));
    }
}

