/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.crafting;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.pabilo8.immersiveintelligence.api.utils.tools.ISkinnable;
import pl.pabilo8.immersiveintelligence.common.util.IISkinHandler;

public class RecipeSkinCraftingHandler
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return new SkinResult(inv).canCraft;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return new SkinResult(inv).output;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return new SkinResult(inv).remaining;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 || height >= 2;
    }

    private static class SkinResult {
        private final boolean canCraft;
        private final NonNullList<ItemStack> remaining;
        private final ItemStack output;
        private ISkinnable skinnable;
        private ItemStack item;
        private ItemStack manual = ItemStack.field_190927_a;
        int manualStack = 0;

        public SkinResult(InventoryCrafting inv) {
            this.canCraft = this.process(inv);
            if (this.canCraft) {
                this.remaining = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
                this.remaining.set(this.manualStack, (Object)this.manual.func_77946_l());
                String last = ItemNBTHelper.getString((ItemStack)this.manual, (String)"lastSkin");
                ItemStack op = this.item.func_77946_l();
                this.skinnable.applySkinnableSkin(op, last);
                this.output = op;
            } else {
                this.remaining = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
                this.output = ItemStack.field_190927_a;
            }
        }

        private boolean process(InventoryCrafting inv) {
            boolean result;
            this.manual = ItemStack.field_190927_a;
            this.item = ItemStack.field_190927_a;
            this.skinnable = null;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                if (stack.func_77973_b() == IEContent.itemTool && stack.func_77952_i() == 3) {
                    if (this.manual.func_190926_b() && ItemNBTHelper.hasKey((ItemStack)stack, (String)"lastSkin")) {
                        this.manual = stack;
                        this.manualStack = i;
                        continue;
                    }
                    return false;
                }
                if (stack.func_77973_b() instanceof ISkinnable) {
                    if (!this.item.func_190926_b()) continue;
                    this.item = stack;
                    this.skinnable = (ISkinnable)stack.func_77973_b();
                    continue;
                }
                return false;
            }
            boolean bl = result = !this.manual.func_190926_b() && this.skinnable != null;
            if (result) {
                String sessionID = Minecraft.func_71410_x().func_110432_I().func_111286_b();
                String uuid = sessionID.substring(sessionID.lastIndexOf(58) + 1);
                String skinName = ItemNBTHelper.getString((ItemStack)this.manual, (String)"lastSkin");
                if (IISkinHandler.isValidSkin(skinName)) {
                    IISkinHandler.IISpecialSkin skin = IISkinHandler.getSkin(skinName);
                    boolean eligible = false;
                    boolean doesApply = skin.doesApply(this.skinnable.getSkinnableName());
                    for (String id : skin.uuid) {
                        if (!id.replace("-", "").equals(uuid)) continue;
                        eligible = true;
                        break;
                    }
                    if (!eligible || !doesApply) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return result;
        }
    }
}

