/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.Utils;
import it.unimi.dsi.fastutil.doubles.DoubleComparators;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.api.utils.IEntitySpecialRepairable;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock1.tileentity.TileEntityEmplacement;

public class EntityEmplacementWeapon
extends EntityLivingBase
implements IEntityMultiPart,
IEntitySpecialRepairable {
    TileEntityEmplacement.EmplacementWeapon parent = null;
    public EmplacementHitboxEntity[] partArray = new EmplacementHitboxEntity[0];
    public AxisAlignedBB aabb = new AxisAlignedBB(-1.5, 0.0, -1.5, 1.5, 3.0, 1.5);

    public EntityEmplacementWeapon(World worldIn) {
        super(worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 40 && this.getParent() == null) {
            this.func_70106_y();
        }
        if (this.getParent() != null) {
            this.parent.syncWithEntity(this);
            this.rotateCollisionBoxes();
        }
    }

    public Entity[] func_70021_al() {
        return this.partArray;
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.aabb.func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    public boolean func_70067_L() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        Team t = null;
        String name = "emplacement";
        if (this.parent != null) {
            EntityPlayer player;
            TileEntityEmplacement master;
            name = this.parent.getName();
            TileEntity tileEntity = this.field_70170_p.func_175625_s(this.func_180425_c());
            if (tileEntity instanceof TileEntityEmplacement && (master = (TileEntityEmplacement)((TileEntityEmplacement)tileEntity).master()) != null && (player = this.field_70170_p.func_72924_a(master.owner)) != null) {
                t = player.func_96124_cp();
            }
        }
        TextComponentTranslation textComponent = new TextComponentTranslation("machineupgrade.immersiveintelligence." + name, new Object[0]);
        if (t != null) {
            textComponent.func_150256_b().func_150238_a(t.func_178775_l());
        }
        textComponent.func_150256_b().func_150209_a(this.func_174823_aP());
        textComponent.func_150256_b().func_179989_a(this.func_189512_bd());
        return textComponent;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.parent == null) {
            return false;
        }
        if (source instanceof IEDamageSources.ElectricDamageSource || source == IEDamageSources.acid) {
            this.parent.applyDamage(amount * 1.1f);
            return true;
        }
        if (source.field_76373_n.equals("bullet")) {
            DamageSource temp_source = new DamageSource("bullet").func_76349_b().func_76348_h();
            return this.func_70965_a(this.partArray[Utils.RAND.nextInt(this.partArray.length)], source, amount * 0.5f);
        }
        if (source.func_76347_k() || source.func_82725_o()) {
            return false;
        }
        if (source.func_76364_f() instanceof EntityLivingBase) {
            Entity immediateSource = source.func_76364_f();
            Optional<EmplacementHitboxEntity> hitbox = Arrays.stream(this.partArray).min((o1, o2) -> DoubleComparators.NATURAL_COMPARATOR.compare((double)o1.func_70032_d(immediateSource), (double)o2.func_70032_d(immediateSource)));
            if (hitbox.isPresent()) {
                return this.func_70965_a(hitbox.get(), source, amount);
            }
        }
        return false;
    }

    public EnumHandSide func_184591_cq() {
        return null;
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    private void rotateCollisionBoxes() {
        if (this.partArray.length == 0) {
            this.partArray = this.parent.getCollisionBoxes();
        }
        if (this.partArray.length == 0) {
            return;
        }
        TileEntity te = this.field_70170_p.func_175625_s(this.func_180425_c());
        if (!(te instanceof TileEntityEmplacement)) {
            return;
        }
        TileEntityEmplacement t = (TileEntityEmplacement)((TileEntityEmplacement)te).master();
        if (t == null) {
            return;
        }
        float f = MathHelper.func_76131_a((float)((float)t.progress / (float)IIConfigHandler.IIConfig.Machines.Emplacement.lidTime), (float)0.0f, (float)1.0f);
        float turretHeight = (double)f <= 0.65 ? (f - 0.25f) / 0.4f : ((double)f <= 0.85 ? 1.0f : (f != 1.0f ? 1.0f - 0.35f * ((f - 0.85f) / 0.15f) : 0.65f));
        Vec3d thisPos = this.func_174791_d().func_72441_c(0.0, (double)(4.5f * turretHeight - 3.0f), 0.0);
        Vec3d pos_main_x = IIUtils.offsetPosDirection(1.0f, Math.toRadians(this.field_70177_z), 0.0);
        Vec3d pos_main_z = IIUtils.offsetPosDirection(1.0f, Math.toRadians(this.field_70177_z - 90.0f), 0.0);
        Vec3d pos_gun_x = IIUtils.offsetPosDirection(1.0f, Math.toRadians(this.field_70177_z), Math.toRadians(this.field_70125_A));
        Vec3d pos_gun_z = IIUtils.offsetPosDirection(1.0f, Math.toRadians(this.field_70177_z - 90.0f), Math.toRadians(this.field_70125_A - 90.0f));
        for (EmplacementHitboxEntity part : this.partArray) {
            part.updatePart(thisPos, pos_main_x, pos_main_z, pos_gun_x, pos_gun_z);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (this.field_70170_p.field_72995_K) {
            this.getParent();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return NonNullList.func_191196_a();
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        if (part instanceof EmplacementHitboxEntity) {
            int armor = ((EmplacementHitboxEntity)part).armor;
            if ((float)armor - damage > 0.0f) {
                this.field_70170_p.func_184133_a(null, this.func_180425_c(), IISounds.hitMetal.getSoundImpact(), SoundCategory.BLOCKS, 1.5f, (float)armor / damage * 0.95f);
                return false;
            }
            this.parent.applyDamage(damage - (float)armor);
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), IISounds.hitMetal.getSoundImpact(), SoundCategory.BLOCKS, 1.5f, 0.95f);
            return true;
        }
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), IISounds.hitMetal.getSoundRicochet(), SoundCategory.BLOCKS, 1.5f, 0.65f);
        return false;
    }

    @Nullable
    public TileEntityEmplacement.EmplacementWeapon getParent() {
        TileEntityEmplacement master;
        if (this.parent != null) {
            return this.parent;
        }
        TileEntity tileEntity = this.field_70170_p.func_175625_s(this.func_180425_c());
        if (tileEntity instanceof TileEntityEmplacement && (master = (TileEntityEmplacement)((TileEntityEmplacement)tileEntity).master()) != null && master.currentWeapon != null) {
            if (master.currentWeapon.entity == null || master.currentWeapon.entity == this) {
                this.parent = master.currentWeapon;
                return this.parent;
            }
            this.func_70106_y();
        }
        return null;
    }

    @Override
    public boolean canRepair() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.getHealth() != this.parent.getMaxHealth();
    }

    @Override
    public boolean repair(int repairPoints) {
        if (this.parent == null) {
            return false;
        }
        int maxAmount = MathHelper.func_76125_a((int)repairPoints, (int)0, (int)(this.parent.getMaxHealth() - this.parent.getHealth()));
        this.parent.applyDamage(-maxAmount);
        return true;
    }

    @Override
    public int getRepairCost() {
        if (this.parent == null) {
            return 0;
        }
        return 4;
    }

    public static class EmplacementHitboxEntity
    extends MultiPartEntityPart {
        protected final EntityEmplacementWeapon parentExt;
        private final Vec3d mainOffset;
        private final Vec3d gunOffset;
        protected final AxisAlignedBB aabb;
        protected final int armor;

        public EmplacementHitboxEntity(EntityEmplacementWeapon parent, String partName, float width, float height, Vec3d mainOffset, Vec3d gunOffset, int armor) {
            super((IEntityMultiPart)parent, partName, width, height);
            this.parentExt = parent;
            this.mainOffset = mainOffset;
            this.gunOffset = gunOffset;
            this.aabb = new AxisAlignedBB((double)(-width / 2.0f), (double)(-height / 2.0f), (double)(-width / 2.0f), (double)(width / 2.0f), (double)(height / 2.0f), (double)(width / 2.0f));
            this.armor = armor;
        }

        public void updatePart(Vec3d pPos, Vec3d posMainX, Vec3d posMainZ, Vec3d posGunX, Vec3d posGunZ) {
            posMainX = posMainX.func_186678_a(this.mainOffset.field_72450_a).func_72441_c(0.0, this.mainOffset.field_72448_b, 0.0);
            posMainZ = posMainZ.func_186678_a(this.mainOffset.field_72449_c);
            posGunX = posGunX.func_186678_a(this.gunOffset.field_72450_a);
            posGunZ = posGunZ.func_186678_a(this.gunOffset.field_72449_c);
            this.func_70012_b(pPos.field_72450_a + posMainX.field_72450_a + posMainZ.field_72450_a + posGunX.field_72450_a + posGunZ.field_72450_a, pPos.field_72448_b + posMainX.field_72448_b + posGunX.field_72448_b + posMainZ.field_72448_b + posGunZ.field_72448_b, pPos.field_72449_c + posMainX.field_72449_c + posMainZ.field_72449_c + posGunX.field_72449_c + posGunZ.field_72449_c, 0.0f, 0.0f);
            this.func_174826_a(this.aabb.func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
            this.func_70071_h_();
        }

        public void func_70108_f(Entity entityIn) {
            if (entityIn != this.parentExt && this.parentExt != null && Arrays.stream(this.parentExt.func_70021_al()).noneMatch(entity -> entity == entityIn)) {
                super.func_70108_f(entityIn);
            }
        }

        public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
            return true;
        }

        public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
            TileEntity tileEntity;
            if (this.field_70170_p.field_72995_K && this.parentExt != null && this.parentExt.parent != null && (tileEntity = this.field_70170_p.func_175625_s(this.parentExt.func_180425_c())) instanceof TileEntityEmplacement) {
                ClientUtils.mc().field_71442_b.func_187099_a(ClientUtils.mc().field_71439_g, ClientUtils.mc().field_71441_e, this.parentExt.func_180425_c(), EnumFacing.func_190914_a((BlockPos)this.parentExt.func_180425_c(), (EntityLivingBase)player), vec, hand);
                return EnumActionResult.SUCCESS;
            }
            return super.func_184199_a(player, vec, hand);
        }

        public AxisAlignedBB func_70046_E() {
            return this.func_174813_aQ();
        }

        public AxisAlignedBB func_70114_g(Entity entityIn) {
            return this.func_174813_aQ();
        }

        public boolean func_90999_ad() {
            return false;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source.field_76373_n.equals("iiShrapnel") || source.field_76373_n.equals("iiShrapnelNoShooter")) {
                return false;
            }
            if (source instanceof IEDamageSources.ElectricDamageSource || source == IEDamageSources.acid) {
                return this.field_70259_a.func_70965_a((MultiPartEntityPart)this, source, amount);
            }
            return super.func_70097_a(source, amount);
        }
    }
}

