/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.util.IEFluid;
import com.google.common.base.Optional;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import pl.pabilo8.immersiveintelligence.api.utils.armor.IGasmask;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;

public class EntityGasCloud
extends Entity {
    private FluidStack fluid;
    private static final DataParameter<Optional<FluidStack>> dataMarker_fluid = EntityDataManager.func_187226_a(EntityGasCloud.class, (DataSerializer)IEFluid.OPTIONAL_FLUID_STACK);
    private static final DataParameter<Float> dataMarker_radius = EntityDataManager.func_187226_a(EntityGasCloud.class, (DataSerializer)DataSerializers.field_187193_c);
    int duration;
    int maxDuration;
    float radius;

    public EntityGasCloud(World worldIn) {
        super(worldIn);
        this.maxDuration = this.duration = 600;
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.radius = 3.0f;
    }

    public EntityGasCloud(World worldIn, double x, double y, double z, FluidStack fs) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.fluid = fs;
        this.maxDuration = this.duration = (int)((float)this.fluid.amount * 0.65f);
        this.field_70180_af.func_187227_b(dataMarker_fluid, (Object)Optional.of((Object)this.fluid));
        this.field_70180_af.func_187227_b(dataMarker_radius, (Object)Float.valueOf(this.radius));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(dataMarker_fluid, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(dataMarker_radius, (Object)Float.valueOf(this.radius));
    }

    public void func_70071_h_() {
        this.func_70091_d(MoverType.SELF, 0.01f, 0.0, 0.01f);
        super.func_70071_h_();
        if (this.fluid == null && this.field_70170_p.field_72995_K) {
            this.fluid = (FluidStack)((Optional)this.field_70180_af.func_187225_a(dataMarker_fluid)).orNull();
            this.radius = ((Float)this.field_70180_af.func_187225_a(dataMarker_radius)).floatValue();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.duration > 0 && this.fluid != null) {
                --this.duration;
                ChemthrowerHandler.ChemthrowerEffect effect = ChemthrowerHandler.getEffect((Fluid)this.fluid.getFluid());
                if (effect != null) {
                    List entitiesWithinAABB = this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_186662_g((double)this.radius));
                    for (EntityLivingBase entityLivingBase : entitiesWithinAABB) {
                        boolean apply = true;
                        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                            ItemStack s = entityLivingBase.func_184582_a(slot);
                            if (s.func_190926_b() || !(s.func_77973_b() instanceof IGasmask) || !apply) continue;
                            apply = !((IGasmask)s.func_77973_b()).protectsFromGasses(s);
                        }
                        if (!apply) continue;
                        effect.applyToEntity(entityLivingBase, null, ItemStack.field_190927_a, this.fluid);
                    }
                }
            } else {
                this.func_70106_y();
            }
        } else if (this.field_70173_aa % 20 == 0) {
            ParticleUtils.spawnGasCloud(this.func_174791_d().func_72441_c(0.0, 1.0, 0.0), this.radius, this.fluid.getFluid());
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public void func_70015_d(int seconds) {
        if (ChemthrowerHandler.isFlammable((Fluid)this.fluid.getFluid())) {
            this.duration -= seconds * 10;
            super.func_70015_d(seconds);
        }
    }
}

