/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.entities.EntityIEProjectile;
import blusunrize.immersiveengineering.common.util.IEFluid;
import com.elytradev.mirage.event.GatherLightsEvent;
import com.elytradev.mirage.lighting.IEntityLightEventConsumer;
import com.elytradev.mirage.lighting.Light;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.common.util.raytracer.MultipleRayTracer;

@Optional.Interface(iface="com.elytradev.mirage.lighting.IEntityLightEventConsumer", modid="mirage")
public class EntityIIChemthrowerShot
extends EntityIEProjectile
implements IEntityLightEventConsumer {
    private final ArrayList<Entity> hitEntities = new ArrayList();
    private final ArrayList<BlockPos> hitPos = new ArrayList();
    private FluidStack fluid;
    private static final DataParameter<Optional<FluidStack>> dataMarker_fluid = EntityDataManager.func_187226_a(EntityIIChemthrowerShot.class, (DataSerializer)IEFluid.OPTIONAL_FLUID_STACK);

    public EntityIIChemthrowerShot(World world) {
        super(world);
    }

    public EntityIIChemthrowerShot(World world, double x, double y, double z, double ax, double ay, double az, FluidStack fluid) {
        super(world, x, y, z, ax, ay, az);
        this.fluid = fluid;
        this.setFluidSynced();
    }

    public EntityIIChemthrowerShot(World world, EntityLivingBase living, double ax, double ay, double az, FluidStack fluid) {
        super(world, living, ax, ay, az);
        this.fluid = fluid;
        this.setFluidSynced();
    }

    public EntityIIChemthrowerShot withShooters(Entity ... entities) {
        if (entities.length > 0) {
            this.hitEntities.addAll(Arrays.asList(entities));
        }
        return this;
    }

    public EntityIIChemthrowerShot withShooters(BlockPos ... entities) {
        if (entities.length > 0) {
            this.hitPos.addAll(Arrays.asList(entities));
        }
        return this;
    }

    public EntityIIChemthrowerShot withMotion(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        return this;
    }

    public EntityIIChemthrowerShot withMotion(Vec3d vecDir) {
        return this.withMotion(vecDir.field_72450_a, vecDir.field_72448_b, vecDir.field_72449_c);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(dataMarker_fluid, (Object)Optional.absent());
    }

    public void setFluidSynced() {
        if (this.getFluid() != null) {
            this.field_70180_af.func_187227_b(dataMarker_fluid, (Object)Optional.of((Object)this.getFluid()));
        }
    }

    public FluidStack getFluidSynced() {
        return (FluidStack)((Optional)this.field_70180_af.func_187225_a(dataMarker_fluid)).orNull();
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public double getGravity() {
        if (this.getFluid() != null) {
            FluidStack fluidStack = this.getFluid();
            boolean isGas = fluidStack.getFluid().isGaseous(fluidStack) || ChemthrowerHandler.isGas((Fluid)fluidStack.getFluid());
            return (isGas ? 0.025f : 0.05f) * (float)(fluidStack.getFluid().getDensity(fluidStack) < 0 ? -1 : 1);
        }
        return super.getGravity();
    }

    public boolean canIgnite() {
        return ChemthrowerHandler.isFlammable(this.getFluid() == null ? null : this.getFluid().getFluid());
    }

    public void func_70071_h_() {
        if (this.getShooter() == null && this.field_70170_p.field_72995_K) {
            this.field_70250_c = this.getShooterSynced();
        }
        this.func_70030_z();
        if (!this.field_70254_i) {
            Vec3d nextPosition = this.func_174791_d().func_72441_c(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            MultipleRayTracer tracer = MultipleRayTracer.MultipleTracerBuilder.setPos(this.field_70170_p, this.func_174791_d(), nextPosition).setAABB(this.func_174813_aQ()).setFilters(this.hitEntities, this.hitPos).volumetricTrace();
            for (RayTraceResult hit : tracer) {
                this.onImpact(hit);
                switch (hit.field_72313_a) {
                    case BLOCK: {
                        if (!this.hitPos.contains(hit.func_178782_a())) break;
                        break;
                    }
                    case ENTITY: {
                        if (this.hitEntities.contains(hit.field_72308_g) || this.field_190534_ay <= 0) break;
                        hit.field_72308_g.func_70015_d(this.field_190534_ay);
                        break;
                    }
                }
            }
        } else {
            IBlockState state = this.field_70170_p.func_180495_p(this.func_180425_c());
            Block block = state.func_177230_c();
            if (block == this.inBlock && block.func_176201_c(state) == this.inMeta) {
                ++this.field_70252_j;
                if (this.field_70252_j >= this.getMaxTicksInGround()) {
                    this.func_70106_y();
                }
            } else {
                this.field_70254_i = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70252_j = 0;
                this.field_70257_an = 0;
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        Vec3d normalized = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b();
        float motionXZ = MathHelper.func_76133_a((double)(normalized.field_72450_a * normalized.field_72450_a + normalized.field_72449_c * normalized.field_72449_c));
        this.field_70177_z = (float)(Math.atan2(normalized.field_72450_a, normalized.field_72449_c) * 180.0 / 3.1415927410125732);
        this.field_70125_A = -((float)(Math.atan2(normalized.field_72448_b, motionXZ) * 180.0 / 3.1415927410125732));
        if (this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                float f3 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            this.field_70159_w *= 0.2;
            this.field_70181_x *= 0.2;
            this.field_70179_y *= 0.2;
        }
        this.field_70181_x -= this.getGravity();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    public void func_70030_z() {
        IBlockState state;
        Block b;
        if (this.getFluid() == null && this.field_70170_p.field_72995_K) {
            this.fluid = this.getFluidSynced();
        }
        if ((b = (state = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))).func_177230_c()) != null && this.canIgnite() && (state.func_185904_a() == Material.field_151581_o || state.func_185904_a() == Material.field_151587_i)) {
            this.func_70015_d(6);
        }
        super.func_70030_z();
    }

    public void func_70015_d(int seconds) {
        if (!this.canIgnite()) {
            return;
        }
        super.func_70015_d(seconds);
    }

    public void onImpact(RayTraceResult mop) {
        if (!this.field_70170_p.field_72995_K && this.getFluid() != null) {
            int tempDiff;
            int damage;
            boolean fire;
            FluidStack fluidStack = this.getFluid();
            Fluid fluid = fluidStack.getFluid();
            ChemthrowerHandler.ChemthrowerEffect effect = ChemthrowerHandler.getEffect((Fluid)fluid);
            boolean bl = fire = fluid.getTemperature(fluidStack) > 1000;
            if (effect != null) {
                ItemStack thrower = ItemStack.field_190927_a;
                EntityPlayer shooter = (EntityPlayer)this.getShooter();
                if (shooter != null) {
                    thrower = shooter.func_184586_b(EnumHand.MAIN_HAND);
                }
                if (mop.field_72313_a == RayTraceResult.Type.ENTITY && mop.field_72308_g instanceof EntityLivingBase) {
                    effect.applyToEntity((EntityLivingBase)mop.field_72308_g, shooter, thrower, fluidStack);
                } else if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                    effect.applyToBlock(this.field_70170_p, mop, shooter, thrower, fluidStack);
                }
            } else if (mop.field_72308_g != null && fluid.getTemperature(fluidStack) > 500 && mop.field_72308_g.func_70097_a(DamageSource.field_76371_c, (float)(damage = Math.abs(tempDiff = fluid.getTemperature(fluidStack) - 300) / 500))) {
                mop.field_72308_g.field_70172_ad = (int)((double)mop.field_72308_g.field_70172_ad * 0.75);
            }
            if (mop.field_72308_g != null) {
                int f;
                int n = this.func_70027_ad() ? this.field_190534_ay : (f = fire ? 3 : 0);
                if (f > 0) {
                    mop.field_72308_g.func_70015_d(f);
                    if (mop.field_72308_g.func_70097_a(DamageSource.field_76372_a, 2.0f)) {
                        mop.field_72308_g.field_70172_ad = (int)((double)mop.field_72308_g.field_70172_ad * 0.75);
                    }
                }
            }
        }
    }

    protected boolean allowFriendlyFire(EntityPlayer target) {
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            ChemthrowerHandler.ChemthrowerEffect effect = ChemthrowerHandler.getEffect((Fluid)fluidStack.getFluid());
            return effect instanceof ChemthrowerHandler.ChemthrowerEffect_Potion && !((ChemthrowerHandler.ChemthrowerEffect_Potion)effect).getIsNegative();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            int light = this.func_70027_ad() ? 15 : fluidStack.getFluid().getLuminosity(fluidStack);
            int superBrightness = super.func_70070_b();
            light = superBrightness & 0xFF00000 | light << 4;
            if (light > 0) {
                return Math.max(light, superBrightness);
            }
        }
        return super.func_70070_b();
    }

    public float func_70013_c() {
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            int light;
            int n = light = this.func_70027_ad() ? 15 : fluidStack.getFluid().getLuminosity(fluidStack);
            if (light > 0) {
                return Math.max((float)light, super.func_70013_c());
            }
        }
        return super.func_70013_c();
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="mirage")
    public void gatherLights(GatherLightsEvent gatherLightsEvent, Entity entity) {
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            int light;
            int n = light = this.func_70027_ad() ? 15 : fluidStack.getFluid().getLuminosity(fluidStack);
            if (light > 0) {
                gatherLightsEvent.add(Light.builder().pos((Entity)this).radius(0.05f * (float)light).color(1.0f, 1.0f, 1.0f).build());
            }
        }
    }
}

