/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity;

import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoUtils;
import pl.pabilo8.immersiveintelligence.api.utils.camera.IEntityZoomProvider;
import pl.pabilo8.immersiveintelligence.api.utils.tools.IAdvancedZoomTool;
import pl.pabilo8.immersiveintelligence.client.util.CameraHandler;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageEntityNBTSync;

public class EntityMortar
extends Entity
implements IEntityAdditionalSpawnData,
IEntityZoomProvider {
    private static final MortarSights SIGHTS = new MortarSights();
    private static final DataParameter<Boolean> dataMarkerGunPitchUp = EntityDataManager.func_187226_a(EntityMortar.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> dataMarkerGunPitchDown = EntityDataManager.func_187226_a(EntityMortar.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> dataMarkerShootingProgress = EntityDataManager.func_187226_a(EntityMortar.class, (DataSerializer)DataSerializers.field_187193_c);
    public boolean fireKeyPress = false;
    public boolean gunPitchUp = false;
    public boolean gunPitchDown = false;
    public int setupTime = 0;
    public float shootingProgress = 0.0f;

    public EntityMortar(World worldIn) {
        super(worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(dataMarkerGunPitchUp, (Object)this.gunPitchUp);
        this.field_70180_af.func_187214_a(dataMarkerGunPitchDown, (Object)this.gunPitchDown);
        this.field_70180_af.func_187214_a(dataMarkerShootingProgress, (Object)Float.valueOf(this.shootingProgress));
        this.func_70105_a(1.0f, 1.5f);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 20L == 0L && !this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).isSideSolid((IBlockAccess)this.field_70170_p, this.func_180425_c().func_177977_b(), EnumFacing.UP)) {
            this.func_70106_y();
            this.func_70099_a(this.getPickedResult(null), 0.0f);
        }
        if (this.setupTime < IIConfigHandler.IIConfig.Weapons.Mortar.setupTime) {
            ++this.setupTime;
        } else {
            Entity entity;
            if (this.field_70170_p.field_72995_K) {
                Entity pre = ClientUtils.mc().field_71439_g.func_184187_bx();
                if (pre == this) {
                    this.handleClientKeyInput();
                    this.handleClientKeyOutput(true);
                } else {
                    this.handleClientKeyOutput(false);
                }
            } else {
                this.handleServerKeyInput();
                if (this.func_184188_bt().size() == 0) {
                    this.gunPitchUp = false;
                    this.gunPitchDown = false;
                    this.shootingProgress = 0.0f;
                }
            }
            if (this.shootingProgress == 0.0f) {
                if (this.fireKeyPress && this.func_184188_bt().size() > 0) {
                    ItemStack heldItem;
                    entity = (Entity)this.func_184188_bt().get(0);
                    if (entity instanceof EntityLivingBase && (heldItem = ((EntityLivingBase)entity).func_184586_b(EnumHand.MAIN_HAND)).func_77973_b() == IIContent.itemAmmoMortar) {
                        this.shootingProgress = 1.0f;
                        this.fireKeyPress = false;
                    }
                } else if (this.gunPitchUp) {
                    this.field_70125_A = MathHelper.func_76131_a((float)(this.field_70125_A + 0.5f), (float)-80.0f, (float)-55.0f);
                } else if (this.gunPitchDown) {
                    this.field_70125_A = MathHelper.func_76131_a((float)(this.field_70125_A - 0.5f), (float)-80.0f, (float)-55.0f);
                }
            } else if (this.func_184188_bt().size() > 0) {
                entity = (Entity)this.func_184188_bt().get(0);
                if (entity instanceof EntityLivingBase) {
                    ItemStack heldItem = ((EntityLivingBase)entity).func_184586_b(EnumHand.MAIN_HAND);
                    if (heldItem.func_77973_b() == IIContent.itemAmmoMortar || (double)this.shootingProgress > (double)IIConfigHandler.IIConfig.Weapons.Mortar.shootTime * 0.45) {
                        this.shootingProgress = this.shootingProgress < (float)IIConfigHandler.IIConfig.Weapons.Mortar.shootTime ? (this.shootingProgress += 1.0f) : 0.0f;
                        if (this.shootingProgress == (float)Math.round((float)IIConfigHandler.IIConfig.Weapons.Mortar.shootTime * 0.2f)) {
                            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, IISounds.mortarLoad, SoundCategory.PLAYERS, 1.25f, 1.0f);
                        }
                        if (this.shootingProgress == (float)Math.round((float)IIConfigHandler.IIConfig.Weapons.Mortar.shootTime * 0.55f) && !this.field_70170_p.field_72995_K) {
                            double true_angle = Math.toRadians(MathHelper.func_76142_g((float)(-this.field_70177_z + 180.0f)));
                            double true_angle2 = Math.toRadians(this.field_70125_A);
                            Vec3d gun_end = IIUtils.offsetPosDirection(2.0f, true_angle, true_angle2);
                            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, IISounds.mortarShot, SoundCategory.PLAYERS, 1.25f, 1.0f);
                            EntityBullet a = AmmoUtils.createBullet(this.field_70170_p, heldItem.func_77946_l(), this.func_174791_d().func_178787_e(gun_end.func_186678_a(-1.0)).func_72441_c(0.0, 1.0, 0.0), gun_end.func_186678_a(-1.0).func_72432_b());
                            a.setShooters(this, new Entity[0]);
                            this.field_70170_p.func_72838_d((Entity)a);
                            heldItem.func_190918_g(1);
                        }
                    } else {
                        this.shootingProgress = 0.0f;
                    }
                }
            } else {
                this.shootingProgress = 0.0f;
            }
        }
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return amount > 4.0f;
    }

    private void handleClientKeyInput() {
        boolean hasChanged;
        boolean u = this.gunPitchUp;
        boolean d = this.gunPitchDown;
        boolean fk = this.fireKeyPress;
        this.gunPitchUp = ClientUtils.mc().field_71474_y.field_74351_w.func_151470_d();
        this.gunPitchDown = ClientUtils.mc().field_71474_y.field_74368_y.func_151470_d();
        this.fireKeyPress = Mouse.isButtonDown((int)1);
        boolean bl = hasChanged = u ^ this.gunPitchUp || d ^ this.gunPitchDown || fk ^ this.fireKeyPress;
        if (hasChanged) {
            IIPacketHandler.sendToServer(new MessageEntityNBTSync(this, this.updateKeys()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private NBTTagCompound updateKeys() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("gunPitchUp", this.gunPitchUp);
        compound.func_74757_a("gunPitchDown", this.gunPitchDown);
        compound.func_74757_a("fireKeyPress", this.fireKeyPress);
        return compound;
    }

    public void syncKeyPress(NBTTagCompound tag) {
        if (tag.func_74764_b("gunPitchUp")) {
            this.gunPitchUp = tag.func_74767_n("gunPitchUp");
        }
        if (tag.func_74764_b("gunPitchDown")) {
            this.gunPitchDown = tag.func_74767_n("gunPitchDown");
        }
        if (tag.func_74764_b("fireKeyPress")) {
            this.fireKeyPress = tag.func_74767_n("fireKeyPress");
        }
    }

    private void handleClientKeyOutput(boolean user) {
        if (user) {
            this.field_70180_af.func_187225_a(dataMarkerGunPitchUp);
            this.field_70180_af.func_187225_a(dataMarkerGunPitchDown);
            this.field_70180_af.func_187225_a(dataMarkerShootingProgress);
        } else {
            this.gunPitchUp = (Boolean)this.field_70180_af.func_187225_a(dataMarkerGunPitchUp);
            this.gunPitchDown = (Boolean)this.field_70180_af.func_187225_a(dataMarkerGunPitchDown);
            this.shootingProgress = ((Float)this.field_70180_af.func_187225_a(dataMarkerShootingProgress)).floatValue();
        }
    }

    private void handleServerKeyInput() {
        this.field_70180_af.func_187227_b(dataMarkerGunPitchUp, (Object)this.gunPitchUp);
        this.field_70180_af.func_187227_b(dataMarkerGunPitchDown, (Object)this.gunPitchDown);
        this.field_70180_af.func_187227_b(dataMarkerShootingProgress, (Object)Float.valueOf(this.shootingProgress));
    }

    @SideOnly(value=Side.CLIENT)
    protected void func_184225_p(Entity passenger) {
        if (this.field_70170_p.field_72995_K && passenger instanceof EntityPlayerSP) {
            CameraHandler.setEnabled(false);
            ZoomHandler.isZooming = false;
        }
        super.func_184225_p(passenger);
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && player.func_70093_af() && this.func_184188_bt().size() == 0) {
            this.func_70106_y();
            this.func_70099_a(this.getPickedResult(null), 0.0f);
            return true;
        }
        if (this.setupTime == IIConfigHandler.IIConfig.Weapons.Mortar.setupTime && player.func_184187_bx() != this && this.func_184188_bt().size() == 0) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_184232_k(Entity passenger) {
        Vec3d pos = this.func_174791_d();
        float headYaw = MathHelper.func_76142_g((float)this.field_70177_z);
        double true_angle = Math.toRadians(-headYaw > 180.0f ? (double)(360.0f - -headYaw) : (double)(-headYaw));
        double true_angle2 = Math.toRadians(-headYaw - 90.0f > 180.0f ? (double)(360.0f - (-headYaw - 90.0f)) : (double)(-headYaw - 90.0f));
        Vec3d pos2 = IIUtils.offsetPosDirection(0.125f, true_angle, 0.0);
        Vec3d pos3 = IIUtils.offsetPosDirection(-0.75f, true_angle2, 0.0);
        float ff = 1.0f;
        if (this.shootingProgress > 0.0f) {
            float v = this.shootingProgress / (float)IIConfigHandler.IIConfig.Weapons.Mortar.shootTime;
            if ((double)v < 0.1) {
                ff = 1.0f - v / 0.1f;
            } else if ((double)v < 0.3) {
                ff = 0.0f;
            } else if ((double)v < 0.4) {
                ff = (v - 0.3f) / 0.1f;
            }
        }
        passenger.func_70107_b(pos.field_72450_a + pos2.field_72450_a + pos3.field_72450_a, pos.field_72448_b - 0.5 * (double)ff, pos.field_72449_c + pos2.field_72449_c + pos3.field_72449_c);
        this.func_184190_l(passenger);
    }

    public void func_184190_l(Entity entityToUpdate) {
        float yy = this.field_70177_z;
        if (this.setupTime == IIConfigHandler.IIConfig.Weapons.Mortar.setupTime) {
            yy = (float)((double)yy + MathHelper.func_151237_a((double)((double)this.setupTime / ((double)IIConfigHandler.IIConfig.Weapons.Mortar.setupTime * 0.2)), (double)0.0, (double)1.0) * 25.0);
        }
        if (this.shootingProgress > 0.0f) {
            float ff = this.shootingProgress / (float)IIConfigHandler.IIConfig.Weapons.Mortar.shootTime;
            if ((double)ff < 0.3) {
                yy = (float)((double)yy + MathHelper.func_151237_a((double)((double)ff / 0.1), (double)0.0, (double)1.0) * 65.0);
            } else if ((double)ff < 0.4) {
                yy = (float)((double)yy + (1.0 - MathHelper.func_151237_a((double)(((double)ff - 0.3) / 0.1), (double)0.0, (double)1.0)) * 65.0);
            }
        }
        entityToUpdate.func_181013_g(yy);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-75.0f, (float)75.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setupTime = compound.func_74762_e("setupTime");
        this.gunPitchUp = compound.func_74767_n("gunPitchUp");
        this.gunPitchDown = compound.func_74767_n("gunPitchDown");
        this.shootingProgress = compound.func_74760_g("shootingProgress");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("setupTime", this.setupTime);
        compound.func_74757_a("gunPitchUp", this.gunPitchUp);
        compound.func_74757_a("gunPitchDown", this.gunPitchDown);
        compound.func_74776_a("shootingProgress", this.shootingProgress);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((Item)IIContent.itemMortar);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.setupTime);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setupTime = additionalData.readInt();
    }

    @Override
    public IAdvancedZoomTool getZoom() {
        return SIGHTS;
    }

    private static class MortarSights
    implements IAdvancedZoomTool {
        private static final ResourceLocation SIGHTS_TEXTURE = new ResourceLocation("immersiveintelligence", "textures/gui/item/mortar.png");

        private MortarSights() {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getZoomOverlayTexture(ItemStack stack, EntityPlayer player) {
            return SIGHTS_TEXTURE;
        }

        @Override
        public boolean shouldZoom(ItemStack stack, EntityPlayer player) {
            Entity ridingEntity = player.func_184187_bx();
            return ridingEntity instanceof EntityMortar && ((EntityMortar)ridingEntity).shootingProgress == 0.0f;
        }

        @Override
        public float[] getZoomSteps(ItemStack stack, EntityPlayer player) {
            Entity ridingEntity = player.func_184187_bx();
            if (ridingEntity instanceof EntityMortar) {
                return new float[]{1.0f - Math.min(0.75f / (ridingEntity.field_70125_A / -90.0f), 0.975f)};
            }
            return new float[]{0.0f};
        }
    }
}

