/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.bullet;

import blusunrize.immersiveengineering.common.entities.EntityIEProjectile;
import com.elytradev.mirage.event.GatherLightsEvent;
import com.elytradev.mirage.lighting.IEntityLightEventConsumer;
import com.elytradev.mirage.lighting.Light;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.ShrapnelHandler;
import pl.pabilo8.immersiveintelligence.common.util.IIDamageSources;

@Optional.Interface(iface="com.elytradev.mirage.lighting.IEntityLightEventConsumer", modid="mirage")
public class EntityShrapnel
extends EntityIEProjectile
implements IEntityLightEventConsumer,
IEntityAdditionalSpawnData {
    public String shrapnel;

    public EntityShrapnel(World world) {
        super(world);
    }

    public EntityShrapnel(World world, double x, double y, double z, double ax, double ay, double az, String shrapnel) {
        super(world, x, y, z, ax, ay, az);
        this.shrapnel = shrapnel;
    }

    public EntityShrapnel(World world, EntityLivingBase living, double ax, double ay, double az, String shrapnel) {
        super(world, living, ax, ay, az);
        this.shrapnel = shrapnel;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public double getGravity() {
        if (ShrapnelHandler.registry.get(this.shrapnel) != null) {
            return (double)ShrapnelHandler.registry.get((Object)this.shrapnel).mass * 0.05;
        }
        return super.getGravity();
    }

    public boolean canIgnite() {
        return ShrapnelHandler.registry.get(this.shrapnel) != null && ShrapnelHandler.registry.get((Object)this.shrapnel).flammable;
    }

    public void func_70030_z() {
        IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v));
        Block b = state.func_177230_c();
        if (b != null && this.canIgnite() && (state.func_185904_a() == Material.field_151581_o || state.func_185904_a() == Material.field_151587_i)) {
            this.func_70015_d(6);
        }
        super.func_70030_z();
    }

    public void func_70015_d(int seconds) {
        if (!this.canIgnite()) {
            return;
        }
        super.func_70015_d(seconds);
    }

    public void onImpact(RayTraceResult mop) {
        if (!this.field_70170_p.field_72995_K && ShrapnelHandler.registry.get(this.shrapnel) != null) {
            ShrapnelHandler.Shrapnel s = ShrapnelHandler.registry.get(this.shrapnel);
            if (mop.field_72308_g != null) {
                mop.field_72308_g.func_70097_a(IIDamageSources.causeShrapnelDamage(this, this.field_70250_c, mop.field_72308_g), (float)s.damage);
                mop.field_72308_g.field_70172_ad = (int)((double)mop.field_72308_g.field_70172_ad * 0.5);
                if (this.func_70027_ad()) {
                    mop.field_72308_g.func_70015_d(10);
                    if (mop.field_72308_g.func_70097_a(DamageSource.field_76372_a, 2.0f)) {
                        mop.field_72308_g.field_70172_ad = (int)((double)mop.field_72308_g.field_70172_ad * 0.75);
                    }
                }
            }
        }
    }

    protected boolean allowFriendlyFire(EntityPlayer target) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="mirage")
    public void gatherLights(GatherLightsEvent evt, Entity entity) {
        int light;
        ShrapnelHandler.Shrapnel s = ShrapnelHandler.registry.get(this.shrapnel);
        if (s == null) {
            return;
        }
        int n = light = this.func_70027_ad() ? 15 : Math.round(s.brightness * 15.0f);
        if (light > 0) {
            evt.add(Light.builder().pos((Entity)this).color(1.0f, 1.0f, 1.0f).radius(0.05f).build());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        ShrapnelHandler.Shrapnel s = ShrapnelHandler.registry.get(this.shrapnel);
        if (s != null) {
            int light = this.func_70027_ad() ? 15 : Math.round(s.brightness * 15.0f);
            int superBrightness = super.func_70070_b();
            light = superBrightness & 0xFF00000 | light << 4;
            if (light > 0) {
                return Math.max(light, superBrightness);
            }
        }
        return super.func_70070_b();
    }

    public float func_70013_c() {
        ShrapnelHandler.Shrapnel s = ShrapnelHandler.registry.get(this.shrapnel);
        if (s != null) {
            int light;
            int n = light = this.func_70027_ad() ? 15 : Math.round(s.brightness * 15.0f);
            if (light > 0) {
                return Math.max((float)light, super.func_70013_c());
            }
        }
        return super.func_70013_c();
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74778_a("shrapnel", this.shrapnel);
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.shrapnel = tag.func_74779_i("shrapnel");
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.shrapnel);
    }

    public void readSpawnData(ByteBuf data) {
        this.shrapnel = ByteBufUtils.readUTF8String((ByteBuf)data);
    }
}

