/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.hans;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.NonNullList;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.gate_multiblock.tileentity.TileEntityGateBase;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.EntityParachute;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon.AIHansAbstractGun;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon.AIHansBinoculars;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon.AIHansChemthrower;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon.AIHansGrenade;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon.AIHansHandWeapon;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon.AIHansRailgun;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon.AIHansRevolver;
import pl.pabilo8.immersiveintelligence.common.item.armor.ItemIIArmorUpgrade;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIWeaponUpgrade;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIIUpgradeableArmor;

public class HansUtils {
    public static final HashMap<Item, Function<EntityHans, AIHansHandWeapon>> WEAPON_MAP = new HashMap();

    public static void init() {
        WEAPON_MAP.put((Item)IEContent.itemRevolver, AIHansRevolver::new);
        WEAPON_MAP.put((Item)IIContent.itemSubmachinegun, hans -> new AIHansAbstractGun((EntityHans)((Object)hans), IIContent.itemSubmachinegun, 3.0f, 12.0f, 10){});
        WEAPON_MAP.put((Item)IIContent.itemAssaultRifle, hans -> new AIHansAbstractGun((EntityHans)((Object)hans), IIContent.itemAssaultRifle, 5.0f, 16.0f, 5){});
        WEAPON_MAP.put((Item)IIContent.itemRifle, hans -> new AIHansAbstractGun((EntityHans)((Object)hans), IIContent.itemRifle, 6.0f, 24.0f, 40){});
        WEAPON_MAP.put((Item)IEContent.itemRailgun, AIHansRailgun::new);
        WEAPON_MAP.put((Item)IEContent.itemChemthrower, AIHansChemthrower::new);
        WEAPON_MAP.put(IIContent.itemBinoculars, AIHansBinoculars::new);
        WEAPON_MAP.put(IIContent.itemGrenade, AIHansGrenade::new);
    }

    @Nullable
    public static AIHansHandWeapon getHandWeaponTask(EntityHans hans) {
        return WEAPON_MAP.entrySet().stream().filter(entry -> entry.getKey() == hans.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b()).findFirst().map(Map.Entry::getValue).map(fun -> (AIHansHandWeapon)((Object)((Object)fun.apply(hans)))).orElse(null);
    }

    private static void setArmor(EntityHans hans, EntityEquipmentSlot slot, ItemIIUpgradeableArmor item, ItemIIArmorUpgrade.ArmorUpgrades ... armorUpgrades) {
        ItemStack stack = new ItemStack((Item)item);
        int i = item.getSlotCount();
        NonNullList upgrades = NonNullList.func_191197_a((int)i, (Object)ItemStack.field_190927_a);
        for (ItemIIArmorUpgrade.ArmorUpgrades upgrade : armorUpgrades) {
            upgrades.set(--i, (Object)new ItemStack((Item)IIContent.itemArmorUpgrade, 1, upgrade.ordinal()));
            if (i == 0) break;
        }
        item.setContainedItems(stack, (NonNullList<ItemStack>)upgrades);
        item.recalculateUpgrades(stack);
        item.finishUpgradeRecalculation(stack);
        hans.func_184201_a(slot, stack);
    }

    public static void setHelmet(EntityHans hans, ItemIIArmorUpgrade.ArmorUpgrades ... armorUpgrades) {
        HansUtils.setArmor(hans, EntityEquipmentSlot.HEAD, IIContent.itemLightEngineerHelmet, armorUpgrades);
    }

    public static void setSubmachinegun(EntityHans hans, ItemStack magazine, ItemIIWeaponUpgrade.WeaponUpgrades ... weaponUpgrades) {
        HansUtils.setHandGun(hans, IIContent.itemSubmachinegun, magazine, weaponUpgrades);
    }

    public static void setAssaultRifle(EntityHans hans, ItemStack magazine, ItemIIWeaponUpgrade.WeaponUpgrades ... weaponUpgrades) {
        HansUtils.setHandGun(hans, IIContent.itemAssaultRifle, magazine, weaponUpgrades);
    }

    public static void setRifle(EntityHans hans, ItemStack magazine, ItemIIWeaponUpgrade.WeaponUpgrades ... weaponUpgrades) {
        HansUtils.setHandGun(hans, IIContent.itemRifle, magazine, weaponUpgrades);
    }

    public static void setHandGun(EntityHans hans, ItemUpgradeableTool item, ItemStack magazine, ItemIIWeaponUpgrade.WeaponUpgrades ... weaponUpgrades) {
        ItemStack stack = new ItemStack((Item)item);
        ItemNBTHelper.setItemStack((ItemStack)stack, (String)"magazine", (ItemStack)magazine);
        int i = item.getSlotCount(stack);
        NonNullList upgrades = NonNullList.func_191197_a((int)i, (Object)ItemStack.field_190927_a);
        for (ItemIIWeaponUpgrade.WeaponUpgrades upgrade : weaponUpgrades) {
            upgrades.set(--i, (Object)new ItemStack((Item)IIContent.itemWeaponUpgrade, 1, upgrade.ordinal()));
            if (i == 0) break;
        }
        item.setContainedItems(stack, upgrades);
        item.recalculateUpgrades(stack);
        item.finishUpgradeRecalculation(stack);
        hans.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
    }

    public static void setParachute(Entity entity) {
        EntityParachute para = new EntityParachute(entity.func_130014_f_());
        para.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        entity.field_70170_p.func_72838_d((Entity)para);
        entity.func_184220_m((Entity)para);
    }

    public static String getGermanTimeName(long time) {
        if (time < 11500L) {
            return "Morgen";
        }
        if (time < 18000L) {
            return "Tag";
        }
        return "Abend";
    }

    static PathNodeType getDoorNode(IBlockState state) {
        boolean open = (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b);
        if (!open) {
            return state.func_185904_a() == Material.field_151575_d ? PathNodeType.DOOR_WOOD_CLOSED : PathNodeType.DOOR_IRON_CLOSED;
        }
        return PathNodeType.DOOR_OPEN;
    }

    static PathNodeType getGateNode(TileEntityGateBase<?> te) {
        return te.isDoorPart() ? (te.gate.getState() ? PathNodeType.DOOR_OPEN : PathNodeType.DOOR_WOOD_CLOSED) : PathNodeType.BLOCKED;
    }

    static PathNodeType getFenceGateNode(IBlockState state) {
        boolean open = (Boolean)state.func_177229_b((IProperty)BlockFenceGate.field_176466_a);
        if (!open) {
            return state.func_185904_a() == Material.field_151575_d ? PathNodeType.DOOR_WOOD_CLOSED : PathNodeType.DOOR_IRON_CLOSED;
        }
        return PathNodeType.DOOR_OPEN;
    }
}

