/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.hans.tasks;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.vehicle.EntityFieldHowitzer;
import pl.pabilo8.immersiveintelligence.common.entity.vehicle.EntityVehicleSeat;

public class AIHansHowitzer
extends EntityAIBase {
    private final EntityLiving hans;
    private EntityFieldHowitzer howitzer = null;
    private int seat = 0;
    private Optional<Entity> target = Optional.empty();

    public AIHansHowitzer(EntityLiving hans) {
        this.hans = hans;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!(this.hans.func_184187_bx() instanceof EntityVehicleSeat) || !(this.hans.func_184187_bx().func_184187_bx() instanceof EntityFieldHowitzer)) {
            this.hans.field_70714_bg.func_85156_a((EntityAIBase)this);
            return false;
        }
        this.seat = ((EntityVehicleSeat)this.hans.func_184187_bx()).seatID;
        this.howitzer = (EntityFieldHowitzer)this.hans.func_184187_bx().func_184187_bx();
        if (this.howitzer == null || this.howitzer.field_70128_L) {
            this.hans.field_70714_bg.func_85156_a((EntityAIBase)this);
            return false;
        }
        if (this.seat == 0) {
            this.target = Optional.ofNullable(this.hans.func_70638_az());
        } else {
            List passengers = EntityVehicleSeat.getOrCreateSeat(this.howitzer, 0).func_184188_bt();
            if (passengers.size() > 0 && passengers.get(0) instanceof EntityLiving) {
                EntityLiving entityLiving = (EntityLiving)passengers.get(0);
                this.target = Optional.ofNullable(entityLiving.func_70638_az());
            }
        }
        return true;
    }

    public void func_75246_d() {
        Vec3d positionVector = this.howitzer.func_174791_d().func_72441_c(0.0, 1.0, 0.0);
        if (this.seat == 0) {
            if (!(this.howitzer.turnLeft || this.howitzer.turnRight || this.howitzer.forward || this.howitzer.backward || !this.target.isPresent())) {
                Entity t = this.target.get();
                this.hans.func_70625_a(t, 10.0f, 10.0f);
                float pp = positionVector.func_72438_d(t.func_174791_d()) > 40.0 ? this.getAnglePrediction(positionVector, IIUtils.getEntityCenter(t), new Vec3d(t.field_70159_w, t.field_70181_x, t.field_70179_y))[1] : IIUtils.getDirectFireAngle(IIContent.itemAmmoLightArtillery.getDefaultVelocity(), 3.4f, positionVector.func_178788_d(t.func_174791_d()));
                this.howitzer.gunPitchUp = this.howitzer.gunPitch - pp < 0.0f;
                boolean bl = this.howitzer.gunPitchDown = this.howitzer.gunPitch - pp > 0.0f;
                if (Math.abs(this.howitzer.gunPitch - pp) < 5.0f) {
                    if (this.howitzer.shell.func_190926_b()) {
                        Entity entity = (Entity)EntityVehicleSeat.getOrCreateSeat(this.howitzer, 0).func_184188_bt().get(0);
                        if (entity instanceof EntityHans && ((EntityHans)entity).func_184614_ca().func_190926_b()) {
                            ItemStack shell = IIContent.itemAmmoLightArtillery.getBulletWithParams("core_brass", "canister", "hmx", "tracer_powder");
                            NBTTagCompound tag = new NBTTagCompound();
                            tag.func_74768_a("colour", 0xFF0000);
                            entity.func_184201_a(EntityEquipmentSlot.MAINHAND, shell);
                        } else if (this.howitzer.reloadProgress == 0.0f && !this.howitzer.reloadKeyPress) {
                            this.howitzer.reloadKeyPress = true;
                        }
                    } else {
                        boolean bl2 = this.howitzer.fireKeyPress = this.howitzer.shootingProgress == 0.0f && !this.howitzer.fireKeyPress;
                    }
                    if (this.howitzer.fireKeyPress) {
                        this.howitzer.func_82194_d().func_72872_a(EntityItem.class, this.howitzer.func_174813_aQ()).forEach(Entity::func_70106_y);
                    }
                }
            }
        } else if (this.target.isPresent()) {
            Entity entity = this.target.get();
            this.hans.func_70625_a(entity, 10.0f, 10.0f);
            float[] yp = this.getAnglePrediction(positionVector.func_72441_c(0.0, 1.0, 0.0), IIUtils.getEntityCenter(entity), new Vec3d(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y));
            if (!this.isAimedAt(yp[0], yp[1])) {
                float y = MathHelper.func_76142_g((float)(360.0f + yp[0] - this.howitzer.field_70177_z));
                this.howitzer.turnRight = Math.signum(y) > 0.0f;
                boolean bl = this.howitzer.turnLeft = Math.signum(y) < 0.0f;
                if (Math.abs(y) < 5.0f) {
                    this.howitzer.turnRight = false;
                    this.howitzer.turnLeft = false;
                    this.howitzer.field_70177_z = MathHelper.func_76142_g((float)yp[0]);
                    this.howitzer.field_70126_B = MathHelper.func_76142_g((float)yp[0]);
                }
            } else {
                this.howitzer.turnRight = false;
                this.howitzer.turnLeft = false;
            }
        } else {
            this.howitzer.turnRight = false;
            this.howitzer.turnLeft = false;
        }
    }

    public boolean isAimedAt(float yaw, float pitch) {
        return pitch == this.howitzer.gunPitch && MathHelper.func_76142_g((float)yaw) == this.howitzer.field_70177_z;
    }

    public float[] getAnglePrediction(Vec3d posTurret, Vec3d posTarget, Vec3d motion) {
        Vec3d dist = posTurret.func_178788_d(posTarget.func_178787_e(motion));
        Vec3d norm = dist.func_72432_b();
        float yy = (float)(Math.atan2(norm.field_72450_a, norm.field_72449_c) * 180.0 / 3.1415927410125732);
        float pp = Math.round(IIUtils.calculateBallisticAngle(new Vec3d(dist.field_72450_a, 0.0, dist.field_72449_c).func_72438_d(Vec3d.field_186680_a), dist.field_72448_b, IIContent.itemAmmoLightArtillery.getDefaultVelocity(), 0.478125f, 0.99f, 0.01));
        return new float[]{MathHelper.func_76142_g((float)(180.0f - yy)), 90.0f - pp};
    }
}

