/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.hans.tasks;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.gate_multiblock.tileentity.TileEntityGateBase;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.hans.HansPathNavigate;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.AIHansBase;

public class AIHansOpenDoor
extends AIHansBase {
    public static final ArrayList<IDoorHandler> HANDLERS = new ArrayList();
    protected BlockPos doorPosition = BlockPos.field_177992_a;
    protected IDoorHandler doorHandler;
    boolean hasStoppedDoorInteraction;
    float entityPositionX;
    float entityPositionZ;
    boolean closeDoor;
    int closeDoorTemporisation;

    public AIHansOpenDoor(EntityHans hans, boolean shouldClose) {
        super(hans);
        this.closeDoor = shouldClose;
    }

    public boolean func_75250_a() {
        if (!this.hans.field_70123_F) {
            return false;
        }
        HansPathNavigate navigator = this.hans.getNavigator();
        Path path = navigator.func_75505_d();
        if (path != null && !path.func_75879_b() && navigator.func_179686_g()) {
            for (int i = 0; i < Math.min(path.func_75873_e() + 2, path.func_75874_d()); ++i) {
                PathPoint pathpoint = path.func_75877_a(i);
                this.doorPosition = new BlockPos(pathpoint.field_75839_a, pathpoint.field_75837_b + 1, pathpoint.field_75838_c);
                if (!(this.hans.func_70092_e(this.doorPosition.func_177958_n(), this.hans.field_70163_u, this.doorPosition.func_177952_p()) <= 2.25)) continue;
                this.doorHandler = this.getDoorHandler(this.doorPosition);
                if (this.doorHandler == null) continue;
                return true;
            }
            this.doorPosition = new BlockPos((Entity)this.hans);
            this.doorHandler = this.getDoorHandler(this.doorPosition);
            Optional<AIHansOpenDoor> otherTask = this.hans.field_70170_p.func_175647_a(EntityHans.class, new AxisAlignedBB(this.doorPosition).func_186662_g(4.0), input -> input != this.hans && input.func_70089_S()).stream().map(EntityHans::getDoorTask).filter(Objects::nonNull).filter(ai -> ai.doorPosition == this.doorPosition).findFirst();
            return !otherTask.isPresent() && this.doorHandler != null;
        }
        this.doorPosition = BlockPos.field_177992_a;
        return false;
    }

    public boolean func_75253_b() {
        return this.closeDoor && this.closeDoorTemporisation > 0 && !this.hasStoppedDoorInteraction;
    }

    public void func_75249_e() {
        this.closeDoorTemporisation = this.doorHandler.getTimeForDoor();
        this.doorHandler.toggleDoor(this.hans, this.doorPosition, true, this.hans.field_70170_p);
    }

    public void func_75246_d() {
        float zz;
        --this.closeDoorTemporisation;
        float xx = (float)((double)((float)this.doorPosition.func_177958_n() + 0.5f) - this.hans.field_70165_t);
        float dist = this.entityPositionX * xx + this.entityPositionZ * (zz = (float)((double)((float)this.doorPosition.func_177952_p() + 0.5f) - this.hans.field_70161_v));
        if (dist < 0.0f) {
            this.hasStoppedDoorInteraction = true;
        }
    }

    public void func_75251_c() {
        if (this.closeDoor) {
            this.doorHandler.toggleDoor(this.hans, this.doorPosition, false, this.hans.field_70170_p);
        }
    }

    private IDoorHandler getDoorHandler(BlockPos pos) {
        IBlockState state = this.hans.field_70170_p.func_180495_p(pos);
        TileEntity tile = this.hans.field_70170_p.func_175625_s(pos);
        return HANDLERS.stream().filter(iDoorHandler -> iDoorHandler.matchesType(state, tile)).findFirst().orElse(null);
    }

    @Override
    public void setRequiredAnimation() {
    }

    static {
        HANDLERS.add(new IDoorHandler(){

            @Override
            public boolean matchesType(IBlockState state, @Nullable TileEntity te) {
                return state.func_177230_c() instanceof BlockDoor && state.func_185904_a() == Material.field_151575_d;
            }

            @Override
            public void toggleDoor(EntityHans hans, BlockPos pos, boolean open, World world) {
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() instanceof BlockDoor) {
                    ((BlockDoor)state.func_177230_c()).func_176512_a(world, pos, open);
                }
            }

            @Override
            public boolean isDoorOpened(EntityHans hans, BlockPos pos, World world) {
                IBlockState state = world.func_180495_p(pos);
                return state.func_177230_c() instanceof BlockDoor ? ((Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue() : Boolean.valueOf(false).booleanValue();
            }

            @Override
            public int getTimeForDoor() {
                return 20;
            }
        });
        HANDLERS.add(new IDoorHandler(){

            @Override
            public boolean matchesType(IBlockState state, @Nullable TileEntity te) {
                return state.func_177230_c() instanceof BlockFenceGate;
            }

            @Override
            public void toggleDoor(EntityHans hans, BlockPos pos, boolean open, World world) {
                IBlockState state = world.func_180495_p(pos);
                if ((Boolean)state.func_177229_b((IProperty)BlockFenceGate.field_176466_a) == open) {
                    return;
                }
                boolean blockOpen = (Boolean)state.func_177229_b((IProperty)BlockFenceGate.field_176466_a);
                state = state.func_177226_a((IProperty)BlockFenceGate.field_176466_a, (Comparable)Boolean.valueOf(open));
                if (!blockOpen) {
                    EnumFacing enumfacing = EnumFacing.func_176733_a((double)hans.field_70177_z);
                    if (state.func_177229_b((IProperty)BlockFenceGate.field_185512_D) == enumfacing.func_176734_d()) {
                        state = state.func_177226_a((IProperty)BlockFenceGate.field_185512_D, (Comparable)enumfacing);
                    }
                }
                world.func_180501_a(pos, state, 10);
                world.func_180498_a(null, open ? 1008 : 1014, pos, 0);
            }

            @Override
            public boolean isDoorOpened(EntityHans hans, BlockPos pos, World world) {
                IBlockState state = world.func_180495_p(pos);
                return state.func_177230_c() instanceof BlockFenceGate ? ((Boolean)state.func_177229_b((IProperty)BlockFenceGate.field_176466_a)).booleanValue() : Boolean.valueOf(false).booleanValue();
            }

            @Override
            public int getTimeForDoor() {
                return 20;
            }
        });
        HANDLERS.add(new IDoorHandler(){

            @Override
            public boolean matchesType(IBlockState state, @Nullable TileEntity te) {
                return te instanceof TileEntityGateBase;
            }

            @Override
            public void toggleDoor(EntityHans hans, BlockPos pos, boolean open, World world) {
                TileEntityGateBase master;
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof TileEntityGateBase && (master = (TileEntityGateBase)((TileEntityGateBase)te).master()) != null) {
                    if (!world.field_72995_K) {
                        master.onAnimationChangeServer(open, 0);
                    } else {
                        master.onAnimationChangeClient(open, 0);
                    }
                }
            }

            @Override
            public boolean isDoorOpened(EntityHans hans, BlockPos pos, World world) {
                TileEntityGateBase master;
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof TileEntityGateBase && (master = (TileEntityGateBase)((TileEntityGateBase)te).master()) != null) {
                    return master.gate.getState();
                }
                return false;
            }

            @Override
            public int getTimeForDoor() {
                return 50;
            }
        });
    }

    public static interface IDoorHandler {
        public boolean matchesType(IBlockState var1, @Nullable TileEntity var2);

        public void toggleDoor(EntityHans var1, BlockPos var2, boolean var3, World var4);

        public boolean isDoorOpened(EntityHans var1, BlockPos var2, World var3);

        public int getTimeForDoor();
    }
}

