/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon.AIHansHandWeapon;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIGunBase;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler.AmmoHandler;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public abstract class AIHansAbstractGun
extends AIHansHandWeapon {
    protected final int burstTime;
    protected final ItemIIGunBase item;
    protected int rangedAttackTime;

    public AIHansAbstractGun(EntityHans hans, ItemIIGunBase item, float minAttackDistance, float maxAttackDistance, int burstTime) {
        super(hans, minAttackDistance, maxAttackDistance, 1.0);
        this.item = item;
        this.burstTime = burstTime;
        this.rangedAttackTime = -1;
    }

    @Override
    protected boolean hasAnyAmmo() {
        ItemStack weapon = this.getWeapon();
        return this.hans.hasAmmo || this.item.getAmmoHandler(weapon).canFire(weapon, EasyNBT.wrapNBT(weapon)) || (this.hans.hasAmmo = !this.item.findAmmo((Entity)this.hans, weapon).func_190926_b());
    }

    @Override
    protected boolean isValidWeapon() {
        return this.getWeapon().func_77973_b() == this.item;
    }

    @Override
    protected void executeTask() {
        assert (this.attackTarget != null);
        ItemStack stg = this.getWeapon();
        EasyNBT nbt = EasyNBT.wrapNBT(stg);
        AmmoHandler ammoHandler = this.item.getAmmoHandler(stg);
        boolean canFire = ammoHandler.canFire(this.getWeapon(), nbt);
        this.hans.func_184598_c(EnumHand.MAIN_HAND);
        if (!canFire) {
            nbt.withBoolean("shouldReload", true);
        }
        if (this.motionState == AIHansHandWeapon.MotionState.FALLBACK) {
            if (!ItemNBTHelper.getBoolean((ItemStack)stg, (String)"shouldReload")) {
                this.hans.func_184602_cy();
            }
            this.hans.func_70095_a(false);
            return;
        }
        this.lookOnTarget();
        if (this.rangedAttackTime < 0) {
            this.hans.func_184602_cy();
            ++this.rangedAttackTime;
        }
        if (canFire && this.aimingAtTarget) {
            if (this.rangedAttackTime < this.burstTime) {
                this.hans.hasAmmo = true;
                this.hans.func_70095_a(true);
                this.hans.field_70125_A = this.calculateBallisticAngle(ammoHandler.getNextAmmo(stg, nbt, false), this.attackTarget);
            } else {
                this.hans.func_184602_cy();
            }
            ++this.rangedAttackTime;
            if (this.rangedAttackTime >= this.burstTime) {
                this.rangedAttackTime = -((int)((double)(-this.burstTime) * 0.75));
            }
        } else {
            this.hans.func_184602_cy();
        }
    }

    @Override
    public void setRequiredAnimation() {
    }

    @Override
    protected float calculateBallisticAngle(ItemStack ammo, EntityLivingBase attackTarget) {
        IAmmo ammoType = (IAmmo)ammo.func_77973_b();
        return IIUtils.getDirectFireAngle(ammoType.getDefaultVelocity(), ammoType.getMass(ammo), this.hans.func_174791_d().func_72441_c(0.0, (double)this.hans.func_70047_e() - (double)0.1f, 0.0).func_178788_d(IIUtils.getEntityCenter((Entity)attackTarget)));
    }
}

