/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon.AIHansHandWeapon;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIAmmoGrenade;

public class AIHansGrenade
extends AIHansHandWeapon {
    private final int throwTime;
    private int rangedAttackTime = -1;

    public AIHansGrenade(EntityHans hans) {
        super(hans, 4.0f, 22.0f, 1.0);
        this.throwTime = 40;
    }

    @Override
    protected boolean hasAnyAmmo() {
        return this.hans.hasAmmo;
    }

    @Override
    protected boolean isValidWeapon() {
        return this.getWeapon().func_77973_b() instanceof ItemIIAmmoGrenade;
    }

    @Override
    protected boolean hasToSeeEnemy() {
        return false;
    }

    @Override
    protected void executeTask() {
        assert (this.attackTarget != null);
        ItemStack grenade = this.getWeapon();
        if (this.motionState == AIHansHandWeapon.MotionState.FALLBACK || this.motionState == AIHansHandWeapon.MotionState.COME_TOWARDS) {
            this.hans.func_70095_a(false);
            return;
        }
        this.hans.func_184598_c(EnumHand.MAIN_HAND);
        this.lookOnTarget();
        this.hans.field_70726_aT = this.hans.field_70125_A = -this.calculateBallisticAngle(grenade, this.attackTarget);
        if (this.rangedAttackTime < 0) {
            this.hans.func_184602_cy();
            ++this.rangedAttackTime;
        } else {
            ++this.rangedAttackTime;
            this.hans.func_184598_c(EnumHand.MAIN_HAND);
            if (this.rangedAttackTime >= this.throwTime) {
                IIContent.itemGrenade.func_77615_a(grenade, this.hans.field_70170_p, (EntityLivingBase)this.hans, IIContent.itemGrenade.func_77626_a(grenade) - this.rangedAttackTime);
                this.lookOnTarget();
                this.hans.field_70726_aT = this.hans.field_70125_A = -this.calculateBallisticAngle(grenade, this.attackTarget);
                this.rangedAttackTime = -10;
                Vec3d away = null;
                for (int tries = 0; away == null && tries < 10; ++tries) {
                    away = RandomPositionGenerator.func_75461_b((EntityCreature)this.hans, (int)40, (int)10, (Vec3d)this.attackTarget.func_174791_d());
                }
                if (away != null) {
                    this.hans.getNavigator().func_75492_a(away.field_72450_a, away.field_72448_b, away.field_72449_c, this.moveSpeed * 1.125);
                    this.hans.func_70031_b(true);
                    this.func_75251_c();
                    this.motionState = AIHansHandWeapon.MotionState.FALLBACK;
                }
            }
        }
    }

    @Override
    public void setRequiredAnimation() {
    }

    @Override
    protected float calculateBallisticAngle(ItemStack ammo, EntityLivingBase attackTarget) {
        Vec3d dist = this.hans.func_174791_d().func_72441_c(0.0, (double)this.hans.func_70047_e() - (double)0.1f, 0.0).func_178788_d(IIUtils.getEntityCenter((Entity)attackTarget));
        return IIUtils.calculateBallisticAngle(new Vec3d(dist.field_72450_a, 0.0, dist.field_72449_c).func_72438_d(Vec3d.field_186680_a), dist.field_72448_b, IIContent.itemGrenade.getDefaultVelocity(), 0.15f * IIContent.itemGrenade.getMass(ammo), 0.99f, 0.01);
    }
}

