/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.AIHansBase;

public abstract class AIHansHandWeapon
extends AIHansBase {
    @Nullable
    protected EntityLivingBase attackTarget;
    protected final float maxAttackDistance;
    protected final float minAttackDistance;
    protected final int safeAttackDistance;
    protected int minSeeTime;
    protected int rangedAttackTime = -1;
    protected int seeTime;
    protected final double moveSpeed;
    @Nonnull
    public MotionState motionState = MotionState.IN_POSITION;
    protected boolean canFire;
    protected boolean aimingAtTarget;

    protected AIHansHandWeapon(EntityHans hans, float minAttackDistance, float maxAttackDistance, double moveSpeed) {
        super(hans);
        this.moveSpeed = moveSpeed;
        this.minAttackDistance = minAttackDistance;
        this.maxAttackDistance = maxAttackDistance;
        this.safeAttackDistance = (int)MathHelper.func_151238_b((double)this.minAttackDistance, (double)this.maxAttackDistance, (double)0.65);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.hans.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        this.attackTarget = entitylivingbase;
        this.hans.hasAmmo = this.hasAnyAmmo();
        return this.isValidWeapon() && this.hans.hasAmmo;
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.hans.func_70095_a(false);
        if (this.motionState == MotionState.FALLBACK) {
            this.hans.func_70095_a(false);
        }
        this.attackTarget = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
        this.canFire = false;
        this.aimingAtTarget = false;
    }

    public final void func_75246_d() {
        super.func_75246_d();
        this.hans.hasAmmo = this.hasAnyAmmo();
        MotionState prevMotionState = this.motionState;
        this.motionState = this.getMotionState();
        if (this.motionState == MotionState.FALLBACK && this.motionState != prevMotionState) {
            int radius = 15;
            List hanses = this.hans.field_70170_p.func_175647_a(EntityHans.class, new AxisAlignedBB(new BlockPos(this.hans.field_70165_t, this.hans.field_70163_u, this.hans.field_70161_v)).func_72314_b((double)radius, (double)radius, (double)radius), input -> input != null && input != this.hans && input.func_96124_cp() == this.hans.func_96124_cp());
            for (EntityHans anotherHans : hanses) {
                if (anotherHans.func_70638_az() != null) continue;
                anotherHans.func_70624_b(this.hans.func_70638_az());
            }
            this.hans.func_184185_a(SoundEvents.field_187915_go, 1.0f, 1.0f);
        }
        if (this.attackTarget == null || this.attackTarget.field_70128_L || !this.hans.hasAmmo) {
            this.func_75251_c();
            return;
        }
        if (this.canFire) {
            this.executeTask();
        }
    }

    protected MotionState getMotionState() {
        EntityLivingBase enemy;
        List enemiesWayTooClose = this.hans.field_70170_p.func_175647_a(EntityLiving.class, this.hans.func_174813_aQ().func_186662_g((double)this.minAttackDistance), input -> input.func_70638_az() == this.hans);
        EntityLivingBase entityLivingBase = enemy = enemiesWayTooClose.size() > 0 ? (EntityLivingBase)enemiesWayTooClose.get(0) : this.attackTarget;
        if (enemy == null) {
            return MotionState.IN_POSITION;
        }
        double targetDist = this.hans.func_174791_d().func_72438_d(new Vec3d(enemy.field_70165_t, enemy.field_70163_u, enemy.field_70161_v));
        this.canFire = this.attackTarget != null && (!this.hasToSeeEnemy() || this.hans.func_70635_at().func_75522_a((Entity)this.attackTarget)) && this.canShootEntity(this.attackTarget);
        this.seeTime = this.canFire ? this.seeTime + 1 : 0;
        double d0 = this.attackTarget.field_70165_t - this.hans.field_70165_t;
        double d2 = this.attackTarget.field_70161_v - this.hans.field_70161_v;
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        boolean bl = this.aimingAtTarget = Math.abs(MathHelper.func_76142_g((float)this.hans.field_70759_as) - MathHelper.func_76142_g((float)f)) < 2.0f;
        if (targetDist <= (double)this.minAttackDistance || !this.hans.getNavigator().func_75500_f() && targetDist < (double)this.safeAttackDistance) {
            List enemies;
            Vec3d away;
            if (this.hans.getNavigator().func_75500_f() && (away = RandomPositionGenerator.func_75461_b((EntityCreature)this.hans, (int)this.safeAttackDistance, (int)0, (Vec3d)enemy.func_174791_d())) != null && (enemies = this.hans.field_70170_p.func_175647_a(EntityLiving.class, new AxisAlignedBB(new BlockPos(away)).func_186662_g((double)this.minAttackDistance), input -> input.func_70638_az() == this.hans)).size() == 0) {
                float v = enemies.stream().map(EntityLivingBase::func_70689_ay).max(Float::compareTo).orElse(Float.valueOf(1.0f)).floatValue() * 1.5f;
                this.hans.getNavigator().func_75492_a(away.field_72450_a, away.field_72448_b, away.field_72449_c, v);
                this.hans.func_70031_b(true);
                this.func_75251_c();
                return MotionState.FALLBACK;
            }
            this.hans.func_70031_b(true);
            return MotionState.FALLBACK;
        }
        if (targetDist >= (double)this.minAttackDistance && targetDist <= (double)this.maxAttackDistance && this.seeTime > 0) {
            this.hans.func_70031_b(false);
            this.hans.getNavigator().func_75499_g();
            return this.seeTime > this.minSeeTime ? MotionState.SET_UP : MotionState.IN_POSITION;
        }
        this.hans.func_70031_b(false);
        Vec3d towards = RandomPositionGenerator.func_75464_a((EntityCreature)this.hans, (int)((int)Math.abs((double)this.minAttackDistance - targetDist)), (int)10, (Vec3d)this.attackTarget.func_174791_d());
        if (towards != null) {
            this.hans.getNavigator().func_75492_a(towards.field_72450_a, towards.field_72448_b, towards.field_72449_c, this.moveSpeed);
        }
        this.hans.getNavigator().func_75497_a((Entity)this.attackTarget, this.moveSpeed);
        return MotionState.COME_TOWARDS;
    }

    protected void lookOnTarget() {
        assert (this.attackTarget != null);
        this.hans.func_70671_ap().func_75651_a((Entity)this.attackTarget, 40.0f, (float)this.hans.func_70646_bf());
    }

    protected abstract void executeTask();

    protected abstract float calculateBallisticAngle(ItemStack var1, EntityLivingBase var2);

    protected ItemStack getWeapon() {
        return this.hans.func_184582_a(EntityEquipmentSlot.MAINHAND);
    }

    protected abstract boolean hasAnyAmmo();

    protected abstract boolean isValidWeapon();

    protected boolean hasToSeeEnemy() {
        return true;
    }

    protected static enum MotionState {
        COME_TOWARDS,
        IN_POSITION,
        SET_UP,
        FALLBACK;

    }
}

