/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.tactile;

import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.common.entity.tactile.TactileHandler;

public class EntityAMTTactile
extends Entity {
    private static final AxisAlignedBB EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private TactileHandler handler;
    @Nullable
    private EntityAMTTactile parent;
    public String name;
    public Vec3d offset;
    public Vec3d translation = Vec3d.field_186680_a;
    public Vec3d rotation = Vec3d.field_186680_a;
    public Vec3d scale = Vec3d.field_186680_a;
    public boolean visibility = true;
    public AxisAlignedBB aabb;
    private float rotationRoll = 0.0f;

    public EntityAMTTactile(World worldIn) {
        super(worldIn);
    }

    public EntityAMTTactile(TactileHandler handler, String name, Vec3d offset, AxisAlignedBB aabb) {
        super(handler.getWorld());
        this.name = name;
        this.handler = handler;
        this.offset = offset;
        this.aabb = aabb;
        this.field_70131_O = (float)(aabb.field_72337_e - aabb.field_72338_b);
        this.field_70130_N = (float)Math.max(aabb.field_72336_d - aabb.field_72340_a, aabb.field_72334_f - aabb.field_72339_c);
    }

    public EntityAMTTactile(TactileHandler handler, String name, Vec3d offset, double radius, double height) {
        this(handler, name, offset, new AxisAlignedBB(-radius, -height, -radius, radius, height, radius));
    }

    public EntityAMTTactile(TactileHandler handler, String name, Vec3d offset, double radius) {
        this(handler, name, offset, radius, radius);
    }

    public void setParent(@Nullable EntityAMTTactile parent) {
        this.parent = parent;
    }

    protected void func_70088_a() {
    }

    public void func_70030_z() {
        if (this.handler == null || !this.handler.getEntities().contains((Object)this)) {
            this.func_70106_y();
            return;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.parent == null) {
            BlockPos handlerPos = this.handler.getPos();
            this.field_70165_t = (double)handlerPos.func_177958_n() + this.offset.field_72450_a + this.translation.field_72450_a;
            this.field_70163_u = (double)handlerPos.func_177956_o() + this.offset.field_72448_b + this.translation.field_72448_b;
            this.field_70161_v = (double)handlerPos.func_177952_p() - 0.5 + this.offset.field_72449_c + this.translation.field_72449_c;
            this.field_70125_A = (float)this.rotation.field_72450_a;
            this.field_70177_z = (float)this.rotation.field_72448_b;
            this.rotationRoll = (float)this.rotation.field_72449_c;
        } else {
            Vec3d relativeOffset = this.offset.func_178788_d(this.parent.offset);
            this.field_70177_z = (float)((double)this.parent.field_70177_z + this.rotation.field_72448_b);
            this.field_70125_A = (float)((double)this.parent.field_70125_A + this.rotation.field_72450_a);
            this.rotationRoll = (float)((double)this.parent.rotationRoll + this.rotation.field_72449_c);
            Vec3d angle = new Matrix4().setIdentity().rotate(Math.toRadians(this.field_70177_z), 0.0, 1.0, 0.0).rotate(Math.toRadians(-this.rotationRoll), 0.0, 0.0, 1.0).rotate(Math.toRadians(-this.field_70125_A), 1.0, 0.0, 0.0).apply(relativeOffset.func_178787_e(this.translation));
            this.field_70165_t = this.parent.field_70165_t + angle.field_72450_a;
            this.field_70163_u = this.parent.field_70163_u + angle.field_72448_b;
            this.field_70161_v = this.parent.field_70161_v + angle.field_72449_c;
        }
        this.field_70159_w = this.field_70165_t - this.field_70169_q;
        this.field_70181_x = this.field_70163_u - this.field_70167_r;
        this.field_70179_y = this.field_70161_v - this.field_70166_s;
        if (!this.visibility) {
            this.func_174826_a(EMPTY);
            return;
        }
        AxisAlignedBB newAABB = this.aabb.func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.scale != Vec3d.field_186680_a) {
            double xLength = newAABB.field_72340_a + newAABB.field_72336_d;
            double yLength = newAABB.field_72338_b + newAABB.field_72337_e;
            double xzScale = (this.scale.field_72450_a + this.scale.field_72449_c - 2.0) / 2.0;
            newAABB.func_72314_b(xLength * xzScale, yLength * xzScale, xLength * xzScale);
        }
        this.func_174826_a(newAABB);
        this.field_70170_p.func_72872_a(EntityLivingBase.class, newAABB).forEach(this::func_70108_f);
    }

    public boolean func_70067_L() {
        return this.visibility;
    }

    public void func_70108_f(Entity entity) {
        if (!(entity instanceof EntityAMTTactile)) {
            entity.func_70091_d(MoverType.PISTON, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.handler.onCollide(this, entity);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return this.handler.onAttacked(this, source, amount);
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return this.func_174813_aQ();
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return this.handler.onInteract(this, player, hand);
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        super.func_70012_b(x, y, z, yaw, pitch);
        if (this.aabb != null) {
            this.func_174826_a(this.aabb.func_72317_d(x, y, z));
        }
    }

    public boolean func_90999_ad() {
        return false;
    }

    public float func_70079_am() {
        return this.field_70177_z;
    }

    public void defaultizeAnimation() {
        this.rotation = this.scale = Vec3d.field_186680_a;
        this.translation = this.scale;
        this.visibility = true;
    }
}

