/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.tactile;

import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimation;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationCollisionMap;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIModelHeader;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.entity.tactile.EntityAMTTactile;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.MultiblockStuctureBase;

public class TactileHandler {
    private static HashMap<ResLoc, IIModelHeader> HEADERS = new HashMap();
    private static HashMap<ResLoc, IIAnimation> ANIMATIONS = new HashMap();
    private final ResLoc aabbLoc;
    private ResLoc headerLoc;
    private final ITactileListener listener;
    private boolean initialized = false;
    private IIModelHeader header;
    private final ArrayList<EntityAMTTactile> entities;
    private final HashMap<ResLoc, IIAnimationCollisionMap> animations;
    private Vec3d globalOffset = Vec3d.field_186680_a;

    public TactileHandler(ResLoc aabbLoc, ITactileListener listener) {
        this.aabbLoc = aabbLoc;
        this.listener = listener;
        this.entities = new ArrayList();
        this.animations = new HashMap();
    }

    public TactileHandler(MultiblockStuctureBase<?> multiblock, ITactileListener listener) {
        this.aabbLoc = multiblock.getAABBFileLocation();
        this.listener = listener;
        this.entities = new ArrayList();
        this.animations = new HashMap();
    }

    private boolean init() {
        JsonObject tactile;
        if (!IIConfigHandler.IIConfig.Graphics.tactileAMT) {
            return false;
        }
        if (this.aabbLoc == null) {
            return false;
        }
        BlockPos mainPos = this.getPos();
        JsonObject jsonObject = IIAnimationLoader.readServerFileToJson(this.aabbLoc);
        if (jsonObject.size() == 0) {
            return false;
        }
        Map<String, AxisAlignedBB> allBounds = jsonObject.get("bounds").getAsJsonObject().entrySet().stream().filter(e -> e.getValue() instanceof JsonArray).map(e -> {
            JsonArray array = ((JsonElement)e.getValue()).getAsJsonArray();
            return new Tuple(e.getKey(), (Object)this.getAxisAlignedBB(array));
        }).collect(Collectors.toMap(Tuple::func_76341_a, Tuple::func_76340_b));
        if (!jsonObject.has("tactile")) {
            return false;
        }
        if (jsonObject.has("tactile_offset")) {
            JsonArray array = jsonObject.get("tactile_offset").getAsJsonArray();
            this.globalOffset = new Vec3d(array.get(0).getAsDouble(), array.get(1).getAsDouble(), array.get(2).getAsDouble());
        }
        if ((tactile = jsonObject.get("tactile").getAsJsonObject()).has("_schema")) {
            this.headerLoc = ResLoc.of(new ResourceLocation(tactile.remove("_schema").getAsString()));
        }
        if (this.headerLoc == null) {
            return false;
        }
        this.header = HEADERS.computeIfAbsent(this.headerLoc, IIAnimationLoader::loadHeaderServer);
        ArrayList<EntityAMTTactile> tempEntities = this.parseTactiles(tactile, allBounds);
        this.processTactiles(tempEntities, mainPos);
        this.header.applyHierarchy(this.entities);
        this.entities.forEach(e -> e.func_70107_b(mainPos.func_177958_n(), mainPos.func_177956_o(), mainPos.func_177952_p()));
        this.entities.forEach(arg_0 -> ((World)this.getWorld()).func_72838_d(arg_0));
        return true;
    }

    @Nonnull
    private ArrayList<EntityAMTTactile> parseTactiles(JsonObject tactile, Map<String, AxisAlignedBB> allBounds) {
        ArrayList<EntityAMTTactile> tempEntities = new ArrayList<EntityAMTTactile>();
        for (Map.Entry entries : tactile.entrySet()) {
            if (!((JsonElement)entries.getValue()).isJsonArray()) continue;
            JsonArray array = ((JsonElement)entries.getValue()).getAsJsonArray();
            for (JsonElement box : array) {
                if (!box.isJsonObject()) continue;
                JsonObject boxObject = box.getAsJsonObject();
                Vec3d offset = Vec3d.field_186680_a;
                AxisAlignedBB aabb = new AxisAlignedBB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5);
                if (boxObject.has("offset")) {
                    JsonArray offsetArray = boxObject.get("offset").getAsJsonArray();
                    offset = new Vec3d(offsetArray.get(0).getAsDouble(), offsetArray.get(1).getAsDouble(), offsetArray.get(2).getAsDouble()).func_186678_a(0.0625);
                }
                if (boxObject.has("type")) {
                    aabb = allBounds.getOrDefault(boxObject.get("type").getAsString(), aabb);
                } else if (boxObject.has("bounds")) {
                    aabb = this.getAxisAlignedBB(boxObject.get("bounds").getAsJsonArray());
                }
                tempEntities.add(new EntityAMTTactile(this, (String)entries.getKey(), this.processOffset(this.header, (String)entries.getKey(), offset), aabb));
            }
        }
        return tempEntities;
    }

    private Vec3d processOffset(IIModelHeader header, String key, Vec3d offset) {
        Vec3d total = header.getOffset(key).func_178787_e(offset).func_178787_e(this.globalOffset).func_72441_c(-1.0, 0.0, -1.5);
        boolean mirrored = this.listener.getIsTactileMirrored();
        total = new Vec3d(mirrored ? total.field_72450_a - 1.0 : -total.field_72450_a, total.field_72448_b, -total.field_72449_c);
        EnumFacing facing = this.listener.getTactileFacing();
        Vec3d apply = new Matrix4(facing).apply(total);
        switch (facing) {
            case SOUTH: {
                apply = apply.func_72441_c(-1.0, 0.0, 0.0);
                break;
            }
            case EAST: {
                apply = apply.func_72441_c(-0.5, 0.0, 0.5);
                break;
            }
            case WEST: {
                apply = apply.func_72441_c(-0.5, 0.0, -0.5);
            }
        }
        return apply;
    }

    private void processTactiles(ArrayList<EntityAMTTactile> tempEntities, BlockPos mainPos) {
        while (!tempEntities.isEmpty()) {
            EntityAMTTactile amt = tempEntities.remove(0);
            List matching = tempEntities.stream().filter(e -> e.name.equals(amt.name)).collect(Collectors.toList());
            if (matching.isEmpty()) {
                this.entities.add(amt);
                continue;
            }
            EntityAMTTactile parent = new EntityAMTTactile(this, amt.name, this.processOffset(this.header, amt.name, Vec3d.field_186680_a), new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
            this.entities.add(parent);
            matching.add(0, amt);
            for (int i = 0; i < matching.size(); ++i) {
                ((EntityAMTTactile)((Object)matching.get((int)i))).name = ((EntityAMTTactile)((Object)matching.get((int)i))).name + "_child" + i;
                ((EntityAMTTactile)((Object)matching.get(i))).setParent(parent);
                ((EntityAMTTactile)((Object)matching.get(i))).func_70107_b(mainPos.func_177958_n(), mainPos.func_177956_o(), mainPos.func_177952_p());
                this.getWorld().func_72838_d((Entity)matching.get(i));
            }
            tempEntities.removeAll(matching);
            this.entities.addAll(matching);
        }
    }

    @Nonnull
    private AxisAlignedBB getAxisAlignedBB(JsonArray array) {
        AxisAlignedBB aabb = new AxisAlignedBB(array.get(0).getAsDouble() * 0.0625, array.get(1).getAsDouble() * 0.0625, array.get(2).getAsDouble() * 0.0625, array.get(3).getAsDouble() * 0.0625, array.get(4).getAsDouble() * 0.0625, array.get(5).getAsDouble() * 0.0625);
        if (this.listener.getIsTactileMirrored()) {
            double xLength = Math.abs(aabb.field_72336_d - aabb.field_72340_a);
            aabb = new AxisAlignedBB(-aabb.field_72340_a + 2.0, aabb.field_72338_b, aabb.field_72339_c, -aabb.field_72336_d + 2.0, aabb.field_72337_e, aabb.field_72334_f);
        }
        Matrix4 mat = new Matrix4(this.listener.getTactileFacing());
        Vec3d vMin = mat.apply(new Vec3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c));
        Vec3d vMax = mat.apply(new Vec3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f));
        return new AxisAlignedBB(vMin.field_72450_a, vMin.field_72448_b, vMin.field_72449_c, vMax.field_72450_a, vMax.field_72448_b, vMax.field_72449_c);
    }

    public void defaultize() {
        if (!this.initialized && !(this.initialized = this.init())) {
            return;
        }
        this.entities.forEach(EntityAMTTactile::defaultizeAnimation);
    }

    public void update(@Nullable ResLoc animation, float time) {
        if (!this.initialized && !(this.initialized = this.init())) {
            return;
        }
        if (animation == null) {
            return;
        }
        IIAnimationCollisionMap anim = !this.animations.containsKey((Object)animation) ? this.loadAnimation(animation) : this.animations.get((Object)animation);
        if (anim == null) {
            return;
        }
        anim.apply(time);
    }

    private IIAnimationCollisionMap loadAnimation(ResLoc res) {
        IIAnimation anim = ANIMATIONS.get((Object)res);
        if (anim == null) {
            IIAnimation animation = IIAnimationLoader.loadAnimationServer(res);
            ANIMATIONS.put(res, animation);
        }
        IIAnimationCollisionMap mapped = null;
        if (anim != null) {
            mapped = IIAnimationCollisionMap.create(this.entities, anim, this.listener.getTactileFacing(), this.listener.getIsTactileMirrored());
            this.animations.put(res, mapped);
        }
        return mapped;
    }

    public void forceReload() {
        this.initialized = false;
        this.entities.forEach(Entity::func_70106_y);
        this.entities.clear();
        this.animations.clear();
    }

    public World getWorld() {
        return this.listener.getTactileWorld();
    }

    public BlockPos getPos() {
        return this.listener.getTactilePos();
    }

    public boolean onAttacked(EntityAMTTactile tactile, DamageSource source, float amount) {
        return this.listener.onTactileDamage(tactile, source, amount);
    }

    public boolean onInteract(EntityAMTTactile tactile, EntityPlayer player, EnumHand hand) {
        return this.listener.onTactileInteract(tactile, player, hand);
    }

    public boolean onCollide(EntityAMTTactile tactile, Entity entity) {
        return this.listener.onTactileCollide(tactile, entity);
    }

    public ArrayList<EntityAMTTactile> getEntities() {
        return this.entities;
    }

    public static interface ITactileListener {
        @Nullable
        public TactileHandler getTactileHandler();

        public World getTactileWorld();

        public BlockPos getTactilePos();

        public EnumFacing getTactileFacing();

        public boolean getIsTactileMirrored();

        default public boolean onTactileInteract(EntityAMTTactile tactile, EntityPlayer player, EnumHand hand) {
            return false;
        }

        default public boolean onTactileDamage(EntityAMTTactile tactile, DamageSource source, float amount) {
            return false;
        }

        default public boolean onTactileCollide(EntityAMTTactile tactile, Entity entity) {
            return false;
        }
    }
}

