/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.vehicle;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityFlyHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoUtils;
import pl.pabilo8.immersiveintelligence.api.utils.IEntitySpecialRepairable;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IVehicleMultiPart;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.entity.EntityEmplacementWeapon;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.vehicle.EntityVehiclePart;
import pl.pabilo8.immersiveintelligence.common.entity.vehicle.VehicleDurability;
import pl.pabilo8.immersiveintelligence.common.entity.vehicle.drone.AIDroneTarget;
import pl.pabilo8.immersiveintelligence.common.util.entity.IIIEntity;

public class EntityDrone
extends EntityFlying
implements IIIEntity<EntityDrone>,
IVehicleMultiPart,
IEntitySpecialRepairable {
    private final EntityVehiclePart[] partArray;
    private EntityVehiclePart partMain;
    private EntityVehiclePart partTankRight1;
    private EntityVehiclePart partTankRight2;
    private EntityVehiclePart partTankLeft1;
    private EntityVehiclePart partTankLeft2;
    private EntityVehiclePart partEngine;
    private EntityVehiclePart partRotorFrontRight;
    private EntityVehiclePart partRotorFrontLeft;
    private EntityVehiclePart partRotorBackRight;
    private EntityVehiclePart partRotorBackLeft;
    private EntityVehiclePart exhaust1;
    private EntityVehiclePart exhaust2;
    @IIIEntity.AutoSerialized
    private static VehicleDurability durabilityMain;
    @IIIEntity.AutoSerialized
    private static VehicleDurability durabilityTankLeft;
    @IIIEntity.AutoSerialized
    private static VehicleDurability durabilityTankRight;
    @IIIEntity.AutoSerialized
    private static VehicleDurability durabilityEngine;
    @IIIEntity.AutoSerialized
    private static VehicleDurability[] durabilityRotors;

    public EntityDrone(World world) {
        super(world);
        this.func_70105_a(4.0f, 2.5f);
        durabilityMain = new VehicleDurability(100, 4);
        durabilityTankLeft = new VehicleDurability(45, 6);
        durabilityTankRight = new VehicleDurability(45, 6);
        durabilityEngine = new VehicleDurability(40, 2);
        for (int i = 0; i < durabilityRotors.length; ++i) {
            EntityDrone.durabilityRotors[i] = new VehicleDurability(20, 24);
        }
        this.partMain = new EntityVehiclePart(this, "main", Vec3d.field_186680_a, 0.65, 0.4).setHitbox(durabilityMain);
        this.partArray = new EntityVehiclePart[]{this.partMain, this.partEngine = new EntityVehiclePart(this, "engine", new Vec3d(0.25, 1.0, 0.0), 0.65, 0.25).setHitbox(durabilityEngine), this.partTankRight1 = new EntityVehiclePart((IVehicleMultiPart)this, "fuel_tank_r1", new Vec3d(-0.45, 0.3125, 0.65), 0.45).setHitbox(durabilityTankRight), this.partTankRight2 = new EntityVehiclePart((IVehicleMultiPart)this, "fuel_tank_r2", new Vec3d(0.65, 0.3125, 0.65), 0.45).setHitbox(durabilityTankRight), this.partTankLeft1 = new EntityVehiclePart((IVehicleMultiPart)this, "fuel_tank_l1", new Vec3d(-0.45, 0.3125, -0.65), 0.45).setHitbox(durabilityTankLeft), this.partTankLeft2 = new EntityVehiclePart((IVehicleMultiPart)this, "fuel_tank_l2", new Vec3d(0.65, 0.3125, -0.65), 0.45).setHitbox(durabilityTankLeft), this.partRotorFrontRight = new EntityVehiclePart(this, "rotor_fr", new Vec3d(1.8, 1.125, 1.7), 0.35, 0.4).setHitbox(durabilityRotors[0]), this.partRotorFrontLeft = new EntityVehiclePart(this, "rotor_fl", new Vec3d(1.8, 1.125, -1.7), 0.35, 0.4).setHitbox(durabilityRotors[1]), this.partRotorBackRight = new EntityVehiclePart(this, "rotor_br", new Vec3d(-1.625, 1.125, 1.7), 0.35, 0.4).setHitbox(durabilityRotors[2]), this.partRotorBackLeft = new EntityVehiclePart(this, "rotor_bl", new Vec3d(-1.625, 1.125, -1.7), 0.35, 0.4).setHitbox(durabilityRotors[3]), this.exhaust1 = new EntityVehiclePart((IVehicleMultiPart)this, "exhaust1", new Vec3d(-0.125, 1.85, -0.8), 0.25), this.exhaust2 = new EntityVehiclePart((IVehicleMultiPart)this, "exhaust2", new Vec3d(0.375, 1.85, 0.8), 0.25)};
    }

    public void func_70088_a() {
        super.func_70088_a();
        IIIEntity.super.entityInit();
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIDroneTarget<EntityLiving>(this, EntityLiving.class, input -> input.func_70089_S() && (input instanceof IMob || input.func_70638_az() == this)){

            @Override
            protected AxisAlignedBB getTargetableArea(double targetDistance) {
                return this.drone.func_174813_aQ().func_72314_b(targetDistance, targetDistance * (double)0.66f, targetDistance);
            }
        });
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AIDroneTarget<EntityLivingBase>(this, EntityLivingBase.class, input -> input != null && this.isValidTarget((Entity)input)){

            @Override
            protected AxisAlignedBB getTargetableArea(double targetDistance) {
                return this.drone.func_174813_aQ().func_72314_b(targetDistance, targetDistance * (double)0.66f, targetDistance);
            }
        });
    }

    public boolean isValidTarget(Entity entity) {
        return entity instanceof IMob || (entity instanceof EntityPlayer || entity instanceof EntityHans || entity instanceof EntityEmplacementWeapon || entity instanceof EntityIronGolem) && entity.func_96124_cp() != this.func_96124_cp();
    }

    public EntityMoveHelper func_70605_aq() {
        return new EntityFlyHelper((EntityLiving)this);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(160.0);
    }

    public void func_70030_z() {
        AxisAlignedBB target;
        super.func_70030_z();
        this.updateParts((Entity)this);
        List mobs = this.field_70170_p.func_72872_a(EntityMob.class, this.func_174813_aQ().func_186662_g(30.0));
        if (!mobs.isEmpty() && !this.field_70765_h.func_75640_a()) {
            EntityMob mob = (EntityMob)mobs.get(0);
            this.func_70671_ap().func_75651_a((Entity)mob, 5.0f, 5.0f);
            this.field_70765_h.func_75642_a(mob.field_70165_t, mob.field_70163_u + 15.0, mob.field_70161_v, 5.0);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 10 == 0 && !this.field_70170_p.func_72872_a(EntityMob.class, target = this.func_174813_aQ().func_72317_d(0.0, (double)(-this.field_70131_O - 1.0f), 0.0).func_186662_g(1.0).func_72321_a(0.0, -40.0, 0.0)).isEmpty()) {
            this.field_70170_p.func_72838_d((Entity)AmmoUtils.createBullet(this.field_70170_p, IIContent.itemAmmoMortar.getBulletWithParams("core_brass", "canister", "tnt"), this.func_174791_d().func_178786_a(0.0, 1.5, 0.0), new Vec3d(0.0, 1.0, 0.0), 0.0f));
        }
        if (this.field_70170_p.field_72995_K) {
            Vec3d smokeDir = this.func_174806_f(0.0f, this.field_70177_z).func_186678_a(-0.25);
            this.spawnExhaustParticle(this.exhaust1.func_174791_d(), smokeDir);
            this.spawnExhaustParticle(this.exhaust2.func_174791_d(), smokeDir);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnExhaustParticle(Vec3d position, Vec3d smokeDir) {
        float exhaustRandom = (float)(this.field_70170_p.func_82737_E() % 20L) / 20.0f * 0.2f;
        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, position.field_72450_a, position.field_72448_b, position.field_72449_c, 0.0 + smokeDir.field_72450_a, 0.046875, smokeDir.field_72449_c, new int[0]);
    }

    public float func_70047_e() {
        return -0.55f;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_85033_bc() {
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    @Override
    @Nullable
    public EntityVehiclePart[] getParts() {
        return this.partArray;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return NonNullList.func_191196_a();
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }

    @Override
    public boolean canRepair() {
        return false;
    }

    @Override
    public boolean repair(int repairPoints) {
        return false;
    }

    @Override
    public int getRepairCost() {
        return 1;
    }

    @Override
    public boolean onInteractWithPart(EntityVehiclePart part, EntityPlayer player, EnumHand hand) {
        return false;
    }

    @Override
    public String[] getOverlayTextOnPart(EntityVehiclePart part, EntityPlayer player, RayTraceResult mop) {
        return new String[0];
    }

    @Override
    public void getSeatRidingPosition(int seatID, Entity passenger) {
    }

    @Override
    public void getSeatRidingAngle(int seatID, Entity passenger) {
    }

    @Override
    public boolean shouldSeatPassengerSit(int seatID, Entity passenger) {
        return false;
    }

    @Override
    public void onSeatDismount(int seatID, Entity passenger) {
    }

    @Nonnull
    public World func_82194_d() {
        return this.func_130014_f_();
    }

    static {
        durabilityRotors = new VehicleDurability[4];
    }
}

