/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.vehicle;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.api.utils.tools.IAdvancedTextOverlay;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IVehicleMultiPart;
import pl.pabilo8.immersiveintelligence.common.entity.vehicle.EntityVehicleSeat;
import pl.pabilo8.immersiveintelligence.common.entity.vehicle.VehicleDurability;

public class EntityVehiclePart
extends MultiPartEntityPart
implements IAdvancedTextOverlay {
    public Vec3d offset;
    public AxisAlignedBB aabb;
    public IVehicleMultiPart parentExt;
    @Nullable
    public VehicleDurability hitbox;

    public EntityVehiclePart(IVehicleMultiPart parent, String partName, Vec3d offset, AxisAlignedBB aabb) {
        super((IEntityMultiPart)parent, partName, (float)aabb.func_72320_b(), (float)Math.abs(aabb.field_72337_e - aabb.field_72338_b));
        this.parentExt = parent;
        this.offset = offset;
        this.aabb = aabb;
    }

    public EntityVehiclePart(IVehicleMultiPart parent, String partName, Vec3d offset, double radius, double height) {
        this(parent, partName, offset, new AxisAlignedBB(-radius, -height, -radius, radius, height, radius));
    }

    public EntityVehiclePart(IVehicleMultiPart parent, String partName, Vec3d offset, double radius) {
        this(parent, partName, offset, radius, radius);
    }

    public EntityVehiclePart setHitbox(@Nonnull VehicleDurability hitbox) {
        this.hitbox = hitbox;
        return this;
    }

    public void func_70108_f(Entity entityIn) {
        if (!(entityIn instanceof EntityVehicleSeat) && entityIn != this.parentExt && Arrays.stream(this.parentExt.getParts()).noneMatch(entity -> entity == entityIn)) {
            super.func_70108_f(entityIn);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.hitbox != null) {
            this.hitbox.attackFrom(source, amount);
        }
        return false;
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return this.func_174813_aQ();
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return this.parentExt.onInteractWithPart(this, player, hand);
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop) {
        return this.parentExt.getOverlayTextOnPart(this, player, mop);
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        super.func_70012_b(x, y, z, yaw, pitch);
        this.func_174826_a(this.aabb.func_72317_d(x, y, z));
    }

    public boolean func_90999_ad() {
        return false;
    }
}

