/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.ammo;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmoComponent;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmoCore;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIAmmoCasing;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIISubItemsBase;

public abstract class ItemIIAmmoBase
extends ItemIISubItemsBase<AmmoParts>
implements IAmmo,
IEItemInterfaces.ITextureOverride {
    public final String NAME;
    @Nullable
    private final ItemIIAmmoCasing.Casings casing;

    public ItemIIAmmoBase(String name, @Nullable ItemIIAmmoCasing.Casings casing) {
        this("bullet_" + name.toLowerCase(), name, casing);
    }

    public ItemIIAmmoBase(String fullName, String name, @Nullable ItemIIAmmoCasing.Casings casing) {
        super(fullName, casing == null ? 64 : casing.getStackSize(), (Enum[])AmmoParts.values());
        this.NAME = name;
        this.casing = casing;
    }

    public void makeDefault(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core")) {
            ItemNBTHelper.setString((ItemStack)stack, (String)"core", (String)"core_brass");
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core_type")) {
            ItemNBTHelper.setString((ItemStack)stack, (String)"core_type", (String)this.getAllowedCoreTypes()[0].func_176610_l());
        }
        if (this.stackToSub(stack) == AmmoParts.BULLET && !ItemNBTHelper.hasKey((ItemStack)stack, (String)"fuse")) {
            ItemNBTHelper.setString((ItemStack)stack, (String)"fuse", (String)this.getAllowedFuseTypes()[0].func_176610_l());
        }
    }

    @Override
    public IAmmoCore getCore(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core")) {
            this.makeDefault(stack);
        }
        return AmmoRegistry.INSTANCE.getCore(ItemNBTHelper.getString((ItemStack)stack, (String)"core"));
    }

    @Override
    public AmmoRegistry.EnumCoreTypes getCoreType(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core_type")) {
            this.makeDefault(stack);
        }
        return AmmoRegistry.EnumCoreTypes.v(ItemNBTHelper.getString((ItemStack)stack, (String)"core_type"));
    }

    @Override
    public ItemStack getCasingStack(int amount) {
        return this.casing != null ? IIContent.itemAmmoCasing.getStack(this.casing, amount) : ItemStack.field_190927_a;
    }

    @Override
    public int getPaintColor(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"paint_color")) {
            return ItemNBTHelper.getInt((ItemStack)stack, (String)"paint_color");
        }
        return -1;
    }

    @Override
    public void registerSprites(TextureMap map) {
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/base"));
        for (AmmoRegistry.EnumCoreTypes coreType : this.getAllowedCoreTypes()) {
            ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/" + coreType.func_176610_l()));
        }
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/paint"));
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/core"));
    }

    @Override
    public IAmmoComponent[] getComponents(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"components")) {
            ArrayList<IAmmoComponent> arrayList = new ArrayList<IAmmoComponent>();
            NBTTagList components = (NBTTagList)ItemNBTHelper.getTag((ItemStack)stack).func_74781_a("components");
            for (int i = 0; i < components.func_74745_c(); ++i) {
                arrayList.add(AmmoRegistry.INSTANCE.getComponent(components.func_150307_f(i)));
            }
            return arrayList.toArray(new IAmmoComponent[0]);
        }
        return new IAmmoComponent[0];
    }

    @Override
    public NBTTagCompound[] getComponentsNBT(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"component_nbt")) {
            ArrayList<NBTTagCompound> arrayList = new ArrayList<NBTTagCompound>();
            NBTTagList components = (NBTTagList)ItemNBTHelper.getTag((ItemStack)stack).func_74781_a("component_nbt");
            for (int i = 0; i < components.func_74745_c(); ++i) {
                arrayList.add(components.func_150305_b(i));
            }
            return arrayList.toArray(new NBTTagCompound[0]);
        }
        return new NBTTagCompound[0];
    }

    @Override
    public void addComponents(ItemStack stack, IAmmoComponent component, NBTTagCompound componentNBT) {
        NBTTagList comps = ItemNBTHelper.getTag((ItemStack)stack).func_150295_c("components", 8);
        NBTTagList nbts = ItemNBTHelper.getTag((ItemStack)stack).func_150295_c("component_nbt", 10);
        comps.func_74742_a((NBTBase)new NBTTagString(component.getName()));
        nbts.func_74742_a((NBTBase)componentNBT.func_74737_b());
        ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("components", (NBTBase)comps);
        ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("component_nbt", (NBTBase)nbts);
    }

    @ParametersAreNonnullByDefault
    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        this.makeDefault(stack);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        switch ((AmmoParts)this.stackToSub(stack)) {
            case BULLET: {
                return I18n.func_135052_a((String)("item.immersiveintelligence." + this.NAME + ".bullet.name"), (Object[])new Object[0]);
            }
            case CORE: {
                return I18n.func_135052_a((String)("item.immersiveintelligence." + this.NAME + ".core.name"), (Object[])new Object[0]);
            }
        }
        return "DO NOT USE, MAY CRASH";
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomItemColours() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColourForIEItem(ItemStack stack, int pass) {
        switch ((AmmoParts)this.stackToSub(stack)) {
            case BULLET: {
                switch (pass) {
                    case 0: {
                        return -1;
                    }
                    case 1: {
                        return this.getCore(stack).getColour();
                    }
                    case 2: {
                        return this.getPaintColor(stack);
                    }
                }
            }
            case CORE: {
                return this.getCore(stack).getColour();
            }
        }
        return -1;
    }

    @Override
    public ItemStack getBulletWithParams(String core, String coreType, String ... components) {
        ItemStack stack = this.getStack(AmmoParts.BULLET);
        ItemNBTHelper.setString((ItemStack)stack, (String)"core", (String)core);
        ItemNBTHelper.setString((ItemStack)stack, (String)"core_type", (String)coreType);
        NBTTagList tagList = new NBTTagList();
        Arrays.stream(components).map(NBTTagString::new).forEachOrdered(arg_0 -> ((NBTTagList)tagList).func_74742_a(arg_0));
        if (tagList.func_74745_c() > 0) {
            ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("components", (NBTBase)tagList);
            NBTTagList nbt = new NBTTagList();
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                nbt.func_74742_a((NBTBase)new NBTTagCompound());
            }
            ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("component_nbt", (NBTBase)nbt);
        }
        return stack;
    }

    @Override
    public ItemStack getBulletCore(String core, String coreType) {
        ItemStack stack = this.getStack(AmmoParts.CORE);
        ItemNBTHelper.setString((ItemStack)stack, (String)"core", (String)core);
        ItemNBTHelper.setString((ItemStack)stack, (String)"core_type", (String)coreType);
        return stack;
    }

    @Override
    public boolean isBulletCore(ItemStack stack) {
        return this.stackToSub(stack) == AmmoParts.CORE;
    }

    @Override
    public ItemStack setPaintColour(ItemStack stack, int color) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)"paint_color", (int)color);
        return stack;
    }

    @Override
    public ItemStack setComponentNBT(ItemStack stack, NBTTagCompound ... tagCompounds) {
        NBTTagList component_nbt = new NBTTagList();
        for (NBTTagCompound tagCompound : tagCompounds) {
            component_nbt.func_74742_a((NBTBase)tagCompound);
        }
        assert (stack.func_77978_p() != null);
        stack.func_77978_p().func_74782_a("component_nbt", (NBTBase)component_nbt);
        return stack;
    }

    @Override
    public String getName() {
        return this.NAME;
    }

    @Override
    public void setFuseType(ItemStack stack, AmmoRegistry.EnumFuseTypes type) {
        ItemNBTHelper.setString((ItemStack)stack, (String)"fuse", (String)type.func_176610_l());
    }

    @Override
    public AmmoRegistry.EnumFuseTypes getFuseType(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"fuse")) {
            this.makeDefault(stack);
        }
        return AmmoRegistry.EnumFuseTypes.v(ItemNBTHelper.getString((ItemStack)stack, (String)"fuse"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public FontRenderer getFontRenderer(@Nonnull ItemStack stack) {
        return IIClientUtils.fontRegular;
    }

    public String getModelCacheKey(ItemStack stack) {
        return String.format("%s%s_%s%s", ((AmmoParts)this.stackToSub(stack)).name(), this.NAME, this.getPaintColor(stack) == -1 ? "no_" : "paint_", this.getCoreType(stack).func_176610_l());
    }

    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        ArrayList<ResourceLocation> a = new ArrayList<ResourceLocation>();
        switch ((AmmoParts)this.stackToSub(stack)) {
            case BULLET: {
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/base"));
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/" + this.getCoreType(stack).func_176610_l()));
                if (this.getPaintColor(stack) == -1) break;
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/paint"));
                break;
            }
            case CORE: {
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/core"));
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/" + this.getCoreType(stack).func_176610_l()));
            }
        }
        return a;
    }

    public static enum AmmoParts implements IIItemEnum
    {
        BULLET,
        CORE;

    }
}

