/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.ammo;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.IEContent;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoUtils;
import pl.pabilo8.immersiveintelligence.client.model.IBulletModel;
import pl.pabilo8.immersiveintelligence.client.model.bullet.ModelGrenade;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIAmmoBase;

public class ItemIIAmmoGrenade
extends ItemIIAmmoBase {
    public ItemIIAmmoGrenade() {
        super("grenade_5bCal", null);
        this.func_77625_d(8);
    }

    @Override
    public float getComponentMultiplier() {
        return 0.45f;
    }

    @Override
    public int getCoreMaterialNeeded() {
        return 2;
    }

    @Override
    public float getInitialMass() {
        return 0.25f;
    }

    @Override
    public float getDefaultVelocity() {
        return IIConfigHandler.IIConfig.Ammunition.grenadeVelocity;
    }

    @Override
    public float getCaliber() {
        return 5.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Class<? extends IBulletModel> getModel() {
        return ModelGrenade.class;
    }

    @Override
    public float getDamage() {
        return 5.0f;
    }

    @Override
    public ItemStack getCasingStack(int amount) {
        return new ItemStack((Item)IEContent.itemMaterial, amount, 0);
    }

    @Override
    public AmmoRegistry.EnumCoreTypes[] getAllowedCoreTypes() {
        return new AmmoRegistry.EnumCoreTypes[]{AmmoRegistry.EnumCoreTypes.CANISTER};
    }

    @Override
    public AmmoRegistry.EnumFuseTypes[] getAllowedFuseTypes() {
        return new AmmoRegistry.EnumFuseTypes[]{AmmoRegistry.EnumFuseTypes.CONTACT, AmmoRegistry.EnumFuseTypes.TIMED};
    }

    @Override
    public void registerSprites(TextureMap map) {
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/base"));
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/core"));
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/core_classic"));
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/core_disp"));
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/paint"));
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/core_disp_classic"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColourForIEItem(ItemStack stack, int pass) {
        if (pass != 1) {
            return super.getColourForIEItem(stack, pass);
        }
        return IIConfigHandler.IIConfig.Weapons.Grenade.classicGrenades > 1 ? -1 : super.getColourForIEItem(stack, pass);
    }

    @Override
    public String getModelCacheKey(ItemStack stack) {
        return String.format("%s%s_%s%s", ((ItemIIAmmoBase.AmmoParts)this.stackToSub(stack)).getMeta(), this.NAME, this.getPaintColor(stack) == -1 ? "no_" : "paint_", IIConfigHandler.IIConfig.Weapons.Grenade.classicGrenades);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        ArrayList<ResourceLocation> a = new ArrayList<ResourceLocation>();
        switch ((ItemIIAmmoBase.AmmoParts)this.stackToSub(stack)) {
            case CORE: {
                if (IIConfigHandler.IIConfig.Weapons.Grenade.classicGrenades < 2) {
                    a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/core"));
                    break;
                }
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/core_classic"));
                break;
            }
            case BULLET: {
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/base"));
                if (IIConfigHandler.IIConfig.Weapons.Grenade.classicGrenades < 2) {
                    a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/core_disp"));
                } else {
                    a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/core_disp_classic"));
                }
                if (this.getPaintColor(stack) == -1) break;
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/paint"));
            }
        }
        return a;
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return 60;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void func_77615_a(@Nonnull ItemStack stack, World world, @Nonnull EntityLivingBase entity, int timeLeft) {
        if (!world.field_72995_K) {
            world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, IISounds.grenadeThrow, SoundCategory.PLAYERS, 1.0f, 1.0f);
            Vec3d vec = IIUtils.getVectorForRotation(entity.field_70125_A, entity.func_70079_am());
            Vec3d vv = entity.func_174791_d().func_72441_c(0.0, (double)entity.func_70047_e() - (double)0.1f, 0.0);
            EntityBullet a = AmmoUtils.createBullet(world, stack, vv, vec, Math.min(((float)this.func_77626_a(stack) - (float)timeLeft) / (float)this.func_77626_a(stack), 35.0f) * IIConfigHandler.IIConfig.Weapons.Grenade.throwSpeedModifier);
            a.setShooters((Entity)entity, new Entity[0]);
            a.fuse = (int)(60.0f / EntityBullet.DEV_SLOMO);
            world.func_72838_d((Entity)a);
            if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
    }
}

