/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.ammo;

import blusunrize.immersiveengineering.client.ClientUtils;
import javax.annotation.Nonnull;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.client.fx.particles.ParticleExplosion;
import pl.pabilo8.immersiveintelligence.client.model.IBulletModel;
import pl.pabilo8.immersiveintelligence.client.model.bullet.ModelBullet6bCal;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIAmmoBase;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIAmmoCasing;

public class ItemIIAmmoLightArtillery
extends ItemIIAmmoBase {
    public ItemIIAmmoLightArtillery() {
        super("artillery_6bCal", ItemIIAmmoCasing.Casings.LIGHT_ARTILLERY_6BCAL);
    }

    @Override
    public float getComponentMultiplier() {
        return 0.65f;
    }

    @Override
    public int getGunpowderNeeded() {
        return 450;
    }

    @Override
    public int getCoreMaterialNeeded() {
        return 3;
    }

    @Override
    public float getInitialMass() {
        return 0.85f;
    }

    @Override
    public float getDefaultVelocity() {
        return IIConfigHandler.IIConfig.Ammunition.lightHowiVelocity;
    }

    @Override
    public float getCaliber() {
        return 6.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Class<? extends IBulletModel> getModel() {
        return ModelBullet6bCal.class;
    }

    @Override
    public float getDamage() {
        return 30.0f;
    }

    @Override
    public AmmoRegistry.EnumCoreTypes[] getAllowedCoreTypes() {
        return new AmmoRegistry.EnumCoreTypes[]{AmmoRegistry.EnumCoreTypes.PIERCING, AmmoRegistry.EnumCoreTypes.SHAPED, AmmoRegistry.EnumCoreTypes.CANISTER};
    }

    @Override
    public AmmoRegistry.EnumFuseTypes[] getAllowedFuseTypes() {
        return new AmmoRegistry.EnumFuseTypes[]{AmmoRegistry.EnumFuseTypes.CONTACT, AmmoRegistry.EnumFuseTypes.TIMED, AmmoRegistry.EnumFuseTypes.PROXIMITY};
    }

    @Override
    public float getSupressionRadius() {
        return 3.0f;
    }

    @Override
    public int getSuppressionPower() {
        return 20;
    }

    @Override
    public boolean shouldLoadChunks() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void doPuff(EntityBullet bullet) {
        for (int i = 0; i < 20; ++i) {
            Vec3d v = bullet.getBaseMotion().func_178789_a(-90.0f).func_178785_b((float)i / 20.0f * 360.0f);
            ParticleExplosion particle = new ParticleExplosion((World)ClientUtils.mc().field_71441_e, bullet.func_174791_d(), v.func_186678_a(0.125), 3.25f);
            ParticleUtils.particleRenderer.addEffect(particle);
        }
    }
}

