/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.ammo;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.client.model.IBulletModel;
import pl.pabilo8.immersiveintelligence.client.model.bullet.ModelBulletMortar6bCal;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIAmmoBase;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIAmmoCasing;

public class ItemIIAmmoMortar
extends ItemIIAmmoBase {
    public ItemIIAmmoMortar() {
        super("mortar_6bCal", ItemIIAmmoCasing.Casings.MORTAR_6BCAL);
    }

    @Override
    public float getComponentMultiplier() {
        return 0.65f;
    }

    @Override
    public int getGunpowderNeeded() {
        return 350;
    }

    @Override
    public int getCoreMaterialNeeded() {
        return 3;
    }

    @Override
    public float getInitialMass() {
        return 1.125f;
    }

    @Override
    public float getDefaultVelocity() {
        return IIConfigHandler.IIConfig.Ammunition.mortarVelocity;
    }

    @Override
    public float getCaliber() {
        return 6.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Class<? extends IBulletModel> getModel() {
        return ModelBulletMortar6bCal.class;
    }

    @Override
    public float getDamage() {
        return 30.0f;
    }

    @Override
    public AmmoRegistry.EnumCoreTypes[] getAllowedCoreTypes() {
        return new AmmoRegistry.EnumCoreTypes[]{AmmoRegistry.EnumCoreTypes.PIERCING, AmmoRegistry.EnumCoreTypes.SHAPED, AmmoRegistry.EnumCoreTypes.CANISTER};
    }

    @Override
    public AmmoRegistry.EnumFuseTypes[] getAllowedFuseTypes() {
        return new AmmoRegistry.EnumFuseTypes[]{AmmoRegistry.EnumFuseTypes.CONTACT, AmmoRegistry.EnumFuseTypes.TIMED, AmmoRegistry.EnumFuseTypes.PROXIMITY};
    }

    @Override
    public float getSupressionRadius() {
        return 3.0f;
    }

    @Override
    public int getSuppressionPower() {
        return 20;
    }

    @Override
    public boolean shouldLoadChunks() {
        return true;
    }

    @Override
    public void registerSprites(TextureMap map) {
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/core"));
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/paint"));
        for (AmmoRegistry.EnumCoreTypes coreType : this.getAllowedCoreTypes()) {
            ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/" + coreType.func_176610_l()));
            ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/base_" + coreType.func_176610_l()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColourForIEItem(ItemStack stack, int pass) {
        switch ((ItemIIAmmoBase.AmmoParts)this.stackToSub(stack)) {
            case BULLET: {
                switch (pass) {
                    case 0: {
                        return this.getCore(stack).getColour();
                    }
                    case 1: {
                        return -1;
                    }
                    case 2: {
                        return this.getPaintColor(stack);
                    }
                }
            }
            case CORE: {
                return this.getCore(stack).getColour();
            }
        }
        return -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        ArrayList<ResourceLocation> a = new ArrayList<ResourceLocation>();
        switch ((ItemIIAmmoBase.AmmoParts)this.stackToSub(stack)) {
            case BULLET: {
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/" + this.getCoreType(stack).func_176610_l()));
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/base_" + this.getCoreType(stack).func_176610_l()));
                if (this.getPaintColor(stack) == -1) break;
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/paint"));
                break;
            }
            case CORE: {
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/core"));
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/" + this.getCoreType(stack).func_176610_l()));
            }
        }
        return a;
    }
}

