/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.ammo;

import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.api.utils.ItemTooltipHandler;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIISubItemsBase;

public class ItemIIBulletMagazine
extends ItemIISubItemsBase<Magazines>
implements IEItemInterfaces.ITextureOverride,
ItemTooltipHandler.IAdvancedTooltipItem {
    private final ResLoc magazineTexture = ResLoc.of(IIReference.RES_II, "items/bullets/magazines/");
    private final ResLoc bulletTexture = ResLoc.of(IIReference.RES_II, "items/bullets/magazines/common/bullet");
    private final ResLoc paintTexture = ResLoc.of(IIReference.RES_II, "items/bullets/magazines/common/paint");

    public ItemIIBulletMagazine() {
        super("bullet_magazine", 1, (Enum[])Magazines.values());
    }

    public void defaultize(ItemStack stack) {
        ItemStack bullet;
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullets")) {
            return;
        }
        for (int j = 0; j <= 3; ++j) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)("colour" + j), (int)-1);
        }
        NonNullList<ItemStack> cartridge = this.readInventory(stack);
        ArrayList<ItemStack> already = new ArrayList<ItemStack>();
        int i = 0;
        Iterator iterator = cartridge.iterator();
        while (iterator.hasNext() && !(bullet = (ItemStack)iterator.next()).func_190926_b() && i <= 3) {
            boolean contains = false;
            for (ItemStack s : already) {
                if (!ItemStack.func_77989_b((ItemStack)bullet, (ItemStack)s)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            already.add(bullet);
            ItemNBTHelper.setInt((ItemStack)stack, (String)("colour" + i), (int)((IAmmo)bullet.func_77973_b()).getPaintColor(bullet));
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)("bullet" + i), (boolean)true);
            ++i;
        }
        for (int j = 0; j <= 3; ++j) {
            if (already.size() >= j + 1) continue;
            ItemNBTHelper.remove((ItemStack)stack, (String)("bullet" + j));
            ItemNBTHelper.setInt((ItemStack)stack, (String)("colour" + j), (int)-1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int bullets = this.getRemainingBulletCount(stack);
        tooltip.add(IIUtils.getItalicString(I18n.func_135052_a((String)("desc.immersiveintelligence." + (bullets == 0 ? "bullet_magazine.empty" : "bullet_magazine.remaining")), (Object[])new Object[]{bullets})));
        NBTTagList listDict = ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"bullets").func_150295_c("dictionary", 10);
        if (ItemNBTHelper.getTag((ItemStack)stack).func_74764_b("bullet0")) {
            tooltip.add("   " + TextFormatting.GOLD + new ItemStack(listDict.func_150305_b(0)).func_82833_r());
        }
        if (ItemNBTHelper.getTag((ItemStack)stack).func_74764_b("bullet1")) {
            tooltip.add("   " + TextFormatting.GOLD + new ItemStack(listDict.func_150305_b(1)).func_82833_r());
        }
        if (ItemNBTHelper.getTag((ItemStack)stack).func_74764_b("bullet2")) {
            tooltip.add("   " + TextFormatting.GOLD + new ItemStack(listDict.func_150305_b(2)).func_82833_r());
        }
        if (ItemNBTHelper.getTag((ItemStack)stack).func_74764_b("bullet3")) {
            tooltip.add("   " + TextFormatting.GOLD + new ItemStack(listDict.func_150305_b(3)).func_82833_r());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addAdvancedInformation(ItemStack stack, int offsetX, List<Integer> offsetsY) {
        if (!this.hasNoBullets(stack)) {
            ItemTooltipHandler.drawItemList(offsetX, (int)offsetsY.get(0), ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"bullets").func_150295_c("dictionary", 10));
        }
    }

    public String getModelCacheKey(ItemStack stack) {
        return ((Magazines)this.stackToSub(stack)).func_176610_l() + "_" + this.checkBullets(stack) + "_" + this.checkColors(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        ArrayList<ResourceLocation> l = new ArrayList<ResourceLocation>();
        Magazines subItem = (Magazines)this.stackToSub(stack);
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet0") && subItem.hasDisplayTexture) {
            l.add(ResLoc.of(this.magazineTexture, subItem.func_176610_l(), "_disp"));
        } else {
            l.add(ResLoc.of(this.magazineTexture, subItem.func_176610_l()));
        }
        if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
            return l;
        }
        for (int i = 0; i < 3; ++i) {
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)("bullet" + i))) continue;
            l.add(ResLoc.of(this.bulletTexture, i));
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)("colour" + i)) || ItemNBTHelper.getInt((ItemStack)stack, (String)("colour" + i)) == -1) continue;
            l.add(ResLoc.of(this.paintTexture, i));
        }
        return l;
    }

    public int checkBullets(ItemStack stack) {
        this.defaultize(stack);
        if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
            return 0;
        }
        int num = ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet0") ? 1 : 0;
        num += ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet1") ? 1 : 0;
        num += ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet2") ? 1 : 0;
        return num += ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet3") ? 1 : 0;
    }

    public String checkColors(ItemStack stack) {
        if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
            return "";
        }
        StringBuilder ss = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)("colour" + i)) || ItemNBTHelper.getInt((ItemStack)stack, (String)("colour" + i)) == -1) continue;
            ss.append(i);
        }
        return ss.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomItemColours() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColourForIEItem(ItemStack stack, int pass) {
        switch (pass) {
            case 2: {
                return ItemNBTHelper.getInt((ItemStack)stack, (String)"colour0");
            }
            case 4: {
                return ItemNBTHelper.getInt((ItemStack)stack, (String)"colour1");
            }
            case 6: {
                return ItemNBTHelper.getInt((ItemStack)stack, (String)"colour2");
            }
            case 8: {
                return ItemNBTHelper.getInt((ItemStack)stack, (String)"colour3");
            }
        }
        return -1;
    }

    public int getRemainingBulletCount(ItemStack stack) {
        NBTTagCompound nbt = ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"bullets");
        return nbt.func_150295_c("inventory", 3).func_74745_c();
    }

    public NonNullList<ItemStack> readInventory(ItemStack stack) {
        Magazines magazine = (Magazines)this.stackToSub(stack);
        NBTTagCompound nbt = ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"bullets");
        NonNullList inv = NonNullList.func_191197_a((int)magazine.capacity, (Object)ItemStack.field_190927_a);
        ArrayList<ItemStack> dictionary = new ArrayList<ItemStack>();
        NBTTagList listDict = nbt.func_150295_c("dictionary", 10);
        NBTTagList listInventory = nbt.func_150295_c("inventory", 3);
        for (NBTBase tag : listDict) {
            if (!(tag instanceof NBTTagCompound)) continue;
            dictionary.add(new ItemStack((NBTTagCompound)tag));
        }
        if (dictionary.size() == 0) {
            return inv;
        }
        int max = listInventory.func_74745_c();
        for (int i = 0; i < Math.min(max, magazine.capacity); ++i) {
            int id = listInventory.func_186858_c(i);
            if (id < 0 || id >= dictionary.size()) continue;
            inv.set(i, (Object)((ItemStack)dictionary.get(id)).func_77946_l());
        }
        return inv;
    }

    public ItemStack writeInventory(ItemStack magazine, NonNullList<ItemStack> inv) {
        ArrayList<ItemStack> dictionary = new ArrayList<ItemStack>();
        NBTTagList invList = new NBTTagList();
        for (ItemStack stack2 : inv) {
            int id;
            if (stack2.func_190926_b()) continue;
            Optional<ItemStack> found = dictionary.stream().filter(stack1 -> ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)stack1, (ItemStack)stack2)).findFirst();
            if (!found.isPresent()) {
                dictionary.add(stack2);
                id = dictionary.size() - 1;
            } else {
                id = dictionary.indexOf(found.get());
            }
            invList.func_74742_a((NBTBase)new NBTTagInt(id));
        }
        NBTTagList dictList = new NBTTagList();
        dictionary.forEach(stack -> dictList.func_74742_a((NBTBase)stack.serializeNBT()));
        NBTTagCompound output = new NBTTagCompound();
        output.func_74782_a("dictionary", (NBTBase)dictList);
        output.func_74782_a("inventory", (NBTBase)invList);
        ItemNBTHelper.setTagCompound((ItemStack)magazine, (String)"bullets", (NBTTagCompound)output);
        return magazine;
    }

    public NonNullList<ItemStack> takeAll(ItemStack stack) {
        NonNullList<ItemStack> bullets = this.readInventory(stack);
        this.writeInventory(stack, (NonNullList<ItemStack>)NonNullList.func_191196_a());
        this.defaultize(stack);
        return bullets;
    }

    public ItemStack takeBullet(ItemStack stack, boolean doTake) {
        NonNullList<ItemStack> bullets = this.readInventory(stack);
        ItemStack ammo = ((ItemStack)bullets.get(0)).func_77946_l();
        if (!doTake) {
            return ammo;
        }
        bullets.set(0, (Object)ItemStack.field_190927_a);
        this.writeInventory(stack, bullets);
        this.defaultize(stack);
        return ammo;
    }

    public boolean hasNoBullets(ItemStack stack) {
        NBTTagCompound nbt = ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"bullets");
        return nbt.func_82582_d() || nbt.func_150295_c("inventory", 3).func_74745_c() == 0;
    }

    public ItemStack getMagazine(Magazines type, ItemStack ... bullets) {
        ItemStack stack = this.getStack(type, 1);
        NonNullList l = NonNullList.func_191197_a((int)type.capacity, (Object)ItemStack.field_190927_a);
        if (bullets.length > 0) {
            for (int i = 0; i < l.size(); ++i) {
                l.set(i, (Object)bullets[i % bullets.length]);
            }
        }
        this.writeInventory(stack, (NonNullList<ItemStack>)l);
        this.defaultize(stack);
        return stack;
    }

    public static enum Magazines implements IIItemEnum
    {
        MACHINEGUN(48, IIContent.itemAmmoMachinegun),
        SUBMACHINEGUN(24, IIContent.itemAmmoSubmachinegun, true),
        RIFLE(12, IIContent.itemAmmoMachinegun),
        SUBMACHINEGUN_DRUM(64, IIContent.itemAmmoSubmachinegun),
        ASSAULT_RIFLE(32, IIContent.itemAmmoAssaultRifle, true),
        AUTOCANNON(16, IIContent.itemAmmoAutocannon),
        CPDS_DRUM(128, IIContent.itemAmmoMachinegun),
        AUTOMATIC_REVOLVER(16, IIContent.itemAmmoRevolver);

        public final int capacity;
        public final IAmmo ammo;
        public final boolean hasDisplayTexture;

        private Magazines(int capacity, IAmmo ammo) {
            this(capacity, ammo, false);
        }

        private Magazines(int capacity, IAmmo ammo, boolean hasDisplayTexture) {
            this.capacity = capacity;
            this.ammo = ammo;
            this.hasDisplayTexture = hasDisplayTexture;
        }
    }
}

