/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.armor;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.ISerializableEnum;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIISubItemsBase;

public class ItemIIArmorUpgrade
extends ItemIISubItemsBase<ArmorUpgrades>
implements IUpgrade {
    public ItemIIArmorUpgrade() {
        super("armor_upgrade", 1, (Enum[])ArmorUpgrades.values());
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> list, @Nonnull ITooltipFlag flag) {
        ArmorUpgrades sub = (ArmorUpgrades)this.stackToSub(stack);
        for (ArmorTypes type : sub.toolset) {
            list.add(IIUtils.getHexCol(type.color, type.symbol + " " + I18n.func_135052_a((String)("desc.immersiveintelligence.toolupgrade.item." + type.func_176610_l()), (Object[])new Object[0])));
        }
        String[] flavour = ImmersiveEngineering.proxy.splitStringOnWidth(I18n.func_135052_a((String)("desc.immersiveintelligence.toolupgrade." + sub.func_176610_l()), (Object[])new Object[0]), 200);
        Arrays.stream(flavour).map(IIUtils::getItalicString).forEach(list::add);
    }

    public Set<String> getUpgradeTypes(ItemStack stack) {
        return ((ArmorUpgrades)this.stackToSub(stack)).toolset.stream().map(ISerializableEnum::func_176610_l).map(String::toUpperCase).collect(Collectors.toSet());
    }

    public boolean canApplyUpgrades(ItemStack target, ItemStack upgrade) {
        if (target.func_77973_b() instanceof IUpgradeableTool) {
            return ((ArmorUpgrades)this.stackToSub(upgrade)).check.test(target, upgrade);
        }
        return false;
    }

    public void applyUpgrades(ItemStack target, ItemStack upgrade, NBTTagCompound modifications) {
        ((ArmorUpgrades)this.stackToSub(upgrade)).function.accept(upgrade, modifications);
    }

    public static enum ArmorUpgrades implements IIItemEnum
    {
        GASMASK((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_HELMET), new String[0]),
        INFILTRATOR_GEAR((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_HELMET), "infiltrator_gear", "engineer_gear"),
        TECHNICIAN_GEAR((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_HELMET), "technician_gear", "engineer_gear"),
        ENGINEER_GEAR((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_HELMET), "technician_gear", "infiltrator_gear"),
        STEEL_ARMOR_PLATES((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_HELMET, (Object)ArmorTypes.LIGHT_ENGINEER_CHESTPLATE, (Object)ArmorTypes.LIGHT_ENGINEER_LEGGINGS), (upgrade, modifications) -> {
            modifications.func_74757_a("steel_plates", true);
            modifications.func_74780_a("toughness_increase", (double)upgrade.func_190916_E() * 0.5);
            modifications.func_74780_a("armor_increase", (double)upgrade.func_190916_E());
        }, "composite_plates"),
        COMPOSITE_ARMOR_PLATES((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_HELMET, (Object)ArmorTypes.LIGHT_ENGINEER_CHESTPLATE, (Object)ArmorTypes.LIGHT_ENGINEER_LEGGINGS), (upgrade, modifications) -> {
            modifications.func_74757_a("composite_plates", true);
            modifications.func_74780_a("toughness_increase", (double)upgrade.func_190916_E());
            modifications.func_74780_a("armor_increase", (double)upgrade.func_190916_E());
        }, "steel_plates"),
        HAZMAT_COATING((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_HELMET, (Object)ArmorTypes.LIGHT_ENGINEER_CHESTPLATE, (Object)ArmorTypes.LIGHT_ENGINEER_LEGGINGS, (Object)ArmorTypes.LIGHT_ENGINEER_BOOTS), (upgrade, modifications) -> modifications.func_74757_a("hazmat", true), new String[0]),
        HEAT_RESISTANT_COATING((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_CHESTPLATE), new String[0]),
        ANTI_STATIC_MESH((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_CHESTPLATE), "camo_mesh", "ir_mesh"),
        CAMOUFLAGE_MESH((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_CHESTPLATE), (upgrade, modifications) -> modifications.func_74757_a("camo_mesh", true), "anti_static_mesh", "ir_mesh"),
        INFRARED_ABSORBING_MESH((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_CHESTPLATE), (upgrade, modifications) -> modifications.func_74757_a("ir_mesh", true), "anti_static_mesh", "camo_mesh"),
        SCUBA_TANK((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_CHESTPLATE), (upgrade, modifications) -> modifications.func_74757_a("scuba", true), new String[0]),
        HELIPACK((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_CHESTPLATE), new String[0]),
        EXOSKELETON((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_LEGGINGS), new String[0]),
        BOOT_REINFORCEMENT((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_BOOTS), (upgrade, modifications) -> {
            modifications.func_74757_a("reinforced", true);
            modifications.func_74780_a("toughness_increase", 1.0);
            modifications.func_74780_a("armor_increase", 1.0);
        }, new String[0]),
        SNOW_RACKETS((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_BOOTS), "flippers"),
        FLIPPERS((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_BOOTS), "snow_rackets"),
        INTERNAL_SPRINGS((ImmutableSet<ArmorTypes>)ImmutableSet.of((Object)ArmorTypes.LIGHT_ENGINEER_BOOTS), new String[0]);

        private final ImmutableSet<ArmorTypes> toolset;
        private final BiPredicate<ItemStack, ItemStack> check;
        private final BiConsumer<ItemStack, NBTTagCompound> function;

        private ArmorUpgrades(ImmutableSet<ArmorTypes> types, String ... incompatible) {
            this.toolset = types;
            this.check = this.createCheck(incompatible);
            this.function = (upgrade, modifications) -> modifications.func_74757_a(this.func_176610_l(), true);
        }

        private ArmorUpgrades(ImmutableSet<ArmorTypes> types, BiConsumer<ItemStack, NBTTagCompound> function, String ... incompatible) {
            this.toolset = types;
            this.check = this.createCheck(incompatible);
            this.function = function;
        }

        private BiPredicate<ItemStack, ItemStack> createCheck(String ... incompatible) {
            return (target, upgrade) -> {
                NBTTagCompound upgrades = ((IUpgradeableTool)target.func_77973_b()).getUpgrades(target);
                if (upgrades.func_74764_b(this.func_176610_l())) {
                    return false;
                }
                for (String s : incompatible) {
                    if (!upgrades.func_74764_b(s)) continue;
                    return false;
                }
                return true;
            };
        }
    }

    public static enum ArmorTypes implements ISerializableEnum
    {
        LIGHT_ENGINEER_HELMET(16746560, '\u24be'),
        LIGHT_ENGINEER_CHESTPLATE(0xCC6C33, '\u24bf'),
        LIGHT_ENGINEER_LEGGINGS(16737344, '\u24c0'),
        LIGHT_ENGINEER_BOOTS(13389875, '\u24c1');

        private final int color;
        private final char symbol;

        private ArmorTypes(int color, char symbol) {
            this.color = color;
            this.symbol = symbol;
        }
    }
}

