/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.crafting;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.crafting.PrecissionAssemblerRecipe;
import pl.pabilo8.immersiveintelligence.api.utils.ItemTooltipHandler;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIIBase;

public class ItemIIAssemblyScheme
extends ItemIIBase
implements ItemTooltipHandler.IAdvancedTooltipItem {
    private static final String descriptionKey = "desc.immersiveintelligence.assembly_scheme.";

    public ItemIIAssemblyScheme() {
        super("assembly_scheme", 8);
    }

    @SideOnly(value=Side.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        ItemStack s = ItemNBTHelper.getItemStack((ItemStack)stack, (String)"recipeItem");
        tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.assembly_scheme.used_to_create", (Object[])new Object[]{TextFormatting.GOLD + s.func_82833_r() + (s.func_190916_E() > 1 ? TextFormatting.GRAY + " x " + TextFormatting.GOLD + s.func_190916_E() : "")}));
        tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.assembly_scheme.items_created", (Object[])new Object[]{TextFormatting.GOLD + String.valueOf(ItemNBTHelper.getInt((ItemStack)stack, (String)"createdItems"))}));
        PrecissionAssemblerRecipe recipe = this.getRecipeForStack(stack);
        if (ItemTooltipHandler.addExpandableTooltip(42, "desc.immersiveintelligence.assembly_scheme.info_hold1", tooltip)) {
            tooltip.add(IIUtils.getHexCol(IIReference.COLORS_HIGHLIGHT_S[1], I18n.func_135052_a((String)"desc.immersiveintelligence.assembly_scheme.materials", (Object[])new Object[0])));
            if (recipe != null) {
                for (IngredientStack ingredientStack : recipe.inputs) {
                    tooltip.add("   " + TextFormatting.GOLD + ingredientStack.getExampleStack().func_82833_r() + (ingredientStack.inputSize > 1 ? TextFormatting.GRAY + " x " + TextFormatting.GOLD + ingredientStack.inputSize : ""));
                }
            }
        }
        if (ItemTooltipHandler.addExpandableTooltip(29, "desc.immersiveintelligence.assembly_scheme.info_hold2", tooltip)) {
            tooltip.add(IIUtils.getHexCol(IIReference.COLORS_HIGHLIGHT_S[0], I18n.func_135052_a((String)"desc.immersiveintelligence.assembly_scheme.tools", (Object[])new Object[0])));
            if (recipe != null) {
                for (String string : recipe.tools) {
                    tooltip.add("   " + TextFormatting.GOLD + PrecissionAssemblerRecipe.getExampleToolStack(string).func_82833_r());
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addAdvancedInformation(ItemStack stack, int offsetX, List<Integer> offsetsY) {
        PrecissionAssemblerRecipe recipe = this.getRecipeForStack(stack);
        if (recipe == null) {
            return;
        }
        boolean upper = ItemTooltipHandler.canExpandTooltip(42);
        if (upper) {
            ItemTooltipHandler.drawItemList(offsetX, (int)offsetsY.get(0), (ItemStack[])Arrays.stream(recipe.inputs).map(IngredientStack::getExampleStack).toArray(ItemStack[]::new));
        }
        if (ItemTooltipHandler.addExpandableTooltip(29, "", null)) {
            ItemTooltipHandler.drawItemList(offsetX, (int)offsetsY.get(upper ? 1 : 0), (ItemStack[])Arrays.stream(recipe.tools).map(PrecissionAssemblerRecipe::getExampleToolStack).toArray(ItemStack[]::new));
        }
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"createdItems")) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"createdItems", (int)0);
        }
    }

    public ItemStack getStackForRecipe(PrecissionAssemblerRecipe recipe) {
        ItemStack stack = new ItemStack((Item)this);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("recipeItem", (NBTBase)recipe.output.serializeNBT());
        stack.func_77982_d(tag);
        return stack;
    }

    public ItemStack getProducedStack(ItemStack scheme) {
        if (ItemNBTHelper.hasKey((ItemStack)scheme, (String)"recipeItem")) {
            return new ItemStack(ItemNBTHelper.getTagCompound((ItemStack)scheme, (String)"recipeItem"));
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public PrecissionAssemblerRecipe getRecipeForStack(ItemStack stack) {
        NBTTagCompound tag = ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"recipeItem");
        ItemStack recipe_stack = new ItemStack(tag);
        for (PrecissionAssemblerRecipe recipe : PrecissionAssemblerRecipe.recipeList) {
            if (!recipe.output.func_77969_a(recipe_stack)) continue;
            return recipe;
        }
        return null;
    }

    public void increaseCreatedItems(ItemStack stack, int amount) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)"createdItems", (int)(ItemNBTHelper.getInt((ItemStack)stack, (String)"createdItems") + amount));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (PrecissionAssemblerRecipe recipe : PrecissionAssemblerRecipe.recipeList) {
                ItemStack stack = new ItemStack((Item)this);
                ItemNBTHelper.setTagCompound((ItemStack)stack, (String)"recipeItem", (NBTTagCompound)recipe.output.serializeNBT());
                list.add((Object)stack);
            }
        }
    }
}

