/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.crafting;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.crafting.PrecissionAssemblerRecipe;
import pl.pabilo8.immersiveintelligence.api.utils.tools.IPrecisionTool;
import pl.pabilo8.immersiveintelligence.client.render.multiblock.metal.PrecisionAssemblerRenderer;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIISubItemsBase;

public class ItemIIPrecisionTool
extends ItemIISubItemsBase<PrecisionTools>
implements IPrecisionTool {
    public ItemIIPrecisionTool() {
        super("precission_tool", 1, (Enum[])PrecisionTools.values());
        for (PrecisionTools e : (PrecisionTools[])this.getSubItems()) {
            PrecissionAssemblerRecipe.registerToolType(e.func_176610_l(), this);
        }
    }

    @ParametersAreNonnullByDefault
    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        ItemNBTHelper.setInt((ItemStack)stack, (String)"damage", (int)this.getPrecissionToolMaxDamage(stack));
    }

    @Override
    public String getPrecissionToolType(ItemStack stack) {
        return this.getSubNames()[((PrecisionTools)this.stackToSub(stack)).ordinal()];
    }

    @Override
    public void damagePrecissionTool(ItemStack stack, int amount) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"damage")) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"damage", (int)this.getPrecissionToolMaxDamage(stack));
        }
        ItemNBTHelper.setInt((ItemStack)stack, (String)"damage", (int)(this.getPrecissionToolDamage(stack) - amount));
        if (this.getPrecissionToolDamage(stack) < 0) {
            stack.func_190920_e(0);
        }
    }

    @Override
    public int getPrecissionToolDamage(ItemStack stack) {
        return ItemNBTHelper.hasKey((ItemStack)stack, (String)"damage") ? ItemNBTHelper.getInt((ItemStack)stack, (String)"damage") : this.getPrecissionToolMaxDamage(stack);
    }

    @Override
    public int getPrecissionToolMaxDamage(ItemStack stack) {
        return ((PrecisionTools)this.stackToSub(stack)).durability;
    }

    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"info.immersiveintelligence.tool_durability", (Object[])new Object[]{TextFormatting.GOLD.toString() + this.getPrecissionToolDamage(stack) + TextFormatting.GRAY, TextFormatting.GOLD.toString() + this.getPrecissionToolMaxDamage(stack) + TextFormatting.GRAY}));
    }

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        return ItemNBTHelper.hasKey((ItemStack)stack, (String)"damage") && (double)this.getPrecissionToolDamage(stack) / (double)this.getPrecissionToolMaxDamage(stack) != 1.0;
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        return 1.0 - (double)this.getPrecissionToolDamage(stack) / (double)this.getPrecissionToolMaxDamage(stack);
    }

    @Override
    public int getWorkTime(String tool_name) {
        return ((PrecisionTools)this.nameToSub(tool_name)).usageTime;
    }

    @Override
    @Nonnull
    public ItemStack getToolPresentationStack(@Nonnull String toolName) {
        return this.getStack(this.nameToSub(toolName), 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @ParametersAreNonnullByDefault
    public void renderInMachine(ItemStack stack, float progress, float angle, float maxProgress, ItemStack renderedStack) {
        switch ((PrecisionTools)this.stackToSub(stack)) {
            case BUZZSAW: {
                PrecisionAssemblerRenderer.modelBuzzsaw.renderProgress(progress, angle, maxProgress);
                break;
            }
            case DRILL: {
                PrecisionAssemblerRenderer.modelDrill.renderProgress(progress, angle, maxProgress);
                break;
            }
            case INSERTER: {
                PrecisionAssemblerRenderer.modelInserter.renderProgress(progress, angle, maxProgress, renderedStack);
                break;
            }
            case SOLDERER: {
                PrecisionAssemblerRenderer.modelSolderer.renderProgress(progress, angle, maxProgress);
                break;
            }
            case WELDER: {
                PrecisionAssemblerRenderer.modelWelder.renderProgress(progress, angle, maxProgress);
                break;
            }
            case HAMMER: {
                PrecisionAssemblerRenderer.modelHammer.renderProgress(progress, angle, maxProgress);
            }
        }
    }

    public static enum PrecisionTools implements IIItemEnum
    {
        BUZZSAW(IIConfigHandler.IIConfig.Tools.precissionToolBuzzsawDurability, IIConfigHandler.IIConfig.Tools.precissionToolBuzzsawUsageTime),
        DRILL(IIConfigHandler.IIConfig.Tools.precissionToolDrillDurability, IIConfigHandler.IIConfig.Tools.precissionToolDrillUsageTime),
        INSERTER(IIConfigHandler.IIConfig.Tools.precissionToolInserterDurability, IIConfigHandler.IIConfig.Tools.precissionToolInserterUsageTime),
        SOLDERER(IIConfigHandler.IIConfig.Tools.precissionToolSoldererDurability, IIConfigHandler.IIConfig.Tools.precissionToolSoldererUsageTime),
        WELDER(IIConfigHandler.IIConfig.Tools.precissionToolWelderDurability, IIConfigHandler.IIConfig.Tools.precissionToolWelderUsageTime),
        HAMMER(IIConfigHandler.IIConfig.Tools.precissionToolHammerDurability, IIConfigHandler.IIConfig.Tools.precissionToolHammerUsageTime);

        private final int durability;
        private final int usageTime;

        private PrecisionTools(int durability, int usageTime) {
            this.durability = durability;
            this.usageTime = usageTime;
        }
    }
}

