/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.crafting;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.api.crafting.SawmillRecipe;
import pl.pabilo8.immersiveintelligence.api.utils.tools.ISawblade;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIISubItemsBase;

public class ItemIISawBlade
extends ItemIISubItemsBase<SawBlades>
implements ISawblade {
    private static final String NBT_DAMAGE = "damage";

    public ItemIISawBlade() {
        super("sawblade", 1, (Enum[])SawBlades.values());
        for (SawBlades sawBlade : SawBlades.values()) {
            SawmillRecipe.registerSawblade(sawBlade.func_176610_l(), this);
        }
    }

    public void func_77622_d(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        ItemNBTHelper.setInt((ItemStack)stack, (String)NBT_DAMAGE, (int)this.getSawbladeMaxDamage(stack));
    }

    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"info.immersiveintelligence.tool_durability", (Object[])new Object[]{TextFormatting.GOLD.toString() + this.getSawbladeDamage(stack) + TextFormatting.GRAY, TextFormatting.GOLD.toString() + this.getSawbladeMaxDamage(stack) + TextFormatting.GRAY}));
    }

    @Override
    public String getMaterialName(ItemStack stack) {
        return ((SawBlades)this.stackToSub(stack)).func_176610_l();
    }

    @Override
    public void damageSawblade(ItemStack stack, int amount) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)NBT_DAMAGE)) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)NBT_DAMAGE, (int)this.getSawbladeMaxDamage(stack));
        }
        ItemNBTHelper.setInt((ItemStack)stack, (String)NBT_DAMAGE, (int)(this.getSawbladeDamage(stack) - amount));
        if (this.getSawbladeDamage(stack) < 0) {
            stack.func_190920_e(0);
        }
    }

    @Override
    public int getSawbladeDamage(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)NBT_DAMAGE)) {
            return this.getSawbladeMaxDamage(stack);
        }
        return ItemNBTHelper.getInt((ItemStack)stack, (String)NBT_DAMAGE);
    }

    @Override
    public int getSawbladeMaxDamage(ItemStack stack) {
        return ((SawBlades)this.stackToSub((ItemStack)stack)).durability;
    }

    @Override
    public int getHardness(ItemStack stack) {
        return ((SawBlades)this.stackToSub((ItemStack)stack)).hardness;
    }

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        return this.getSawbladeDamage(stack) != this.getSawbladeMaxDamage(stack);
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        return 1.0 - (double)this.getSawbladeDamage(stack) / (double)this.getSawbladeDamage(stack);
    }

    @Override
    @Nonnull
    public ItemStack getToolPresentationStack(String toolName) {
        Optional<SawBlades> found = Arrays.stream(SawBlades.values()).filter(s -> s.func_176610_l().equals(toolName)).findFirst();
        return this.getStack((Enum)found.orElse(SawBlades.IRON));
    }

    @Override
    public ResourceLocation getSawbladeTexture(ItemStack stack) {
        return ((SawBlades)this.stackToSub((ItemStack)stack)).texture;
    }

    public static enum SawBlades implements IIItemEnum
    {
        IRON(2, IIConfigHandler.IIConfig.Tools.sawbladeIronDurability),
        STEEL(3, IIConfigHandler.IIConfig.Tools.sawbladeSteelDurability),
        TUNGSTEN(4, IIConfigHandler.IIConfig.Tools.sawbladeTungstenDurability);

        final int hardness;
        final int durability;
        final ResourceLocation texture;

        private SawBlades(int hardness, int durability) {
            this.hardness = hardness;
            this.durability = durability;
            this.texture = ResLoc.of(IIReference.RES_II, "blocks/multiblock/sawmill/" + this.func_176610_l());
        }
    }
}

