/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.data;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import pl.pabilo8.immersiveintelligence.api.data.DataOperations;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataStorageItem;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeExpression;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.utils.ItemTooltipHandler;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.util.ISerializableEnum;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIISubItemsBase;

public class ItemIIFunctionalCircuit
extends ItemIISubItemsBase<Circuits>
implements IDataStorageItem,
ItemTooltipHandler.IAdvancedTooltipItem {
    private static DataPacket lastStored = null;
    private static Circuits last = null;
    private static IDataType[] lastTooltip = null;
    private static IDataType[] lastStoredTooltip = null;

    public ItemIIFunctionalCircuit() {
        super("circuit_functional", 1, (Enum[])Circuits.values());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, List<String> tooltip, @Nonnull ITooltipFlag flag) {
        if (ItemTooltipHandler.addExpandableTooltip(42, "desc.immersiveintelligence.functional_circuit_shift", tooltip)) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.functional_circuit", (Object[])new Object[0]));
            this.getOperationsList(stack).stream().map(s -> "   " + I18n.func_135052_a((String)("datasystem.immersiveintelligence.function." + s), (Object[])new Object[0])).forEach(tooltip::add);
        }
        if (ItemTooltipHandler.addExpandableTooltip(29, "desc.immersiveintelligence.functional_circuit_ctrl", tooltip)) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.functional_circuit_data", (Object[])new Object[0]));
            for (IDataType type : this.getStoredData(stack)) {
                if (!(type instanceof DataTypeExpression)) continue;
                tooltip.add("   " + I18n.func_135052_a((String)("datasystem.immersiveintelligence.function." + ((DataTypeExpression)type).getOperation().name), (Object[])new Object[0]));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addAdvancedInformation(ItemStack stack, int offsetX, List<Integer> offsetsY) {
        GlStateManager.func_179109_b((float)offsetX, (float)offsetsY.get(0).intValue(), (float)700.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        boolean b = ItemTooltipHandler.canExpandTooltip(42);
        if (b) {
            IDataType[] types;
            if (last == IIContent.itemCircuit.stackToSub(stack)) {
                types = lastTooltip;
            } else {
                lastTooltip = types = (IDataType[])IIContent.itemCircuit.getOperationsList(stack).stream().map(o -> DataPacket.getVarInstance(DataOperations.getOperationInstance((String)o).expectedResult)).toArray(IDataType[]::new);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int i = 0; i < types.length; ++i) {
                ClientUtils.bindTexture((String)types[i].textureLocation());
                Gui.func_146110_a((int)0, (int)(i * 20), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            }
        }
        if (ItemTooltipHandler.canExpandTooltip(29)) {
            IDataType[] types;
            DataPacket storedData = this.getStoredData(stack);
            if (storedData.equals(lastStored)) {
                types = lastStoredTooltip;
            } else {
                lastStoredTooltip = types = (IDataType[])storedData.variables.values().stream().filter(o -> o instanceof DataTypeExpression).map(o -> DataPacket.getVarInstance(((DataTypeExpression)o).getOperation().expectedResult)).toArray(IDataType[]::new);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int off = offsetsY.get(b ? 1 : 0) - offsetsY.get(0);
            for (int i = 0; i < types.length; ++i) {
                ClientUtils.bindTexture((String)types[i].textureLocation());
                Gui.func_146110_a((int)0, (int)(off + i * 20), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public FontRenderer getFontRenderer(@Nonnull ItemStack stack) {
        return IIClientUtils.fontRegular;
    }

    @Override
    public DataPacket getStoredData(ItemStack stack) {
        DataPacket data = new DataPacket();
        data.fromNBT(ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"operations"));
        return data;
    }

    @Override
    public void writeDataToItem(DataPacket packet, ItemStack stack) {
        ItemNBTHelper.setTagCompound((ItemStack)stack, (String)"operations", (NBTTagCompound)packet.toNBT());
    }

    public List<String> getOperationsList(ItemStack stack) {
        if (stack.func_77960_j() < Circuits.values().length) {
            Circuits circuit = Circuits.values()[stack.func_77960_j()];
            return Arrays.asList(circuit.functions);
        }
        return Collections.emptyList();
    }

    public String getTESRRenderTexture(ItemStack stack) {
        return ((Circuits)this.stackToSub((ItemStack)stack)).tier.texture;
    }

    public static enum CircuitTypes implements ISerializableEnum
    {
        BASIC("basic_circuits", "circuitBasic"),
        ADVANCED("advanced_circuits", "circuitAdvanced"),
        CRYPTOGRAPHIC("cryptography_circuits", "circuitCryptographic"),
        PROCESSOR("processor_circuits", "circuitProcessor");

        public final String texture;
        public final String material;

        private CircuitTypes(String texture, String material) {
            this.texture = texture;
            this.material = material;
        }
    }

    public static enum Circuits implements IIItemEnum
    {
        ARITHMETIC(CircuitTypes.BASIC, "add", "subtract", "multiply", "divide", "modulo", "abs"),
        ADVANCED_ARITHMETIC(CircuitTypes.ADVANCED, ARITHMETIC, "power", "root", "min", "max", "sign", "ceil", "round", "floor", "sin", "cos", "tan"),
        LOGIC(CircuitTypes.BASIC, "and", "or", "not"),
        COMPARATOR(CircuitTypes.BASIC, "greater", "less", "greater_or_equal", "less_or_equal", "equal"),
        ADVANCED_LOGIC(CircuitTypes.ADVANCED, LOGIC, "nand", "nor", "xor", "xnor"),
        TEXT(CircuitTypes.BASIC, "string_join", "equal", "string_split", "string_length", "string_char_at", "string_substring", "string_trim", "string_hexcol", "string_format", "string_contains", "string_contains_count", "string_replace_first", "string_replace_all", "string_lowercase", "string_uppercase", "string_snake_case", "string_camel_case", "string_reverse"),
        ITEMSTACK(CircuitTypes.ADVANCED, "get_quantity", "set_quantity", "get_durability", "set_durability", "get_nbt", "set_nbt", "get_itemstack", "get_item_id", "can_stack_with", "matches_oredict"),
        ARRAY(CircuitTypes.BASIC, "array_get", "array_set", "array_length", "array_push", "array_pop", "array_swap"),
        ENTITY(CircuitTypes.ADVANCED, "entity_get_id", "entity_get_type", "entity_get_name", "entity_get_dimension_id", "entity_get_x", "entity_get_y", "entity_get_z"),
        DOCUMENT(CircuitTypes.ADVANCED, "document_read_page", "document_read_all_pages_array", "document_read_all_pages_string", "document_get_author", "document_get_title"),
        TYPE_CONVERSION(CircuitTypes.BASIC, "is_null", "to_integer", "to_float", "to_string", "to_boolean", "to_null"),
        FLUIDSTACK(CircuitTypes.BASIC, "is_null", "to_integer", "to_float", "to_string", "to_boolean", "to_null"),
        MAP(CircuitTypes.BASIC, "is_null", "to_integer", "to_float", "to_string", "to_boolean", "to_null"),
        VECTOR_ARITHMETIC(CircuitTypes.PROCESSOR, "is_null", "to_integer", "to_float", "to_string", "to_boolean", "to_null"),
        CRYPTOGRAPHER(CircuitTypes.CRYPTOGRAPHIC, "encrypt_text", "encrypt_number", "decrypt_text", "decrypt_number");

        private final String[] functions;
        public final CircuitTypes tier;

        private Circuits(CircuitTypes tier, String ... functions) {
            this.tier = tier;
            this.functions = functions;
        }

        private Circuits(CircuitTypes tier, Circuits parent, String ... functions) {
            this(tier, (String[])ArrayUtils.addAll((Object[])parent.functions, (Object[])functions));
        }

        public String[] getFunctions() {
            return this.functions;
        }
    }
}

