/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.mechanical;

import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.rotary.IModelMotorBelt;
import pl.pabilo8.immersiveintelligence.api.rotary.IMotorBeltConnector;
import pl.pabilo8.immersiveintelligence.api.rotary.RotaryUtils;
import pl.pabilo8.immersiveintelligence.client.model.motor_belt.ModelClothMotorBelt;
import pl.pabilo8.immersiveintelligence.client.model.motor_belt.ModelSteelMotorBelt;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.util.IBatchOredictRegister;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIISubItemsBase;
import pl.pabilo8.immersiveintelligence.common.wire.IIMotorBeltType;

@IBatchOredictRegister(oreDict={"motorBelt"})
public class ItemIIMotorBelt
extends ItemIISubItemsBase<MotorBelt>
implements IWireCoil {
    public ItemIIMotorBelt() {
        super("motor_belt", 64, (Enum[])MotorBelt.values());
    }

    public WireType getWireType(ItemStack stack) {
        return ((MotorBelt)this.stackToSub((ItemStack)stack)).type;
    }

    public boolean canConnectCable(ItemStack stack, TileEntity targetEntity) {
        return targetEntity instanceof IMotorBeltConnector;
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        int[] link = ItemNBTHelper.getIntArray((ItemStack)stack, (String)"linkingPos");
        if (link.length > 3) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        return RotaryUtils.useCoil(this, player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void setRenderModels() {
        MotorBelt.CLOTH.model = new ModelClothMotorBelt();
        MotorBelt.STEEL.model = new ModelSteelMotorBelt();
        MotorBelt.RUBBER.model = new ModelClothMotorBelt();
    }

    public static enum MotorBelt implements IIItemEnum
    {
        CLOTH("light_belts", IIConfigHandler.IIConfig.MechanicalDevices.beltLength[0], 1, 6, IIConfigHandler.IIConfig.MechanicalDevices.beltMaxTorque[0], IIConfigHandler.IIConfig.MechanicalDevices.beltTorqueLoss[0]),
        STEEL("heavy_belts", IIConfigHandler.IIConfig.MechanicalDevices.beltLength[1], 1, 8, IIConfigHandler.IIConfig.MechanicalDevices.beltMaxTorque[1], IIConfigHandler.IIConfig.MechanicalDevices.beltTorqueLoss[1]),
        RUBBER("light_belts", IIConfigHandler.IIConfig.MechanicalDevices.beltLength[2], 1, 6, IIConfigHandler.IIConfig.MechanicalDevices.beltMaxTorque[2], IIConfigHandler.IIConfig.MechanicalDevices.beltTorqueLoss[2]);

        public final String category;
        public final int maxTorque;
        public final float torqueLoss;
        public final int length;
        public final int thickness;
        public final int width;
        public final IIMotorBeltType type;
        public final ResourceLocation res;
        @SideOnly(value=Side.CLIENT)
        public IModelMotorBelt model;

        private MotorBelt(String category, int length, int thickness, int width, int maxTorque, float torqueLoss) {
            this.category = category;
            this.length = length;
            this.thickness = thickness;
            this.maxTorque = maxTorque;
            this.torqueLoss = torqueLoss;
            this.width = width;
            this.res = MotorBelt.getResourceLocation(this.func_176610_l());
            this.type = new IIMotorBeltType(this);
        }

        private static ResourceLocation getResourceLocation(String name) {
            return new ResourceLocation("immersiveintelligence", "textures/rotary/belts/" + name);
        }

        @SideOnly(value=Side.CLIENT)
        public IModelMotorBelt getModel() {
            return this.model;
        }
    }
}

