/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.mechanical;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.rotary.IMotorGear;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.util.IBatchOredictRegister;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIISubItemsBase;

@IBatchOredictRegister(oreDict={"gear"})
public class ItemIIMotorGear
extends ItemIISubItemsBase<MotorGear>
implements IMotorGear {
    public ItemIIMotorGear() {
        super("motor_gear", 64, (Enum[])MotorGear.values());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        float mod = this.getGearTorqueModifier(stack);
        float speed = mod < 1.0f && mod != 0.0f ? 1.0f / mod : 1.0f;
        float torque = mod >= 1.0f ? mod : 1.0f;
        tooltip.add(I18n.func_135052_a((String)"info.immersiveintelligence.gear_ratio", (Object[])new Object[]{speed == (float)((int)speed) ? String.valueOf((int)speed) : String.valueOf(speed), torque == (float)((int)torque) ? String.valueOf((int)torque) : String.valueOf(torque)}));
    }

    @Override
    public float getGearTorqueModifier(ItemStack stack) {
        return ((MotorGear)this.stackToSub((ItemStack)stack)).torqueMod;
    }

    public static enum MotorGear implements IIItemEnum
    {
        COPPER(IIConfigHandler.IIConfig.MechanicalDevices.gearTorqueModifier[0]),
        BRASS(IIConfigHandler.IIConfig.MechanicalDevices.gearTorqueModifier[1]),
        IRON(IIConfigHandler.IIConfig.MechanicalDevices.gearTorqueModifier[2]),
        STEEL(IIConfigHandler.IIConfig.MechanicalDevices.gearTorqueModifier[3]),
        TUNGSTEN(IIConfigHandler.IIConfig.MechanicalDevices.gearTorqueModifier[4]);

        final float torqueMod;

        private MotorGear(float torqueMod) {
            this.torqueMod = torqueMod;
        }
    }
}

