/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.tools;

import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import pl.pabilo8.immersiveintelligence.api.utils.tools.IAdvancedZoomTool;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.entity.vehicle.EntityFieldHowitzer;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIISubItemsBase;

public class ItemIIBinoculars
extends ItemIISubItemsBase<Binoculars>
implements IAdvancedZoomTool,
EnergyHelper.IIEEnergyItem,
IEItemInterfaces.ITextureOverride {
    private static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("immersiveintelligence", "textures/gui/item/binoculars.png");
    public static UUID visionUUID = Utils.generateNewUUID();

    public ItemIIBinoculars() {
        super("binoculars", 1, (Enum[])Binoculars.values());
    }

    public boolean isAdvanced(ItemStack stack) {
        return this.stackToSub(stack) == Binoculars.INFRARED_BINOCULARS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        list.add(IIUtils.getItalicString(I18n.func_135052_a((String)"desc.immersiveintelligence.binoculars", (Object[])new Object[0])));
        if (this.isAdvanced(stack)) {
            String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{TextFormatting.GOLD + stored + TextFormatting.RESET}));
            list.add(I18n.func_135052_a((String)("desc.immersiveintelligence." + (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"enabled") ? "infrared_enabled" : "infrared_disabled")), (Object[])new Object[]{stored}));
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        boolean do_tick;
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        boolean bl = do_tick = worldIn.func_82737_E() % 20L == 0L;
        if (worldIn.field_72995_K) {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)"sneaking", (entityIn.func_70093_af() && isSelected ? 1 : 0) != 0);
        }
        if (!worldIn.field_72995_K && entityIn instanceof EntityLivingBase) {
            if (!isSelected || !entityIn.func_70093_af() && !(entityIn.func_184208_bv() instanceof EntityFieldHowitzer) && do_tick) {
                if (this.isAdvanced(stack)) {
                    ItemNBTHelper.setBoolean((ItemStack)stack, (String)"enabled", (boolean)false);
                    if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"wasUsed")) {
                        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"wasUsed", (boolean)false);
                        ((EntityLivingBase)entityIn).func_184589_d(MobEffects.field_76439_r);
                    }
                }
            } else {
                if (entityIn instanceof EntityPlayerMP && worldIn.func_82737_E() % 5L == 0L && (entityIn.func_70093_af() || entityIn.func_184208_bv() instanceof EntityFieldHowitzer)) {
                    float yaw = (360.0f + ((EntityLivingBase)entityIn).field_70759_as) % 360.0f;
                    IIPacketHandler.sendChatTranslation((EntityPlayer)((EntityPlayerMP)entityIn), "info.immersiveintelligence.yaw", Float.valueOf(yaw));
                }
                if (do_tick && this.isEnabled(stack) && this.isAdvanced(stack)) {
                    if (worldIn.func_175724_o(entityIn.func_180425_c()) <= 0.5f) {
                        ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76439_r, 240, 1, true, false));
                    } else {
                        ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 240, 1, false, false));
                    }
                    ItemNBTHelper.setBoolean((ItemStack)stack, (String)"wasUsed", (boolean)true);
                    this.extractEnergy(stack, IIConfigHandler.IIConfig.Tools.advancedBinocularsEnergyUsage, false);
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemNBTHelper.setBoolean((ItemStack)playerIn.func_184586_b(handIn), (String)"enabled", (!ItemNBTHelper.getBoolean((ItemStack)playerIn.func_184586_b(handIn), (String)"enabled") ? 1 : 0) != 0);
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public boolean shouldZoom(ItemStack stack, EntityPlayer player) {
        return player.func_70093_af() && player.field_191988_bg == 0.0f;
    }

    @Override
    public float[] getZoomSteps(ItemStack stack, EntityPlayer player) {
        return this.isAdvanced(stack) ? IIConfigHandler.IIConfig.Tools.advancedBinocularsMaxZoom : IIConfigHandler.IIConfig.Tools.binocularsMaxZoom;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.isAdvanced(container) ? IIConfigHandler.IIConfig.Tools.advancedBinocularsEnergyCapacity : 0;
    }

    @Override
    public ResourceLocation getZoomOverlayTexture(ItemStack stack, EntityPlayer player) {
        return OVERLAY_TEXTURE;
    }

    @SideOnly(value=Side.CLIENT)
    public String getModelCacheKey(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"sneaking") ? "invisible" : (this.isAdvanced(stack) ? "infrared_binoculars_" + (this.isEnabled(stack) ? "on" : "off") : "binoculars");
    }

    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        if (key.equals("invisible")) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ResourceLocation("immersiveintelligence:items/binoculars/" + key));
    }

    boolean isEnabled(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"enabled") && this.getEnergyStored(stack) >= IIConfigHandler.IIConfig.Tools.advancedBinocularsEnergyUsage;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_190926_b() && this.isAdvanced(stack)) {
            return new IEItemStackHandler(stack){
                final EnergyHelper.ItemEnergyStorage energyStorage;
                {
                    super(x0);
                    this.energyStorage = new EnergyHelper.ItemEnergyStorage(stack);
                }

                public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                    return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
                }

                public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    if (capability == CapabilityEnergy.ENERGY) {
                        return (T)this.energyStorage;
                    }
                    if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                        return (T)((Object)this);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0f - (float)this.getEnergyStored(stack) / (float)this.getMaxEnergyStored(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77960_j() == 1 && this.getEnergyStored(stack) < this.getMaxEnergyStored(stack);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111265_b.func_111108_a(), (Object)new AttributeModifier(visionUUID, "Increased Sight Range (Mobs)", 30.0, 0));
        }
        return multimap;
    }

    public static enum Binoculars implements IIItemEnum
    {
        BINOCULARS,
        INFRARED_BINOCULARS;

    }
}

