/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.tools;

import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.api.utils.ItemTooltipHandler;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.common.CommonProxy;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.crafting.IIRecipes;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIBulletMagazine;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemStackHandler;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIIBase;

public class ItemIICasingPouch
extends ItemIIBase
implements IEItemInterfaces.ITextureOverride,
IIItemStackHandler.IInventoryItem,
ItemTooltipHandler.IGuiItem {
    public ItemIICasingPouch() {
        super("casing_pouch", 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> info, ITooltipFlag flag) {
        super.func_77624_a(stack, world, info, flag);
        info.add(IIUtils.getItalicString(I18n.func_135052_a((String)"desc.immersiveintelligence.casing_pouch", (Object[])new Object[0])));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            return super.func_77659_a(world, player, hand);
        }
        CommonProxy.openGuiForItem(player, hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            TileEntity tileEntity = world.func_175625_s(pos);
            ItemStack stack = player.func_184586_b(hand);
            IItemHandler capStack = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            boolean inserted = false;
            if (tileEntity != null && capStack != null) {
                for (int i = 0; i < this.getSlotCount(); ++i) {
                    ItemStack stackInside = capStack.extractItem(i, 64, false);
                    if (stackInside.func_190926_b()) continue;
                    if ((stackInside = Utils.insertStackIntoInventory((TileEntity)tileEntity, (ItemStack)stackInside, (EnumFacing)facing)).func_190926_b()) {
                        inserted = true;
                    }
                    capStack.insertItem(i, stackInside, false);
                }
            }
            if (inserted) {
                return EnumActionResult.SUCCESS;
            }
            player.func_184609_a(hand);
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public IIGuiList getGUI(ItemStack stack) {
        return IIGuiList.GUI_CASING_POUCH;
    }

    @SideOnly(value=Side.CLIENT)
    public String getModelCacheKey(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"open")) {
            return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"contains") ? "filled" : "empty";
        }
        return "closed";
    }

    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        switch (key) {
            case "filled": {
                return Collections.singletonList(ResLoc.of(IIReference.RES_II, "items/casing_pouch/filled"));
            }
            case "empty": {
                return Collections.singletonList(ResLoc.of(IIReference.RES_II, "items/casing_pouch/empty"));
            }
        }
        return Collections.singletonList(ResLoc.of(IIReference.RES_II, "items/casing_pouch/closed"));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (!stack.func_190926_b()) {
            return new IIItemStackHandler(stack){

                @Nonnull
                public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                    if (this.isItemValid(slot, stack)) {
                        return super.insertItem(slot, stack, simulate);
                    }
                    return stack;
                }

                public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                    return slot < 12 ? IIRecipes.AMMO_CASINGS.matchesItemStackIgnoringSize(stack) : stack.func_77973_b() instanceof ItemIIBulletMagazine;
                }
            };
        }
        return null;
    }

    @Override
    public int getSlotCount() {
        return 18;
    }
}

