/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.tools;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RotationUtil;
import blusunrize.immersiveengineering.common.util.advancements.IEAdvancements;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIIBase;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.IIMultiblockInterfaces;

public class ItemIIElectricHammer
extends ItemIIBase
implements ITool,
EnergyHelper.IIEEnergyItem {
    public ItemIIElectricHammer() {
        super("electric_hammer", 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        int i;
        String s;
        NBTTagList tagList;
        String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
        list.add(IIUtils.getItalicString(I18n.func_135052_a((String)"desc.immersiveintelligence.electric_hammer", (Object[])new Object[0])));
        list.add(IIUtils.getItalicString(I18n.func_135052_a((String)"info.immersiveintelligence.charge_with_if", (Object[])new Object[0])));
        list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{TextFormatting.GOLD + stored + TextFormatting.RESET}));
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblockPermission")) {
            tagList = stack.func_77978_p().func_150295_c("multiblockPermission", 8);
            s = I18n.func_135052_a((String)"desc.immersiveengineering.info.multiblocksAllowed", (Object[])new Object[0]);
            if (!GuiScreen.func_146272_n()) {
                list.add(s + " " + I18n.func_135052_a((String)"desc.immersiveengineering.info.holdShift", (Object[])new Object[0]));
            } else {
                list.add(s);
                for (i = 0; i < tagList.func_74745_c(); ++i) {
                    list.add(TextFormatting.DARK_GRAY + " " + I18n.func_135052_a((String)("desc.immersiveengineering.info.multiblocks." + tagList.func_150307_f(i)), (Object[])new Object[0]));
                }
            }
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblockInterdiction")) {
            tagList = stack.func_77978_p().func_150295_c("multiblockInterdiction", 8);
            s = I18n.func_135052_a((String)"desc.immersiveengineering.info.multiblockForbidden", (Object[])new Object[0]);
            if (!GuiScreen.func_146272_n()) {
                list.add(s + " " + I18n.func_135052_a((String)"desc.immersiveengineering.info.holdShift", (Object[])new Object[0]));
            } else {
                list.add(s);
                for (i = 0; i < tagList.func_74745_c(); ++i) {
                    list.add(TextFormatting.DARK_GRAY + " " + I18n.func_135052_a((String)("desc.immersiveengineering.info.multiblocks." + tagList.func_150307_f(i)), (Object[])new Object[0]));
                }
            }
        }
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_190926_b()) {
            return new IEItemStackHandler(stack){
                final EnergyHelper.ItemEnergyStorage energyStorage;
                {
                    super(x0);
                    this.energyStorage = new EnergyHelper.ItemEnergyStorage(stack);
                }

                public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                    return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
                }

                public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    if (capability == CapabilityEnergy.ENERGY) {
                        return (T)this.energyStorage;
                    }
                    if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                        return (T)((Object)this);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        int i;
        NBTTagList list;
        ItemStack stack = player.func_184586_b(hand);
        TileEntity tile = world.func_175625_s(pos);
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"forbidHammer", (boolean)IIContent.tileEntitiesWeDontLike.stream().anyMatch(tileEntityPredicate -> tileEntityPredicate.test(tile)));
        String[] permittedMultiblocks = null;
        String[] interdictedMultiblocks = null;
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblockPermission")) {
            list = stack.func_77978_p().func_150295_c("multiblockPermission", 8);
            permittedMultiblocks = new String[list.func_74745_c()];
            for (i = 0; i < permittedMultiblocks.length; ++i) {
                permittedMultiblocks[i] = list.func_150307_f(i);
            }
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblockInterdiction")) {
            list = stack.func_77978_p().func_150295_c("multiblockInterdiction", 8);
            interdictedMultiblocks = new String[list.func_74745_c()];
            for (i = 0; i < interdictedMultiblocks.length; ++i) {
                interdictedMultiblocks[i] = list.func_150307_f(i);
            }
        }
        for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
            boolean b;
            if (!mb.isBlockTrigger(world.func_180495_p(pos))) continue;
            boolean bl = b = permittedMultiblocks == null;
            if (permittedMultiblocks != null) {
                for (String s : permittedMultiblocks) {
                    if (!mb.getUniqueName().equalsIgnoreCase(s)) continue;
                    b = true;
                }
            }
            if (!b) break;
            if (interdictedMultiblocks != null) {
                for (String s : interdictedMultiblocks) {
                    if (!mb.getUniqueName().equalsIgnoreCase(s)) continue;
                    b = false;
                }
            }
            if (!b) break;
            if (MultiblockHandler.fireMultiblockFormationEventPre((EntityPlayer)player, (MultiblockHandler.IMultiblock)mb, (BlockPos)pos, (ItemStack)stack).isCanceled() || !mb.createStructure(world, pos, side, player)) continue;
            if (player instanceof EntityPlayerMP) {
                IEAdvancements.TRIGGER_MULTIBLOCK.trigger((EntityPlayerMP)player, mb, stack);
            }
            return this.doAction(player, hand);
        }
        if (this.performHammerFunctions(player, world, pos, side, hitX, hitY, hitZ, hand)) {
            return this.doAction(player, hand);
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IIMultiblockInterfaces.IAdvancedMultiblockTileEntity mb;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IIMultiblockInterfaces.IAdvancedMultiblockTileEntity && !(mb = (IIMultiblockInterfaces.IAdvancedMultiblockTileEntity)tileEntity).isConstructionFinished()) {
            int energy = player.func_184812_l_() ? 999999 : ((IEnergyStorage)player.func_184586_b(hand).getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(IIConfigHandler.IIConfig.Tools.electricHammerEnergyPerUseConstruction, false);
            if (energy > 0) {
                mb.setCurrentConstruction(mb.getCurrentConstruction() + energy);
                world.func_184133_a(null, pos, IISounds.constructionHammer, SoundCategory.PLAYERS, 0.5f, 1.0f);
                return this.doAction(player, hand);
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (this.getToolClasses(stack).contains(toolClass) && this.hasEnoughEnergy(stack)) {
            return 4;
        }
        return -1;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean isTool(ItemStack item) {
        return true;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        return !player.field_70170_p.field_72995_K && RotationUtil.rotateEntity((Entity)entity, (EntityPlayer)player);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0f - (float)this.getEnergyStored(stack) / (float)this.getMaxEnergyStored(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) < this.getMaxEnergyStored(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xFF0000;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.hasEnoughEnergy(stack)) {
            for (String type : this.getToolClasses(stack)) {
                if (!state.func_177230_c().isToolEffective(type, state)) continue;
                return 16.0f;
            }
        }
        return super.func_150893_a(stack, state);
    }

    boolean performHammerFunctions(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        boolean b;
        TileEntity tile = world.func_175625_s(pos);
        IBlockState state = world.func_180495_p(pos);
        if (!(tile instanceof IEBlockInterfaces.IDirectionalTile) && !(tile instanceof IEBlockInterfaces.IHammerInteraction) && !(tile instanceof IEBlockInterfaces.IConfigurableSides) && this.hasEnoughEnergy(player.func_184586_b(hand)) && RotationUtil.rotateBlock((World)world, (BlockPos)pos, (EnumFacing)side)) {
            ((IEnergyStorage)player.func_184586_b(hand).getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(IIConfigHandler.IIConfig.Tools.electricHammerEnergyPerUse, false);
            return true;
        }
        if (tile == null) {
            return false;
        }
        if (tile instanceof IEBlockInterfaces.IConfigurableSides && !world.field_72995_K) {
            int iSide = player.func_70093_af() ? side.func_176734_d().ordinal() : side.ordinal();
            return ((IEBlockInterfaces.IConfigurableSides)tile).toggleSide(iSide, player);
        }
        if (IIContent.tileEntitiesWeDontLike.stream().noneMatch(tileEntityPredicate -> tileEntityPredicate.test(tile)) && tile instanceof IEBlockInterfaces.IDirectionalTile && ((IEBlockInterfaces.IDirectionalTile)tile).canHammerRotate(side, hitX, hitY, hitZ, (EntityLivingBase)player) && !world.field_72995_K) {
            EnumFacing f;
            EnumFacing oldF = f = ((IEBlockInterfaces.IDirectionalTile)tile).getFacing();
            int limit = ((IEBlockInterfaces.IDirectionalTile)tile).getFacingLimitation();
            if (limit == 0) {
                f = EnumFacing.field_82609_l[(f.ordinal() + 1) % EnumFacing.field_82609_l.length];
            } else if (limit == 1) {
                f = player.func_70093_af() ? f.func_176732_a(side.func_176740_k()).func_176734_d() : f.func_176732_a(side.func_176740_k());
            } else if (limit == 2 || limit == 5) {
                f = player.func_70093_af() ? f.func_176735_f() : f.func_176746_e();
            }
            ((IEBlockInterfaces.IDirectionalTile)tile).setFacing(f);
            ((IEBlockInterfaces.IDirectionalTile)tile).afterRotation(oldF, f);
            tile.func_70296_d();
            world.func_184138_a(pos, state, state, 3);
            world.func_175641_c(tile.func_174877_v(), tile.func_145838_q(), 255, 0);
            return true;
        }
        if (tile instanceof IEBlockInterfaces.IHammerInteraction && !world.field_72995_K && (b = ((IEBlockInterfaces.IHammerInteraction)tile).hammerUseSide(side, player, hitX, hitY, hitZ))) {
            return b;
        }
        return false;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return IIConfigHandler.IIConfig.Tools.electricHammerCapacity;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(IIConfigHandler.IIConfig.Tools.electricHammerEnergyPerUse, false);
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"forbidHammer")) {
            return ImmutableSet.of((Object)"II_ADVANCED_HAMMER");
        }
        return ImmutableSet.of((Object)"II_ADVANCED_HAMMER", (Object)"IE_HAMMER");
    }

    public boolean canHarvestBlock(@Nonnull IBlockState state, ItemStack stack) {
        if (this.hasEnoughEnergy(stack)) {
            if (state.func_177230_c() instanceof BlockIEBase) {
                return ((BlockIEBase)state.func_177230_c()).allowHammerHarvest(state);
            }
            if (state.func_177230_c().isToolEffective("IE_HAMMER", state)) {
                return true;
            }
            return state.func_177230_c().isToolEffective("II_ADVANCED_HAMMER", state);
        }
        return false;
    }

    public boolean hasEnoughEnergy(ItemStack stack) {
        return ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() >= IIConfigHandler.IIConfig.Tools.electricHammerEnergyPerUse;
    }

    private EnumActionResult doAction(EntityPlayer player, EnumHand hand) {
        player.func_184609_a(hand);
        return EnumActionResult.SUCCESS;
    }
}

