/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.item.tools;

import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.LighterFuelHandler;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIIBase;

public class ItemIILighter
extends ItemIIBase
implements ITool {
    public ItemIILighter() {
        super("lighter", 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
        if (fs != null) {
            TextFormatting rarity = fs.getFluid().getRarity() == EnumRarity.COMMON ? TextFormatting.GRAY : fs.getFluid().getRarity().getColor();
            list.add(rarity + fs.getLocalizedName() + TextFormatting.GRAY + ": " + fs.amount + "/" + IIConfigHandler.IIConfig.Tools.lighterCapacity + "mB");
        } else {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.drill.empty", (Object[])new Object[0]));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        pos = pos.func_177972_a(side);
        ItemStack stack = player.func_184586_b(hand);
        IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (!player.func_175151_a(pos, side, stack)) {
            return EnumActionResult.PASS;
        }
        if (LighterFuelHandler.isValidFuel(FluidUtil.getFluidContained((ItemStack)stack)) && LighterFuelHandler.getBurnQuantity(FluidUtil.getFluidContained((ItemStack)stack)) <= FluidUtil.getFluidContained((ItemStack)stack).amount) {
            if (world.func_175623_d(pos)) {
                world.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 11);
            }
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
            cap.drain(LighterFuelHandler.getBurnQuantity(FluidUtil.getFluidContained((ItemStack)stack)), true);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return ItemNBTHelper.hasKey((ItemStack)stack, (String)"lighterDrain") || FluidUtil.getFluidContained((ItemStack)stack) != null;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"lighterDrain")) {
            ItemStack ret = stack.func_77946_l();
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)ret);
            handler.drain(ItemNBTHelper.getInt((ItemStack)ret, (String)"lighterDrain"), true);
            ItemNBTHelper.remove((ItemStack)ret, (String)"lighterDrain");
            return ret;
        }
        if (FluidUtil.getFluidContained((ItemStack)stack) != null) {
            ItemStack ret = stack.func_77946_l();
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)ret);
            handler.drain(IIConfigHandler.IIConfig.Tools.lighterCapacity, true);
            return ret;
        }
        return stack;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
        return fluidStack != null;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
        return fluidStack != null ? IIUtils.RGBAToRGB(fluidStack.getFluid().getColor()) : 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
        return fluidStack != null ? (double)(1.0f - (float)fluidStack.amount / (float)IIConfigHandler.IIConfig.Tools.lighterCapacity) : 0.0;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_190926_b()) {
            return new FluidHandlerItemStack(stack, IIConfigHandler.IIConfig.Tools.lighterCapacity);
        }
        return null;
    }

    public boolean isTool(ItemStack item) {
        return true;
    }
}

